# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawDataClient, RawDataClient


class DataClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDataClient
        """
        return self._raw_client

    def get(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        Parameters
        ----------
        document_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Success
        """
        with self._raw_client.get(document_id, request_options=request_options) as r:
            yield from r.data


class AsyncDataClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDataClient
        """
        return self._raw_client

    async def get(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Parameters
        ----------
        document_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Success
        """
        async with self._raw_client.get(document_id, request_options=request_options) as r:
            async for _chunk in r.data:
                yield _chunk
