# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.bank_verification_response import BankVerificationResponse
from .raw_client import AsyncRawEnrichmentsClient, RawEnrichmentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EnrichmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEnrichmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEnrichmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEnrichmentsClient
        """
        return self._raw_client

    def bank_account_verify(
        self,
        *,
        token_id: str,
        country_code: typing.Optional[str] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BankVerificationResponse:
        """
        Parameters
        ----------
        token_id : str

        country_code : typing.Optional[str]

        routing_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BankVerificationResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.enrichments.bank_account_verify(
            token_id="token_id",
        )
        """
        _response = self._raw_client.bank_account_verify(
            token_id=token_id, country_code=country_code, routing_number=routing_number, request_options=request_options
        )
        return _response.data


class AsyncEnrichmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEnrichmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEnrichmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEnrichmentsClient
        """
        return self._raw_client

    async def bank_account_verify(
        self,
        *,
        token_id: str,
        country_code: typing.Optional[str] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BankVerificationResponse:
        """
        Parameters
        ----------
        token_id : str

        country_code : typing.Optional[str]

        routing_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BankVerificationResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.enrichments.bank_account_verify(
                token_id="token_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.bank_account_verify(
            token_id=token_id, country_code=country_code, routing_number=routing_number, request_options=request_options
        )
        return _response.data
