# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.google_pay_tokenize_response import GooglePayTokenizeResponse
from ..types.google_payment_method_token import GooglePaymentMethodToken
from .raw_client import AsyncRawGooglepayClient, RawGooglepayClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class GooglepayClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGooglepayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGooglepayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGooglepayClient
        """
        return self._raw_client

    def tokenize(
        self,
        *,
        google_payment_method_token: typing.Optional[GooglePaymentMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GooglePayTokenizeResponse:
        """
        Parameters
        ----------
        google_payment_method_token : typing.Optional[GooglePaymentMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GooglePayTokenizeResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.googlepay.tokenize()
        """
        _response = self._raw_client.tokenize(
            google_payment_method_token=google_payment_method_token, request_options=request_options
        )
        return _response.data


class AsyncGooglepayClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGooglepayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGooglepayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGooglepayClient
        """
        return self._raw_client

    async def tokenize(
        self,
        *,
        google_payment_method_token: typing.Optional[GooglePaymentMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GooglePayTokenizeResponse:
        """
        Parameters
        ----------
        google_payment_method_token : typing.Optional[GooglePaymentMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GooglePayTokenizeResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.googlepay.tokenize()


        asyncio.run(main())
        """
        _response = await self._raw_client.tokenize(
            google_payment_method_token=google_payment_method_token, request_options=request_options
        )
        return _response.data
