# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.card import Card
from ..types.cardholder_info import CardholderInfo
from ..types.network_token import NetworkToken
from ..types.network_token_cryptogram import NetworkTokenCryptogram
from .raw_client import AsyncRawNetworkTokensClient, RawNetworkTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NetworkTokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNetworkTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNetworkTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNetworkTokensClient
        """
        return self._raw_client

    def create(
        self,
        *,
        data: typing.Optional[Card] = OMIT,
        token_id: typing.Optional[str] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        cardholder_info: typing.Optional[CardholderInfo] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NetworkToken:
        """
        Parameters
        ----------
        data : typing.Optional[Card]

        token_id : typing.Optional[str]

        token_intent_id : typing.Optional[str]

        cardholder_info : typing.Optional[CardholderInfo]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.create()
        """
        _response = self._raw_client.create(
            data=data,
            token_id=token_id,
            token_intent_id=token_intent_id,
            cardholder_info=cardholder_info,
            request_options=request_options,
        )
        return _response.data

    def cryptogram(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkTokenCryptogram:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkTokenCryptogram
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.cryptogram(
            id="id",
        )
        """
        _response = self._raw_client.cryptogram(id, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def suspend(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.suspend(
            id="id",
        )
        """
        _response = self._raw_client.suspend(id, request_options=request_options)
        return _response.data

    def resume(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.network_tokens.resume(
            id="id",
        )
        """
        _response = self._raw_client.resume(id, request_options=request_options)
        return _response.data


class AsyncNetworkTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNetworkTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNetworkTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNetworkTokensClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        data: typing.Optional[Card] = OMIT,
        token_id: typing.Optional[str] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        cardholder_info: typing.Optional[CardholderInfo] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NetworkToken:
        """
        Parameters
        ----------
        data : typing.Optional[Card]

        token_id : typing.Optional[str]

        token_intent_id : typing.Optional[str]

        cardholder_info : typing.Optional[CardholderInfo]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            data=data,
            token_id=token_id,
            token_intent_id=token_intent_id,
            cardholder_info=cardholder_info,
            request_options=request_options,
        )
        return _response.data

    async def cryptogram(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> NetworkTokenCryptogram:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkTokenCryptogram
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.cryptogram(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cryptogram(id, request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def suspend(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.suspend(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.suspend(id, request_options=request_options)
        return _response.data

    async def resume(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> NetworkToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NetworkToken
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.network_tokens.resume(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.resume(id, request_options=request_options)
        return _response.data
