# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.application import Application
from ..types.proxy import Proxy
from ..types.proxy_transform import ProxyTransform
from .raw_client import AsyncRawProxiesClient, RawProxiesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProxiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProxiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProxiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProxiesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Proxy]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Proxy]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.proxies.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id=id, name=name, page=page, start=start, size=size, request_options=request_options
        )

    def create(
        self,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Proxy:
        """
        Parameters
        ----------
        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.proxies.create(
            name="name",
            destination_url="destination_url",
        )
        """
        _response = self._raw_client.create(
            name=name,
            destination_url=destination_url,
            request_reactor_id=request_reactor_id,
            response_reactor_id=response_reactor_id,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Proxy:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.proxies.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Proxy:
        """
        Parameters
        ----------
        id : str

        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.proxies.update(
            id="id",
            name="name",
            destination_url="destination_url",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            destination_url=destination_url,
            request_reactor_id=request_reactor_id,
            response_reactor_id=response_reactor_id,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.proxies.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        destination_url: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        destination_url : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.proxies.patch(
            id="id",
        )
        """
        _response = self._raw_client.patch(
            id,
            name=name,
            destination_url=destination_url,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data


class AsyncProxiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProxiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProxiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProxiesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Proxy]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Proxy]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.proxies.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id=id, name=name, page=page, start=start, size=size, request_options=request_options
        )

    async def create(
        self,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Proxy:
        """
        Parameters
        ----------
        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.proxies.create(
                name="name",
                destination_url="destination_url",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            destination_url=destination_url,
            request_reactor_id=request_reactor_id,
            response_reactor_id=response_reactor_id,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Proxy:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.proxies.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Proxy:
        """
        Parameters
        ----------
        id : str

        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Proxy
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.proxies.update(
                id="id",
                name="name",
                destination_url="destination_url",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            destination_url=destination_url,
            request_reactor_id=request_reactor_id,
            response_reactor_id=response_reactor_id,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.proxies.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        destination_url: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        destination_url : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.proxies.patch(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            id,
            name=name,
            destination_url=destination_url,
            request_transform=request_transform,
            response_transform=response_transform,
            application=application,
            configuration=configuration,
            require_auth=require_auth,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data
