# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.application import Application
from ..types.problem_details import ProblemDetails
from ..types.proxy import Proxy
from ..types.proxy_paginated_list import ProxyPaginatedList
from ..types.proxy_transform import ProxyTransform
from ..types.validation_problem_details import ValidationProblemDetails

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawProxiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Proxy]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Proxy]
            Success
        """
        page = page if page is not None else 1

        _response = self._client_wrapper.httpx_client.request(
            "proxies",
            method="GET",
            params={
                "id": id,
                "name": name,
                "page": page,
                "start": start,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ProxyPaginatedList,
                    parse_obj_as(
                        type_=ProxyPaginatedList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    id=id,
                    name=name,
                    page=page + 1,
                    start=start,
                    size=size,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Proxy]:
        """
        Parameters
        ----------
        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Proxy]
            Created
        """
        _response = self._client_wrapper.httpx_client.request(
            "proxies",
            method="POST",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_reactor_id": request_reactor_id,
                "response_reactor_id": response_reactor_id,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Proxy]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Proxy]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Proxy]:
        """
        Parameters
        ----------
        id : str

        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Proxy]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_reactor_id": request_reactor_id,
                "response_reactor_id": response_reactor_id,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        destination_url: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        destination_url : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/merge-patch+json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawProxiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Proxy]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Proxy]
            Success
        """
        page = page if page is not None else 1

        _response = await self._client_wrapper.httpx_client.request(
            "proxies",
            method="GET",
            params={
                "id": id,
                "name": name,
                "page": page,
                "start": start,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ProxyPaginatedList,
                    parse_obj_as(
                        type_=ProxyPaginatedList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        id=id,
                        name=name,
                        page=page + 1,
                        start=start,
                        size=size,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Proxy]:
        """
        Parameters
        ----------
        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Proxy]
            Created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "proxies",
            method="POST",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_reactor_id": request_reactor_id,
                "response_reactor_id": response_reactor_id,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Proxy]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Proxy]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: str,
        destination_url: str,
        request_reactor_id: typing.Optional[str] = OMIT,
        response_reactor_id: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Proxy]:
        """
        Parameters
        ----------
        id : str

        name : str

        destination_url : str

        request_reactor_id : typing.Optional[str]

        response_reactor_id : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Proxy]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_reactor_id": request_reactor_id,
                "response_reactor_id": response_reactor_id,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Proxy,
                    parse_obj_as(
                        type_=Proxy,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        destination_url: typing.Optional[str] = OMIT,
        request_transform: typing.Optional[ProxyTransform] = OMIT,
        response_transform: typing.Optional[ProxyTransform] = OMIT,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        require_auth: typing.Optional[bool] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        destination_url : typing.Optional[str]

        request_transform : typing.Optional[ProxyTransform]

        response_transform : typing.Optional[ProxyTransform]

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        require_auth : typing.Optional[bool]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"proxies/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "destination_url": destination_url,
                "request_transform": convert_and_respect_annotation_metadata(
                    object_=request_transform, annotation=ProxyTransform, direction="write"
                ),
                "response_transform": convert_and_respect_annotation_metadata(
                    object_=response_transform, annotation=ProxyTransform, direction="write"
                ),
                "application": convert_and_respect_annotation_metadata(
                    object_=application, annotation=Application, direction="write"
                ),
                "configuration": configuration,
                "require_auth": require_auth,
            },
            headers={
                "content-type": "application/merge-patch+json",
                "BT-IDEMPOTENCY-KEY": str(idempotency_key) if idempotency_key is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationProblemDetails,
                        parse_obj_as(
                            type_=ValidationProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ProblemDetails,
                        parse_obj_as(
                            type_=ProblemDetails,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
