# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.application import Application
from ..types.async_react_response import AsyncReactResponse
from ..types.react_response import ReactResponse
from ..types.reactor import Reactor
from .raw_client import AsyncRawReactorsClient, RawReactorsClient
from .results.client import AsyncResultsClient, ResultsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ReactorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawReactorsClient(client_wrapper=client_wrapper)
        self.results = ResultsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawReactorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawReactorsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Reactor]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Reactor]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.reactors.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id=id, name=name, page=page, start=start, size=size, request_options=request_options
        )

    def create(
        self,
        *,
        name: str,
        code: str,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Reactor:
        """
        Parameters
        ----------
        name : str

        code : str

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.create(
            name="name",
            code="code",
        )
        """
        _response = self._raw_client.create(
            name=name,
            code=code,
            application=application,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Reactor:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: str,
        code: str,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Reactor:
        """
        Parameters
        ----------
        id : str

        name : str

        code : str

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.update(
            id="id",
            name="name",
            code="code",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            code=code,
            application=application,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        application: typing.Optional[Application] = OMIT,
        code: typing.Optional[str] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        application : typing.Optional[Application]

        code : typing.Optional[str]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.patch(
            id="id",
        )
        """
        _response = self._raw_client.patch(
            id,
            name=name,
            application=application,
            code=code,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def react(
        self,
        id: str,
        *,
        args: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReactResponse:
        """
        Parameters
        ----------
        id : str

        args : typing.Optional[typing.Optional[typing.Any]]

        callback_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReactResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.react(
            id="id",
        )
        """
        _response = self._raw_client.react(id, args=args, callback_url=callback_url, request_options=request_options)
        return _response.data

    def react_async(
        self,
        id: str,
        *,
        args: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncReactResponse:
        """
        Parameters
        ----------
        id : str

        args : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncReactResponse
            Accepted

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.react_async(
            id="id",
        )
        """
        _response = self._raw_client.react_async(id, args=args, request_options=request_options)
        return _response.data


class AsyncReactorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawReactorsClient(client_wrapper=client_wrapper)
        self.results = AsyncResultsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawReactorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawReactorsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Reactor]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Reactor]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.reactors.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id=id, name=name, page=page, start=start, size=size, request_options=request_options
        )

    async def create(
        self,
        *,
        name: str,
        code: str,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Reactor:
        """
        Parameters
        ----------
        name : str

        code : str

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.create(
                name="name",
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            code=code,
            application=application,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Reactor:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: str,
        code: str,
        application: typing.Optional[Application] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Reactor:
        """
        Parameters
        ----------
        id : str

        name : str

        code : str

        application : typing.Optional[Application]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Reactor
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.update(
                id="id",
                name="name",
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            code=code,
            application=application,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        application: typing.Optional[Application] = OMIT,
        code: typing.Optional[str] = OMIT,
        configuration: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        application : typing.Optional[Application]

        code : typing.Optional[str]

        configuration : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.patch(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            id,
            name=name,
            application=application,
            code=code,
            configuration=configuration,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def react(
        self,
        id: str,
        *,
        args: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReactResponse:
        """
        Parameters
        ----------
        id : str

        args : typing.Optional[typing.Optional[typing.Any]]

        callback_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReactResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.react(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.react(
            id, args=args, callback_url=callback_url, request_options=request_options
        )
        return _response.data

    async def react_async(
        self,
        id: str,
        *,
        args: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncReactResponse:
        """
        Parameters
        ----------
        id : str

        args : typing.Optional[typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncReactResponse
            Accepted

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.react_async(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.react_async(id, args=args, request_options=request_options)
        return _response.data
