# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawResultsClient, RawResultsClient


class ResultsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawResultsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawResultsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawResultsClient
        """
        return self._raw_client

    def get(
        self, id: str, request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        id : str

        request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.reactors.results.get(
            id="id",
            request_id="requestId",
        )
        """
        _response = self._raw_client.get(id, request_id, request_options=request_options)
        return _response.data


class AsyncResultsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawResultsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawResultsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawResultsClient
        """
        return self._raw_client

    async def get(
        self, id: str, request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        id : str

        request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.reactors.results.get(
                id="id",
                request_id="requestId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_id, request_options=request_options)
        return _response.data
