# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.access_rule import AccessRule
from ..types.create_session_response import CreateSessionResponse
from .raw_client import AsyncRawSessionsClient, RawSessionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SessionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSessionsClient
        """
        return self._raw_client

    def create(
        self, *, idempotency_key: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateSessionResponse:
        """
        Parameters
        ----------
        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSessionResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.sessions.create()
        """
        _response = self._raw_client.create(idempotency_key=idempotency_key, request_options=request_options)
        return _response.data

    def authorize(
        self,
        *,
        nonce: str,
        expires_at: typing.Optional[str] = OMIT,
        permissions: typing.Optional[typing.Sequence[str]] = OMIT,
        rules: typing.Optional[typing.Sequence[AccessRule]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        nonce : str

        expires_at : typing.Optional[str]

        permissions : typing.Optional[typing.Sequence[str]]

        rules : typing.Optional[typing.Sequence[AccessRule]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.sessions.authorize(
            nonce="nonce",
        )
        """
        _response = self._raw_client.authorize(
            nonce=nonce,
            expires_at=expires_at,
            permissions=permissions,
            rules=rules,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data


class AsyncSessionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSessionsClient
        """
        return self._raw_client

    async def create(
        self, *, idempotency_key: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateSessionResponse:
        """
        Parameters
        ----------
        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSessionResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(idempotency_key=idempotency_key, request_options=request_options)
        return _response.data

    async def authorize(
        self,
        *,
        nonce: str,
        expires_at: typing.Optional[str] = OMIT,
        permissions: typing.Optional[typing.Sequence[str]] = OMIT,
        rules: typing.Optional[typing.Sequence[AccessRule]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        nonce : str

        expires_at : typing.Optional[str]

        permissions : typing.Optional[typing.Sequence[str]]

        rules : typing.Optional[typing.Sequence[AccessRule]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.authorize(
                nonce="nonce",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize(
            nonce=nonce,
            expires_at=expires_at,
            permissions=permissions,
            rules=rules,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data
