# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .connections.client import AsyncConnectionsClient, ConnectionsClient
from .invitations.client import AsyncInvitationsClient, InvitationsClient
from .members.client import AsyncMembersClient, MembersClient
from .owner.client import AsyncOwnerClient, OwnerClient
from .raw_client import AsyncRawTenantsClient, RawTenantsClient
from .self_.client import AsyncSelfClient, SelfClient


class TenantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTenantsClient(client_wrapper=client_wrapper)
        self.connections = ConnectionsClient(client_wrapper=client_wrapper)

        self.invitations = InvitationsClient(client_wrapper=client_wrapper)

        self.members = MembersClient(client_wrapper=client_wrapper)

        self.owner = OwnerClient(client_wrapper=client_wrapper)

        self.self_ = SelfClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTenantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTenantsClient
        """
        return self._raw_client


class AsyncTenantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTenantsClient(client_wrapper=client_wrapper)
        self.connections = AsyncConnectionsClient(client_wrapper=client_wrapper)

        self.invitations = AsyncInvitationsClient(client_wrapper=client_wrapper)

        self.members = AsyncMembersClient(client_wrapper=client_wrapper)

        self.owner = AsyncOwnerClient(client_wrapper=client_wrapper)

        self.self_ = AsyncSelfClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTenantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTenantsClient
        """
        return self._raw_client
