# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_tenant_connection_response import CreateTenantConnectionResponse
from ...types.tenant_connection_options import TenantConnectionOptions
from .raw_client import AsyncRawConnectionsClient, RawConnectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        strategy: str,
        options: TenantConnectionOptions,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTenantConnectionResponse:
        """
        Parameters
        ----------
        strategy : str

        options : TenantConnectionOptions

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTenantConnectionResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory, TenantConnectionOptions

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.connections.create(
            strategy="strategy",
            options=TenantConnectionOptions(),
        )
        """
        _response = self._raw_client.create(
            strategy=strategy, options=options, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> CreateTenantConnectionResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTenantConnectionResponse
            No Content

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.connections.delete()
        """
        _response = self._raw_client.delete(request_options=request_options)
        return _response.data


class AsyncConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        strategy: str,
        options: TenantConnectionOptions,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTenantConnectionResponse:
        """
        Parameters
        ----------
        strategy : str

        options : TenantConnectionOptions

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTenantConnectionResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory, TenantConnectionOptions

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.connections.create(
                strategy="strategy",
                options=TenantConnectionOptions(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            strategy=strategy, options=options, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def delete(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateTenantConnectionResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTenantConnectionResponse
            No Content

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.connections.delete()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(request_options=request_options)
        return _response.data
