# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.tenant_invitation_response import TenantInvitationResponse
from ...types.tenant_invitation_status import TenantInvitationStatus
from .raw_client import AsyncRawInvitationsClient, RawInvitationsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InvitationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInvitationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInvitationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInvitationsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        status: typing.Optional[TenantInvitationStatus] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[TenantInvitationResponse]:
        """
        Parameters
        ----------
        status : typing.Optional[TenantInvitationStatus]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[TenantInvitationResponse]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.tenants.invitations.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(status=status, page=page, start=start, size=size, request_options=request_options)

    def create(
        self,
        *,
        email: str,
        role: typing.Optional[str] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        email : str

        role : typing.Optional[str]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.invitations.create(
            email="email",
        )
        """
        _response = self._raw_client.create(
            email=email, role=role, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def resend(
        self,
        invitation_id: str,
        *,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        invitation_id : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.invitations.resend(
            invitation_id="invitationId",
        )
        """
        _response = self._raw_client.resend(
            invitation_id, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def get(
        self, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        invitation_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.invitations.get(
            invitation_id="invitationId",
        )
        """
        _response = self._raw_client.get(invitation_id, request_options=request_options)
        return _response.data

    def delete(self, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        invitation_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.invitations.delete(
            invitation_id="invitationId",
        )
        """
        _response = self._raw_client.delete(invitation_id, request_options=request_options)
        return _response.data


class AsyncInvitationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInvitationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInvitationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInvitationsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        status: typing.Optional[TenantInvitationStatus] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[TenantInvitationResponse]:
        """
        Parameters
        ----------
        status : typing.Optional[TenantInvitationStatus]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[TenantInvitationResponse]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tenants.invitations.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            status=status, page=page, start=start, size=size, request_options=request_options
        )

    async def create(
        self,
        *,
        email: str,
        role: typing.Optional[str] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        email : str

        role : typing.Optional[str]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.invitations.create(
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            email=email, role=role, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def resend(
        self,
        invitation_id: str,
        *,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        invitation_id : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.invitations.resend(
                invitation_id="invitationId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.resend(
            invitation_id, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def get(
        self, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TenantInvitationResponse:
        """
        Parameters
        ----------
        invitation_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantInvitationResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.invitations.get(
                invitation_id="invitationId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(invitation_id, request_options=request_options)
        return _response.data

    async def delete(self, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        invitation_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.invitations.delete(
                invitation_id="invitationId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(invitation_id, request_options=request_options)
        return _response.data
