# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.tenant_member_response import TenantMemberResponse
from ...types.tenant_member_response_paginated_list import TenantMemberResponsePaginatedList
from .raw_client import AsyncRawMembersClient, RawMembersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MembersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMembersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMembersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMembersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        user_id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantMemberResponsePaginatedList:
        """
        Parameters
        ----------
        user_id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponsePaginatedList
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.members.list()
        """
        _response = self._raw_client.list(
            user_id=user_id, page=page, start=start, size=size, request_options=request_options
        )
        return _response.data

    def update(
        self,
        member_id: str,
        *,
        role: str,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantMemberResponse:
        """
        Parameters
        ----------
        member_id : str

        role : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.members.update(
            member_id="memberId",
            role="role",
        )
        """
        _response = self._raw_client.update(
            member_id, role=role, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def delete(self, member_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        member_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.members.delete(
            member_id="memberId",
        )
        """
        _response = self._raw_client.delete(member_id, request_options=request_options)
        return _response.data


class AsyncMembersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMembersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMembersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMembersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        user_id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantMemberResponsePaginatedList:
        """
        Parameters
        ----------
        user_id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponsePaginatedList
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.members.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            user_id=user_id, page=page, start=start, size=size, request_options=request_options
        )
        return _response.data

    async def update(
        self,
        member_id: str,
        *,
        role: str,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TenantMemberResponse:
        """
        Parameters
        ----------
        member_id : str

        role : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.members.update(
                member_id="memberId",
                role="role",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            member_id, role=role, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def delete(self, member_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        member_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.members.delete(
                member_id="memberId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(member_id, request_options=request_options)
        return _response.data
