# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.tenant_member_response import TenantMemberResponse
from .raw_client import AsyncRawOwnerClient, RawOwnerClient


class OwnerClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOwnerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOwnerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOwnerClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> TenantMemberResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.owner.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data


class AsyncOwnerClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOwnerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOwnerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOwnerClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> TenantMemberResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantMemberResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.owner.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data
