# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.tenant import Tenant
from ...types.tenant_usage_report import TenantUsageReport
from .raw_client import AsyncRawSelfClient, RawSelfClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SelfClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSelfClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSelfClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSelfClient
        """
        return self._raw_client

    def get_usage_reports(self, *, request_options: typing.Optional[RequestOptions] = None) -> TenantUsageReport:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantUsageReport
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.self_.get_usage_reports()
        """
        _response = self._raw_client.get_usage_reports(request_options=request_options)
        return _response.data

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> Tenant:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tenant
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.self_.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        name: str,
        settings: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Tenant:
        """
        Parameters
        ----------
        name : str

        settings : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tenant
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.self_.update(
            name="name",
        )
        """
        _response = self._raw_client.update(
            name=name, settings=settings, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tenants.self_.delete()
        """
        _response = self._raw_client.delete(request_options=request_options)
        return _response.data


class AsyncSelfClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSelfClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSelfClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSelfClient
        """
        return self._raw_client

    async def get_usage_reports(self, *, request_options: typing.Optional[RequestOptions] = None) -> TenantUsageReport:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TenantUsageReport
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.self_.get_usage_reports()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_usage_reports(request_options=request_options)
        return _response.data

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> Tenant:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tenant
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.self_.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        name: str,
        settings: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Tenant:
        """
        Parameters
        ----------
        name : str

        settings : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tenant
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.self_.update(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            name=name, settings=settings, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tenants.self_.delete()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(request_options=request_options)
        return _response.data
