# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.authenticate_three_ds_session_request import AuthenticateThreeDsSessionRequest
from ...types.create_three_ds_session_response import CreateThreeDsSessionResponse
from ...types.three_ds_authentication import ThreeDsAuthentication
from ...types.three_ds_callback_urls import ThreeDsCallbackUrls
from ...types.three_ds_cardholder_info import ThreeDsCardholderInfo
from ...types.three_ds_device_info import ThreeDsDeviceInfo
from ...types.three_ds_merchant_info import ThreeDsMerchantInfo
from ...types.three_ds_message_extension import ThreeDsMessageExtension
from ...types.three_ds_purchase_info import ThreeDsPurchaseInfo
from ...types.three_ds_requestor_info import ThreeDsRequestorInfo
from ...types.three_ds_session import ThreeDsSession
from .raw_client import AsyncRawSessionsClient, RawSessionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SessionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSessionsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        pan: typing.Optional[str] = OMIT,
        token_id: typing.Optional[str] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        device: typing.Optional[str] = OMIT,
        web_challenge_mode: typing.Optional[str] = OMIT,
        device_info: typing.Optional[ThreeDsDeviceInfo] = OMIT,
        authentication_request: typing.Optional[AuthenticateThreeDsSessionRequest] = OMIT,
        callback_urls: typing.Optional[ThreeDsCallbackUrls] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateThreeDsSessionResponse:
        """
        Parameters
        ----------
        pan : typing.Optional[str]

        token_id : typing.Optional[str]

        token_intent_id : typing.Optional[str]

        type : typing.Optional[str]

        device : typing.Optional[str]

        web_challenge_mode : typing.Optional[str]

        device_info : typing.Optional[ThreeDsDeviceInfo]

        authentication_request : typing.Optional[AuthenticateThreeDsSessionRequest]

        callback_urls : typing.Optional[ThreeDsCallbackUrls]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateThreeDsSessionResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.threeds.sessions.create()
        """
        _response = self._raw_client.create(
            pan=pan,
            token_id=token_id,
            token_intent_id=token_intent_id,
            type=type,
            device=device,
            web_challenge_mode=web_challenge_mode,
            device_info=device_info,
            authentication_request=authentication_request,
            callback_urls=callback_urls,
            request_options=request_options,
        )
        return _response.data

    def authenticate(
        self,
        session_id: str,
        *,
        authentication_category: str,
        authentication_type: str,
        card_brand: typing.Optional[str] = OMIT,
        challenge_preference: typing.Optional[str] = OMIT,
        request_decoupled_challenge: typing.Optional[bool] = OMIT,
        decoupled_challenge_max_time: typing.Optional[int] = OMIT,
        purchase_info: typing.Optional[ThreeDsPurchaseInfo] = OMIT,
        merchant_info: typing.Optional[ThreeDsMerchantInfo] = OMIT,
        requestor_info: typing.Optional[ThreeDsRequestorInfo] = OMIT,
        cardholder_info: typing.Optional[ThreeDsCardholderInfo] = OMIT,
        broadcast_info: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        message_extensions: typing.Optional[typing.Sequence[ThreeDsMessageExtension]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ThreeDsAuthentication:
        """
        Parameters
        ----------
        session_id : str

        authentication_category : str

        authentication_type : str

        card_brand : typing.Optional[str]

        challenge_preference : typing.Optional[str]

        request_decoupled_challenge : typing.Optional[bool]

        decoupled_challenge_max_time : typing.Optional[int]

        purchase_info : typing.Optional[ThreeDsPurchaseInfo]

        merchant_info : typing.Optional[ThreeDsMerchantInfo]

        requestor_info : typing.Optional[ThreeDsRequestorInfo]

        cardholder_info : typing.Optional[ThreeDsCardholderInfo]

        broadcast_info : typing.Optional[typing.Optional[typing.Any]]

        message_extensions : typing.Optional[typing.Sequence[ThreeDsMessageExtension]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsAuthentication
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.threeds.sessions.authenticate(
            session_id="sessionId",
            authentication_category="authentication_category",
            authentication_type="authentication_type",
        )
        """
        _response = self._raw_client.authenticate(
            session_id,
            authentication_category=authentication_category,
            authentication_type=authentication_type,
            card_brand=card_brand,
            challenge_preference=challenge_preference,
            request_decoupled_challenge=request_decoupled_challenge,
            decoupled_challenge_max_time=decoupled_challenge_max_time,
            purchase_info=purchase_info,
            merchant_info=merchant_info,
            requestor_info=requestor_info,
            cardholder_info=cardholder_info,
            broadcast_info=broadcast_info,
            message_extensions=message_extensions,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def get_challenge_result(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ThreeDsAuthentication:
        """
        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsAuthentication
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.threeds.sessions.get_challenge_result(
            session_id="sessionId",
        )
        """
        _response = self._raw_client.get_challenge_result(session_id, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ThreeDsSession:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsSession
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.threeds.sessions.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data


class AsyncSessionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSessionsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        pan: typing.Optional[str] = OMIT,
        token_id: typing.Optional[str] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        device: typing.Optional[str] = OMIT,
        web_challenge_mode: typing.Optional[str] = OMIT,
        device_info: typing.Optional[ThreeDsDeviceInfo] = OMIT,
        authentication_request: typing.Optional[AuthenticateThreeDsSessionRequest] = OMIT,
        callback_urls: typing.Optional[ThreeDsCallbackUrls] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateThreeDsSessionResponse:
        """
        Parameters
        ----------
        pan : typing.Optional[str]

        token_id : typing.Optional[str]

        token_intent_id : typing.Optional[str]

        type : typing.Optional[str]

        device : typing.Optional[str]

        web_challenge_mode : typing.Optional[str]

        device_info : typing.Optional[ThreeDsDeviceInfo]

        authentication_request : typing.Optional[AuthenticateThreeDsSessionRequest]

        callback_urls : typing.Optional[ThreeDsCallbackUrls]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateThreeDsSessionResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.threeds.sessions.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            pan=pan,
            token_id=token_id,
            token_intent_id=token_intent_id,
            type=type,
            device=device,
            web_challenge_mode=web_challenge_mode,
            device_info=device_info,
            authentication_request=authentication_request,
            callback_urls=callback_urls,
            request_options=request_options,
        )
        return _response.data

    async def authenticate(
        self,
        session_id: str,
        *,
        authentication_category: str,
        authentication_type: str,
        card_brand: typing.Optional[str] = OMIT,
        challenge_preference: typing.Optional[str] = OMIT,
        request_decoupled_challenge: typing.Optional[bool] = OMIT,
        decoupled_challenge_max_time: typing.Optional[int] = OMIT,
        purchase_info: typing.Optional[ThreeDsPurchaseInfo] = OMIT,
        merchant_info: typing.Optional[ThreeDsMerchantInfo] = OMIT,
        requestor_info: typing.Optional[ThreeDsRequestorInfo] = OMIT,
        cardholder_info: typing.Optional[ThreeDsCardholderInfo] = OMIT,
        broadcast_info: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        message_extensions: typing.Optional[typing.Sequence[ThreeDsMessageExtension]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ThreeDsAuthentication:
        """
        Parameters
        ----------
        session_id : str

        authentication_category : str

        authentication_type : str

        card_brand : typing.Optional[str]

        challenge_preference : typing.Optional[str]

        request_decoupled_challenge : typing.Optional[bool]

        decoupled_challenge_max_time : typing.Optional[int]

        purchase_info : typing.Optional[ThreeDsPurchaseInfo]

        merchant_info : typing.Optional[ThreeDsMerchantInfo]

        requestor_info : typing.Optional[ThreeDsRequestorInfo]

        cardholder_info : typing.Optional[ThreeDsCardholderInfo]

        broadcast_info : typing.Optional[typing.Optional[typing.Any]]

        message_extensions : typing.Optional[typing.Sequence[ThreeDsMessageExtension]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsAuthentication
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.threeds.sessions.authenticate(
                session_id="sessionId",
                authentication_category="authentication_category",
                authentication_type="authentication_type",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authenticate(
            session_id,
            authentication_category=authentication_category,
            authentication_type=authentication_type,
            card_brand=card_brand,
            challenge_preference=challenge_preference,
            request_decoupled_challenge=request_decoupled_challenge,
            decoupled_challenge_max_time=decoupled_challenge_max_time,
            purchase_info=purchase_info,
            merchant_info=merchant_info,
            requestor_info=requestor_info,
            cardholder_info=cardholder_info,
            broadcast_info=broadcast_info,
            message_extensions=message_extensions,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def get_challenge_result(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ThreeDsAuthentication:
        """
        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsAuthentication
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.threeds.sessions.get_challenge_result(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_challenge_result(session_id, request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ThreeDsSession:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreeDsSession
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.threeds.sessions.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data
