# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.privacy import Privacy
from ..types.token import Token
from ..types.update_privacy import UpdatePrivacy
from .raw_client import AsyncRawTokensClient, RawTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTokensClient
        """
        return self._raw_client

    def detokenize(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.detokenize(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.detokenize(request=request, request_options=request_options)
        return _response.data

    def tokenize(
        self,
        *,
        request: typing.Optional[typing.Any] = None,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request : typing.Optional[typing.Any]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.tokenize(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.tokenize(
            request=request, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Token]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Token]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.tokens.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id=id, metadata=metadata, page=page, start=start, size=size, request_options=request_options
        )

    def create(
        self,
        *,
        id: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        encrypted: typing.Optional[str] = OMIT,
        privacy: typing.Optional[Privacy] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        search_indexes: typing.Optional[typing.Sequence[str]] = OMIT,
        fingerprint_expression: typing.Optional[str] = OMIT,
        mask: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        expires_at: typing.Optional[str] = OMIT,
        containers: typing.Optional[typing.Sequence[str]] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Token:
        """
        Parameters
        ----------
        id : typing.Optional[str]

        type : typing.Optional[str]

        data : typing.Optional[typing.Optional[typing.Any]]

        encrypted : typing.Optional[str]

        privacy : typing.Optional[Privacy]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        search_indexes : typing.Optional[typing.Sequence[str]]

        fingerprint_expression : typing.Optional[str]

        mask : typing.Optional[typing.Optional[typing.Any]]

        deduplicate_token : typing.Optional[bool]

        expires_at : typing.Optional[str]

        containers : typing.Optional[typing.Sequence[str]]

        token_intent_id : typing.Optional[str]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.create()
        """
        _response = self._raw_client.create(
            id=id,
            type=type,
            data=data,
            encrypted=encrypted,
            privacy=privacy,
            metadata=metadata,
            search_indexes=search_indexes,
            fingerprint_expression=fingerprint_expression,
            mask=mask,
            deduplicate_token=deduplicate_token,
            expires_at=expires_at,
            containers=containers,
            token_intent_id=token_intent_id,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Token:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        privacy: typing.Optional[UpdatePrivacy] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        search_indexes: typing.Optional[typing.Sequence[str]] = OMIT,
        fingerprint_expression: typing.Optional[str] = OMIT,
        mask: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        expires_at: typing.Optional[str] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        containers: typing.Optional[typing.Sequence[str]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Token:
        """
        Parameters
        ----------
        id : str

        data : typing.Optional[typing.Optional[typing.Any]]

        privacy : typing.Optional[UpdatePrivacy]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        search_indexes : typing.Optional[typing.Sequence[str]]

        fingerprint_expression : typing.Optional[str]

        mask : typing.Optional[typing.Optional[typing.Any]]

        expires_at : typing.Optional[str]

        deduplicate_token : typing.Optional[bool]

        containers : typing.Optional[typing.Sequence[str]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.tokens.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            data=data,
            privacy=privacy,
            metadata=metadata,
            search_indexes=search_indexes,
            fingerprint_expression=fingerprint_expression,
            mask=mask,
            expires_at=expires_at,
            deduplicate_token=deduplicate_token,
            containers=containers,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    def list_v2(
        self,
        *,
        type: typing.Optional[str] = None,
        container: typing.Optional[str] = None,
        fingerprint: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Token]:
        """
        Parameters
        ----------
        type : typing.Optional[str]

        container : typing.Optional[str]

        fingerprint : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Token]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.tokens.list_v2()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_v2(
            type=type,
            container=container,
            fingerprint=fingerprint,
            metadata=metadata,
            start=start,
            size=size,
            request_options=request_options,
        )

    def search_v2(
        self,
        *,
        query: typing.Optional[str] = OMIT,
        start: typing.Optional[str] = OMIT,
        size: typing.Optional[int] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Token]:
        """
        Parameters
        ----------
        query : typing.Optional[str]

        start : typing.Optional[str]

        size : typing.Optional[int]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Token]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        response = client.tokens.search_v2()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.search_v2(
            query=query, start=start, size=size, idempotency_key=idempotency_key, request_options=request_options
        )


class AsyncTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTokensClient
        """
        return self._raw_client

    async def detokenize(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.detokenize(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detokenize(request=request, request_options=request_options)
        return _response.data

    async def tokenize(
        self,
        *,
        request: typing.Optional[typing.Any] = None,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request : typing.Optional[typing.Any]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.tokenize(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.tokenize(
            request=request, idempotency_key=idempotency_key, request_options=request_options
        )
        return _response.data

    async def list(
        self,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        page: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Token]:
        """
        Parameters
        ----------
        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        page : typing.Optional[int]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Token]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tokens.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id=id, metadata=metadata, page=page, start=start, size=size, request_options=request_options
        )

    async def create(
        self,
        *,
        id: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        encrypted: typing.Optional[str] = OMIT,
        privacy: typing.Optional[Privacy] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        search_indexes: typing.Optional[typing.Sequence[str]] = OMIT,
        fingerprint_expression: typing.Optional[str] = OMIT,
        mask: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        expires_at: typing.Optional[str] = OMIT,
        containers: typing.Optional[typing.Sequence[str]] = OMIT,
        token_intent_id: typing.Optional[str] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Token:
        """
        Parameters
        ----------
        id : typing.Optional[str]

        type : typing.Optional[str]

        data : typing.Optional[typing.Optional[typing.Any]]

        encrypted : typing.Optional[str]

        privacy : typing.Optional[Privacy]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        search_indexes : typing.Optional[typing.Sequence[str]]

        fingerprint_expression : typing.Optional[str]

        mask : typing.Optional[typing.Optional[typing.Any]]

        deduplicate_token : typing.Optional[bool]

        expires_at : typing.Optional[str]

        containers : typing.Optional[typing.Sequence[str]]

        token_intent_id : typing.Optional[str]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id=id,
            type=type,
            data=data,
            encrypted=encrypted,
            privacy=privacy,
            metadata=metadata,
            search_indexes=search_indexes,
            fingerprint_expression=fingerprint_expression,
            mask=mask,
            deduplicate_token=deduplicate_token,
            expires_at=expires_at,
            containers=containers,
            token_intent_id=token_intent_id,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Token:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        data: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        privacy: typing.Optional[UpdatePrivacy] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        search_indexes: typing.Optional[typing.Sequence[str]] = OMIT,
        fingerprint_expression: typing.Optional[str] = OMIT,
        mask: typing.Optional[typing.Optional[typing.Any]] = OMIT,
        expires_at: typing.Optional[str] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        containers: typing.Optional[typing.Sequence[str]] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Token:
        """
        Parameters
        ----------
        id : str

        data : typing.Optional[typing.Optional[typing.Any]]

        privacy : typing.Optional[UpdatePrivacy]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        search_indexes : typing.Optional[typing.Sequence[str]]

        fingerprint_expression : typing.Optional[str]

        mask : typing.Optional[typing.Optional[typing.Any]]

        expires_at : typing.Optional[str]

        deduplicate_token : typing.Optional[bool]

        containers : typing.Optional[typing.Sequence[str]]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Token
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tokens.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            data=data,
            privacy=privacy,
            metadata=metadata,
            search_indexes=search_indexes,
            fingerprint_expression=fingerprint_expression,
            mask=mask,
            expires_at=expires_at,
            deduplicate_token=deduplicate_token,
            containers=containers,
            idempotency_key=idempotency_key,
            request_options=request_options,
        )
        return _response.data

    async def list_v2(
        self,
        *,
        type: typing.Optional[str] = None,
        container: typing.Optional[str] = None,
        fingerprint: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        start: typing.Optional[str] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Token]:
        """
        Parameters
        ----------
        type : typing.Optional[str]

        container : typing.Optional[str]

        fingerprint : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        start : typing.Optional[str]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Token]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tokens.list_v2()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_v2(
            type=type,
            container=container,
            fingerprint=fingerprint,
            metadata=metadata,
            start=start,
            size=size,
            request_options=request_options,
        )

    async def search_v2(
        self,
        *,
        query: typing.Optional[str] = OMIT,
        start: typing.Optional[str] = OMIT,
        size: typing.Optional[int] = OMIT,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Token]:
        """
        Parameters
        ----------
        query : typing.Optional[str]

        start : typing.Optional[str]

        size : typing.Optional[int]

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Token]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tokens.search_v2()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.search_v2(
            query=query, start=start, size=size, idempotency_key=idempotency_key, request_options=request_options
        )
