# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .account_updater_job_status import AccountUpdaterJobStatus


class AccountUpdaterJob(UniversalBaseModel):
    id: str
    tenant_id: typing_extensions.Annotated[str, FieldMetadata(alias="tenantId")]
    status: AccountUpdaterJobStatus = pydantic.Field()
    """
    The current status of the job
    """

    upload_url: typing_extensions.Annotated[str, FieldMetadata(alias="uploadUrl")] = pydantic.Field()
    """
    Pre-signed URL for uploading job data
    """

    created_by: typing_extensions.Annotated[str, FieldMetadata(alias="createdBy")] = pydantic.Field()
    """
    Application id that created the job
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    Date and time when the job was created
    """

    expires_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="expiresAt")] = (
        pydantic.Field(default=None)
    )
    """
    Date and time when the job expires if no data is uploaded
    """

    errors: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of errors encountered during processing
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
