# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .bank_details import BankDetails
from .card_details import CardDetails
from .privacy import Privacy
from .token_enrichments import TokenEnrichments
from .token_extras import TokenExtras


class Token(UniversalBaseModel):
    id: typing.Optional[str] = None
    type: typing.Optional[str] = None
    tenant_id: typing.Optional[str] = None
    data: typing.Optional[typing.Optional[typing.Any]] = None
    metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    enrichments: typing.Optional[TokenEnrichments] = None
    created_by: typing.Optional[str] = None
    created_at: typing.Optional[dt.datetime] = None
    card: typing.Optional[CardDetails] = None
    bank: typing.Optional[BankDetails] = None
    network_token: typing.Optional[CardDetails] = None
    modified_by: typing.Optional[str] = None
    modified_at: typing.Optional[dt.datetime] = None
    fingerprint: typing.Optional[str] = None
    fingerprint_expression: typing.Optional[str] = None
    mask: typing.Optional[typing.Optional[typing.Any]] = None
    privacy: typing.Optional[Privacy] = None
    search_indexes: typing.Optional[typing.List[str]] = None
    expires_at: typing.Optional[dt.datetime] = None
    containers: typing.Optional[typing.List[str]] = None
    aliases: typing.Optional[typing.List[str]] = None
    authentication: typing.Optional[typing.Optional[typing.Any]] = None
    extras: typing_extensions.Annotated[typing.Optional[TokenExtras], FieldMetadata(alias="_extras")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
