import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLocalFileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Path to the output file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/d/file.html#filename DataLocalFile#filename}
     *
     * @stability stable
     */
    readonly filename: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/local/d/file.html local_file}.
 *
 * @stability stable
 */
export declare class DataLocalFile extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/local/d/file.html local_file} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLocalFileConfig);
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    get contentBase64(): string;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
