"Helper functions for stepfunctions service"

from typing import Any, Dict, Union
import boto3
from boto3.session import Session
from botocore.config import Config
from mypy_boto3_stepfunctions.client import Client
from mypy_boto3_stepfunctions.paginator import (
    GetExecutionHistoryPaginator,
    ListActivitiesPaginator,
    ListExecutionsPaginator,
    ListStateMachinesPaginator,
)

# pylint: disable=arguments-differ,redefined-outer-name,redefined-builtin
def boto3_client(
    session: Session = None,
    region_name: str = None,
    api_version: str = None,
    use_ssl: bool = None,
    verify: Union[str, bool] = None,
    endpoint_url: str = None,
    aws_access_key_id: str = None,
    aws_secret_access_key: str = None,
    aws_session_token: str = None,
    config: Config = None,
) -> Client:
    """
    Equivalent of `boto3.client('stepfunctions')`, returns a correct type.
    """
    kwargs: Dict[str, Any] = {}
    if region_name is not None:
        kwargs["region_name"] = region_name
    if api_version is not None:
        kwargs["api_version"] = api_version
    if use_ssl is not None:
        kwargs["use_ssl"] = use_ssl
    if verify is not None:
        kwargs["verify"] = verify
    if endpoint_url is not None:
        kwargs["endpoint_url"] = endpoint_url
    if aws_access_key_id is not None:
        kwargs["aws_access_key_id"] = aws_access_key_id
    if aws_secret_access_key is not None:
        kwargs["aws_secret_access_key"] = aws_secret_access_key
    if aws_session_token is not None:
        kwargs["aws_session_token"] = aws_session_token
    if config is not None:
        kwargs["config"] = config
    if session is not None:
        return session.client("stepfunctions", **kwargs)
    return boto3.client("stepfunctions", **kwargs)


# pylint: disable=arguments-differ,redefined-outer-name,redefined-builtin
def get_get_execution_history_paginator(client: Client) -> GetExecutionHistoryPaginator:
    """
    Equivalent of `client.get_paginator('get_execution_history')`, returns a correct type.
    """
    return client.get_paginator("get_execution_history")


# pylint: disable=arguments-differ,redefined-outer-name,redefined-builtin
def get_list_activities_paginator(client: Client) -> ListActivitiesPaginator:
    """
    Equivalent of `client.get_paginator('list_activities')`, returns a correct type.
    """
    return client.get_paginator("list_activities")


# pylint: disable=arguments-differ,redefined-outer-name,redefined-builtin
def get_list_executions_paginator(client: Client) -> ListExecutionsPaginator:
    """
    Equivalent of `client.get_paginator('list_executions')`, returns a correct type.
    """
    return client.get_paginator("list_executions")


# pylint: disable=arguments-differ,redefined-outer-name,redefined-builtin
def get_list_state_machines_paginator(client: Client) -> ListStateMachinesPaginator:
    """
    Equivalent of `client.get_paginator('list_state_machines')`, returns a correct type.
    """
    return client.get_paginator("list_state_machines")
