# Security Policy

We take security seriously and appreciate your efforts to make Opteryx more secure.

## Supported Versions

We support the current and previous minor versions for functional and security fixes. New features are only added to the latest version, while patch versions are created as needed for critical fixes. 

| Version | Supported          |
| ------- | ------------------ |
| 0.18    | ✅                 |
| 0.17    | ✅                 |
| <= 0.16 | ❌                 |

### Key Notes

- Features due for deprecation may be removed rather than fixed.
- Releases containing material bugs or security vulnerabilities may be yanked from PyPI.
- To stay secure, we recommend using the latest version wherever possible.

## Reporting a Vulnerability

Thank you for helping to keep Opteryx secure! If you’ve discovered a potential vulnerability, please follow these steps:

1. **Submit a Report**: Vulnerabilities should be reported through [GitHub Security Advisories](https://github.com/mabel-dev/opteryx/security/advisories).
1. **Include Details**: To help us assess the issue quickly, please include:
   - A description of the vulnerability
   - Steps to reproduce it
   - Affected versions
   - Any known mitigations
1. **Expectations**: We aim to triage and respond within 7 days. If you haven’t heard back, feel free to follow up.

### Disclosure Timeline
- We follow a **90-day coordinated disclosure timeline** from the first contact, regardless of resolution status.
- Credit will be given to researchers unless anonymity is requested.

## Scope of Security Issues

This policy covers vulnerabilities that may compromise:
- Data confidentiality, integrity, or availability
- System functionality or integrity
- Compliance with security standards

We appreciate your cooperation in helping us maintain a secure and reliable system for the Opteryx community.
