"""6.0.0

Revision ID: 37ece7aa1742
Revises: ee9340feec83
Create Date: 2024-12-04 12:18:05.439980

"""
from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "37ece7aa1742"
down_revision: Union[str, None] = "ee9340feec83"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sql = r"""
    alter table public."Event"
    drop constraint filled_fields_type_combination;

    alter table public."Event"
    add constraint filled_fields_type_combination
        CHECK ((((station_id IS NOT NULL) AND ((event_type)::text = ANY ((ARRAY['CHARGING_OPPORTUNITY'::character varying, 'STANDBY_DEPARTURE'::character varying])::text[]))) 
        OR ((area_id IS NOT NULL) AND (subloc_no IS NOT NULL) AND (station_id IS NOT NULL) AND ((event_type)::text = ANY ((ARRAY['CHARGING_DEPOT'::character varying, 'SERVICE'::character varying, 'STANDBY_DEPARTURE'::character varying, 'STANDBY'::character varying, 'PRECONDITIONING'::character varying])::text[]))) 
        OR ((trip_id IS NOT NULL) AND (subloc_no IS NULL) AND ((event_type)::text = 'DRIVING'::text))))

    """
    op.execute(sql)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sql = r"""
    alter table public."Event"
    drop constraint filled_fields_type_combination;

    alter table public."Event"
    add constraint filled_fields_type_combination
        CHECK ((((station_id IS NOT NULL) AND ((event_type)::text = ANY ((ARRAY['CHARGING_OPPORTUNITY'::character varying, 'STANDBY_DEPARTURE'::character varying])::text[]))) 
        OR ((area_id IS NOT NULL) AND (subloc_no IS NOT NULL) AND ((event_type)::text = ANY ((ARRAY['CHARGING_DEPOT'::character varying, 'SERVICE'::character varying, 'STANDBY_DEPARTURE'::character varying, 'STANDBY'::character varying, 'PRECONDITIONING'::character varying])::text[]))) 
        OR ((trip_id IS NOT NULL) AND (subloc_no IS NULL) AND ((event_type)::text = 'DRIVING'::text))));
    """
    op.execute(sql)
    # ### end Alembic commands ###
