"""3.0.0

Revision ID: 6ac022147397
Revises: baef3598b52c
Create Date: 2024-03-15 11:29:54.326615

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "6ac022147397"
down_revision: Union[str, None] = "baef3598b52c"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("Depot", sa.Column("station_id", sa.BigInteger(), nullable=False))
    op.create_unique_constraint(
        "Depot_scenario_id_station_id_key", "Depot", ["scenario_id", "station_id"]
    )
    op.create_foreign_key(
        "Depot_station_id_fkey", "Depot", "Station", ["station_id"], ["id"]
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("Depot_station_id_fkey", "Depot", type_="foreignkey")
    op.drop_constraint("Depot_scenario_id_station_id_key", "Depot", type_="unique")
    op.drop_column("Depot", "station_id")
    # ### end Alembic commands ###
