"""v10.0.0

Revision ID: 6e96cbfb3523
Revises: 8f2835b87d6e
Create Date: 2025-08-13 14:00:55.220410

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from geoalchemy2 import Geometry
from sqlalchemy import text

# revision identifiers, used by Alembic.
revision: str = "6e96cbfb3523"
down_revision: Union[str, None] = "8f2835b87d6e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # AssocRouteStation.location: POINTZ -> POINT
    # Create temporary column with new type
    op.add_column(
        "AssocRouteStation",
        sa.Column(
            "location_temp",
            Geometry(
                geometry_type="POINT",
                srid=4326,
                from_text="ST_GeomFromEWKT",
                name="geometry",
            ),
            nullable=True,
        ),
    )

    # Migrate data, removing Z dimension
    op.execute(
        text(
            """
        UPDATE "AssocRouteStation" 
        SET location_temp = ST_Force2D(location)
        WHERE location IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("AssocRouteStation", "location")
    op.alter_column("AssocRouteStation", "location_temp", new_column_name="location")

    # Route.geom: LINESTRINGZ -> LINESTRING
    # Create temporary column with new type
    op.add_column(
        "Route",
        sa.Column(
            "geom_temp",
            Geometry(
                geometry_type="LINESTRING",
                srid=4326,
                from_text="ST_GeomFromEWKT",
                name="geometry",
            ),
            nullable=True,
        ),
    )

    # Migrate data, removing Z dimension
    op.execute(
        text(
            """
        UPDATE "Route" 
        SET geom_temp = ST_Force2D(geom)
        WHERE geom IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("Route", "geom")
    op.alter_column("Route", "geom_temp", new_column_name="geom")

    # Station.geom: POINTZ -> POINT
    # Create temporary column with new type
    op.add_column(
        "Station",
        sa.Column(
            "geom_temp",
            Geometry(
                geometry_type="POINT",
                srid=4326,
                from_text="ST_GeomFromEWKT",
                name="geometry",
            ),
            nullable=True,
        ),
    )

    # Migrate data, removing Z dimension
    op.execute(
        text(
            """
        UPDATE "Station" 
        SET geom_temp = ST_Force2D(geom)
        WHERE geom IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("Station", "geom")
    op.alter_column("Station", "geom_temp", new_column_name="geom")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Station.geom: POINT -> POINTZ
    # Create temporary column with new type
    op.add_column(
        "Station",
        sa.Column(
            "geom_temp",
            Geometry(
                geometry_type="POINTZ",
                srid=4326,
                dimension=3,
                from_text="ST_GeomFromEWKT",
                name="geometry",
                _spatial_index_reflected=True,
            ),
            nullable=True,
        ),
    )

    # Migrate data, adding Z dimension with value 0
    op.execute(
        text(
            """
        UPDATE "Station" 
        SET geom_temp = ST_Force3DZ(geom, 0)
        WHERE geom IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("Station", "geom")
    op.alter_column("Station", "geom_temp", new_column_name="geom")

    # Route.geom: LINESTRING -> LINESTRINGZ
    # Create temporary column with new type
    op.add_column(
        "Route",
        sa.Column(
            "geom_temp",
            Geometry(
                geometry_type="LINESTRINGZ",
                srid=4326,
                dimension=3,
                from_text="ST_GeomFromEWKT",
                name="geometry",
                _spatial_index_reflected=True,
            ),
            nullable=True,
        ),
    )

    # Migrate data, adding Z dimension with value 0
    op.execute(
        text(
            """
        UPDATE "Route" 
        SET geom_temp = ST_Force3DZ(geom, 0)
        WHERE geom IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("Route", "geom")
    op.alter_column("Route", "geom_temp", new_column_name="geom")

    # AssocRouteStation.location: POINT -> POINTZ
    # Create temporary column with new type
    op.add_column(
        "AssocRouteStation",
        sa.Column(
            "location_temp",
            Geometry(
                geometry_type="POINTZ",
                srid=4326,
                dimension=3,
                from_text="ST_GeomFromEWKT",
                name="geometry",
                _spatial_index_reflected=True,
            ),
            nullable=True,
        ),
    )

    # Migrate data, adding Z dimension with value 0
    op.execute(
        text(
            """
        UPDATE "AssocRouteStation" 
        SET location_temp = ST_Force3DZ(location, 0)
        WHERE location IS NOT NULL
    """
        )
    )

    # Drop old column and rename temp to original
    op.drop_column("AssocRouteStation", "location")
    op.alter_column("AssocRouteStation", "location_temp", new_column_name="location")

    # ### end Alembic commands ###
