"""7.0.2

Revision ID: 7c26ba933d67
Revises: 8755e7591dcd
Create Date: 2025-04-25 18:39:27.319408

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "7c26ba933d67"
down_revision: Union[str, None] = "8755e7591dcd"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Add a random UUID to each Scenario that does not have a task_id yet
    op.execute(
        """
        UPDATE "Scenario"
        SET task_id = gen_random_uuid()
        WHERE task_id IS NULL;
        """
    )

    # Make the task_id column non-nullable and set a default value
    op.alter_column(
        "Scenario",
        "task_id",
        existing_type=sa.UUID(),
        nullable=False,
        server_default=sa.text("gen_random_uuid()"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "Scenario",
        "task_id",
        existing_type=sa.UUID(),
        nullable=True,
        server_default=None,
    )
    # ### end Alembic commands ###
