# type: ignore

"""8.0.0

Revision ID: 801705905f79
Revises: 7c26ba933d67
Create Date: 2025-05-12 12:38:11.116470

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from geoalchemy2 import Geometry
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "801705905f79"
down_revision: Union[str, None] = "7c26ba933d67"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_geospatial_column(
        "Area",
        sa.Column(
            "bounding_box",
            Geometry(
                geometry_type="POLYGON",
                srid=4326,
                spatial_index=False,
                from_text="ST_GeomFromEWKT",
                name="geometry",
            ),
            nullable=True,
        ),
    )
    op.create_geospatial_index(
        "idx_Area_bounding_box",
        "Area",
        ["bounding_box"],
        unique=False,
        postgresql_using="gist",
        postgresql_ops={},
    )
    op.add_geospatial_column(
        "Depot",
        sa.Column(
            "bounding_box",
            Geometry(
                geometry_type="POLYGON",
                srid=4326,
                spatial_index=False,
                from_text="ST_GeomFromEWKT",
                name="geometry",
            ),
            nullable=True,
        ),
    )
    op.create_geospatial_index(
        "idx_Depot_bounding_box",
        "Depot",
        ["bounding_box"],
        unique=False,
        postgresql_using="gist",
        postgresql_ops={},
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_geospatial_index(
        "idx_Depot_bounding_box",
        table_name="Depot",
        postgresql_using="gist",
        column_name="bounding_box",
    )
    op.drop_geospatial_column("Depot", "bounding_box")
    op.drop_geospatial_index(
        "idx_Area_bounding_box",
        table_name="Area",
        postgresql_using="gist",
        column_name="bounding_box",
    )
    op.drop_geospatial_column("Area", "bounding_box")
    # ### end Alembic commands ###
