"""7.0.1

Revision ID: 8755e7591dcd
Revises: 747085e84b69
Create Date: 2025-04-25 17:58:17.678700

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "8755e7591dcd"
down_revision: Union[str, None] = "747085e84b69"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("Area", sa.Column("row_count", sa.Integer(), nullable=True))

    # We will need to set row_count to 1 for all existing aeas of type LINE
    sql = "UPDATE public.\"Area\" SET row_count = 1 WHERE area_type = 'LINE';"
    op.execute(sql)

    sql = r"""
    alter table public."Area"
    drop constraint capacity_validity_check;

    alter table public."Area"
    add constraint capacity_validity_check
        check ((capacity > 0) AND
               ((((area_type)::text = 'DIRECT_TWOSIDE'::text) AND (row_count IS NULL) AND ((capacity % 2) = 0)) OR
                (((area_type)::text = 'DIRECT_ONESIDE'::text) AND (row_count IS NULL)) OR
                (((area_type)::text = 'LINE'::text) AND (row_count IS NOT NULL) AND ((capacity % row_count) = 0))));


    """
    op.execute(sql)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("Area", "row_count")
    sql = r"""
    alter table public."Area" drop constraint capacity_validity_check;

    alter table public."Area" add constraint capacity_validity_check
        check ((capacity > 0) AND ((((area_type)::text = 'DIRECT_TWOSIDE'::text) AND ((capacity % 2) = 0)) OR
                                    ((area_type)::text = 'DIRECT_ONESIDE'::text) OR ((area_type)::text = 'LINE'::text)));

    """
    op.execute(sql)
    # ### end Alembic commands ###
