"""8.1.0

Revision ID: e8f748c14b93
Revises: 801705905f79
Create Date: 2025-05-13 17:07:47.756535

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "e8f748c14b93"
down_revision: Union[str, None] = "801705905f79"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "Scenario",
        sa.Column(
            "scenario_type",
            sa.Enum(
                "SOURCE",
                "MUTATION",
                "SIMULATION",
                name="scenariotype",
                native_enum=False,
            ),
            nullable=True,
        ),
    )

    # Add it with a default value so it gets set
    op.add_column(
        "Station",
        sa.Column(
            "is_electrifiable",
            sa.Boolean(),
            nullable=False,
            server_default=sa.text("true"),
        ),
    )
    # Then alter to remove the default
    op.alter_column("Station", "is_electrifiable", server_default=None)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("Station", "is_electrifiable")
    op.drop_column("Scenario", "scenario_type")
    # ### end Alembic commands ###
