# generated by datamodel-codegen:
#   filename:  http://127.0.0.1:8000/api/openapi.json

from __future__ import annotations

from enum import Enum
from pathlib import Path
from typing import Any, Optional, Union

from pydantic import (
    AwareDatetime,
    BaseModel,
    ConfigDict,
    EmailStr,
    Field,
    RootModel,
    SecretStr,
)


class Level(Enum):
    """
    The level of notification to trigger (e.g., 'info', 'warning', 'error', 'critical')
    """

    info = 'info'
    warning = 'warning'
    error = 'error'
    critical = 'critical'


class Event(Enum):
    all = 'all'
    user = 'user'
    system = 'system'
    deployment = 'deployment'
    permission = 'permission'
    resource_limit = 'resource_limit'
    route_status = 'route_status'
    build_event = 'build_event'
    sensor_event = 'sensor_event'
    source_event = 'source_event'
    run_status = 'run_status'


class ChannelRef(RootModel[str]):
    root: str = Field(
        ...,
        description='Reference to the notification channel to use for sending notifications',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )


class UserChannelRef(RootModel[str]):
    root: str = Field(
        ...,
        description="Reference to the user's notification channel to use for sending notifications",
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )


class BaseNotificationConfig(BaseModel):
    """
    Base class for notification configuration
    """

    name: str = Field(
        ...,
        description='The name of the notification configuration',
        max_length=100,
        title='Notification Config Name',
    )
    description: Optional[str] = Field(
        default=None,
        description='A brief description of the notification configuration',
        title='Notification Config Description',
    )
    level: Level = Field(
        default='info',
        description="The level of notification to trigger (e.g., 'info', 'warning', 'error', 'critical')",
        title='Notification Level',
    )
    events: Optional[list[Event]] = Field(
        default=None,
        description="List of type of events to subscribe to for notifications. TBD: currently only 'all' is supported, which means all events will trigger notifications.",
        title='Subscribed Events',
    )
    channel_ref: Optional[ChannelRef] = Field(
        default=None,
        alias='channelRef',
        description='Reference to the notification channel to use for sending notifications',
        title='Notification Channel Reference',
    )
    user_channel_ref: Optional[UserChannelRef] = Field(
        default=None,
        alias='userChannelRef',
        description="Reference to the user's notification channel to use for sending notifications",
        title='User Notification Channel Reference',
    )


class QuotaTier(BaseModel):
    max_cpu: int = Field(default=0, description='Max CPU millicores', title='Max Cpu')
    max_cpu_per_service: int = Field(
        default=0,
        description='Max CPU millicores per service',
        title='Max Cpu Per Service',
    )
    max_cpu_per_task: int = Field(
        default=0, description='Max CPU cores per task', title='Max Cpu Per Task'
    )
    max_memory_per_service: int = Field(
        default=0,
        description='Max memory per service in MB',
        title='Max Memory Per Service',
    )
    max_memory_per_task: int = Field(
        default=0, description='Max memory per task in MB', title='Max Memory Per Task'
    )
    max_memory: int = Field(
        default=0, description='Max memory in MB', title='Max Memory'
    )
    max_gpu: int = Field(default=0, description='Max GPU cores', title='Max Gpu')
    max_ephemeral_storage: int = Field(
        default=0,
        description='Max ephemeral storage in MB',
        title='Max Ephemeral Storage',
    )
    max_ephemeral_storage_per_service: int = Field(
        default=0,
        description='Max ephemeral storage per service in MB',
        title='Max Ephemeral Storage Per Service',
    )
    max_ephemeral_storage_per_task: int = Field(
        default=0,
        description='Max ephemeral storage per task in MB',
        title='Max Ephemeral Storage Per Task',
    )
    max_concurrent_workflows: int = Field(
        default=0,
        description='Max concurrent workflows',
        title='Max Concurrent Workflows',
    )
    max_persistent_storage: int = Field(
        default=0,
        description='Max persistent storage in MB',
        title='Max Persistent Storage',
    )
    max_persistent_volume_size: int = Field(
        default=0,
        description='Max persistent storage size in MB',
        title='Max Persistent Volume Size',
    )
    max_persistent_volumes: int = Field(
        default=0,
        description='Max number of persistent volumes',
        title='Max Persistent Volumes',
    )
    max_projects: int = Field(
        default=0, description='Max number of projects', title='Max Projects'
    )
    max_stages: int = Field(
        default=0, description='Max number of stages', title='Max Stages'
    )
    max_builds: int = Field(
        default=0, description='Max number of builds', title='Max Builds'
    )
    max_pipelines: int = Field(
        default=0, description='Max number of pipelines', title='Max Pipelines'
    )
    max_tasks: int = Field(
        default=0, description='Max number of tasks', title='Max Tasks'
    )
    max_secrets: int = Field(
        default=0, description='Max number of secrets', title='Max Secrets'
    )
    max_images: int = Field(
        default=0, description='Max number of images', title='Max Images'
    )
    max_sources: int = Field(
        default=0, description='Max number of sources', title='Max Sources'
    )
    max_notebooks: int = Field(
        default=0, description='Max number of notebooks', title='Max Notebooks'
    )
    max_services: int = Field(
        default=0, description='Max number of services', title='Max Services'
    )
    max_configmaps: int = Field(
        default=0, description='Max number of configmaps', title='Max Configmaps'
    )
    name: str = Field(..., max_length=255, title='Name')


class SecretData(RootModel[Optional[dict[str, SecretStr]]]):
    root: Optional[dict[str, SecretStr]] = None


class SecretSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    data: Union[SecretData, dict[str, Any]] = Field(
        ...,
        description="The Secret's data, a dictionary of key-value pairs, values will be converted to string",
        title='Secret Data',
    )


class UserResourceSchema(BaseModel):
    spec: SecretSpec
    org: str = Field(..., title='Org')
    name: str = Field(..., max_length=255, title='Name')
    resource_type: str = Field(..., max_length=20, title='Resource Type')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')


class Email(RootModel[str]):
    root: str = Field(..., max_length=254, title='Email Address')


class Token(RootModel[str]):
    root: str = Field(
        ...,
        description="The user's DPM API authentication token",
        max_length=64,
        title='Token',
    )


class ValidationErrorDetail(BaseModel):
    loc: list[str] = Field(..., title='Loc')
    msg: str = Field(..., title='Msg')
    type: str = Field(..., title='Type')


class RouteFilterSchema(BaseModel):
    user: Optional[str] = Field(
        default=None, description='Filter by project owner email', title='User'
    )
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    project: Optional[str] = Field(
        default=None, description='Filter by project name', title='Project'
    )
    stage: Optional[str] = Field(
        default=None, description='Filter by stage name', title='Stage'
    )
    search: Optional[str] = Field(
        default=None,
        description='Filter by name or description contains (case-insensitive)',
        title='Search',
    )
    status: Optional[str] = Field(
        default=None, description='Filter by route status', title='Status'
    )
    open_access: Optional[bool] = Field(
        default=None, description='Filter by open access status', title='Open Access'
    )
    publish_app: Optional[bool] = Field(
        default=None, description='Filter by publish app status', title='Publish App'
    )
    notebook: Optional[bool] = Field(
        default=False, description='Filter by notebook name', title='Notebook'
    )


class ObjectRef(RootModel[str]):
    root: str = Field(..., max_length=255, title='Object Ref')


class Revision(RootModel[str]):
    root: str = Field(
        ...,
        description="The latest Service's Ready Revision for the Route",
        max_length=255,
        title='Revision',
    )


class NextRevision(RootModel[str]):
    root: str = Field(
        ...,
        description="The next Service's revision to be updated",
        max_length=255,
        title='Next Revision',
    )


class NextRevisionStatus(RootModel[str]):
    root: str = Field(
        ...,
        description="The next revision's status",
        max_length=20,
        title='Next Revision Status',
    )


class ServiceName(RootModel[str]):
    root: str = Field(
        ...,
        description="The Project's service name for the Route",
        max_length=255,
        title='Service Name',
    )


class RouteSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    thumbnail: Optional[str] = Field(default=None, title='Thumbnail')
    url: Optional[str] = Field(default=None, title='Url')
    custom_domains: list[str] = Field(default=[], title='Custom Domains')
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    display_name: str = Field(
        ...,
        description='The name used as title in Oceanum.io Apps site',
        max_length=255,
        title='Display Name',
    )
    tier: str = Field(
        default='frontend', description="The Route's tier", max_length=20, title='Tier'
    )
    publish_app: bool = Field(
        default=False,
        description='Whether to publish this Route as a an App in Oceanum.io Apps site',
        title='Publish App',
    )
    open_access: bool = Field(
        default=False,
        description='Whether the access to this App or Service is open to anyone in the Internet.',
        title='Open Access',
    )
    revision: Optional[Revision] = Field(
        default=None,
        description="The latest Service's Ready Revision for the Route",
        title='Revision',
    )
    next_revision: Optional[NextRevision] = Field(
        default=None,
        description="The next Service's revision to be updated",
        title='Next Revision',
    )
    next_revision_status: Optional[NextRevisionStatus] = Field(
        default=None,
        description="The next revision's status",
        title='Next Revision Status',
    )
    status: str = Field(
        default='pending',
        description='The last known Route Status',
        max_length=20,
        title='Status',
    )
    service_name: Optional[ServiceName] = Field(
        default=None,
        description="The Project's service name for the Route",
        title='Service Name',
    )
    notebook: bool = Field(
        default=False,
        description='Whether the Route is a Jupyter Notebook or not',
        title='Notebook',
    )


class RouteUpdateSchema(BaseModel):
    display_name: str = Field(
        ..., description='The display name of the route', title='Display Name'
    )
    description: str = Field(
        ..., description='The description of the route', title='Description'
    )
    publish_app: bool = Field(
        default=False,
        description='Publish the App or Service route in the Oceanum.io Apps Dashboard',
        title='Publish App or Service',
    )
    open_access: bool = Field(
        default=False,
        description='The access to the Route is open-access, no authentication required',
        title='Open Access',
    )


class PermissionsSchema(BaseModel):
    subject: str = Field(
        ...,
        description="The subject of the permission an user's email or an org's name",
        title='Subject',
    )
    view: Optional[bool] = Field(
        default=None, description='Can view the resource', title='View'
    )
    change: Optional[bool] = Field(
        default=None, description='Can change the resource', title='change'
    )
    delete: Optional[bool] = Field(
        default=None, description='Can delete the resource', title='delete'
    )
    assign: Optional[bool] = Field(
        default=None,
        description='Can assign permissions to other users',
        title='assign',
    )


class ResourcePermissionsSchema(BaseModel):
    users: list[PermissionsSchema] = Field(default=[], title='Users')
    groups: list[PermissionsSchema] = Field(default=[], title='Groups')


class Artifact(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ..., description='The name of the Task Artifact', title='Artifact Name'
    )
    required: Optional[bool] = Field(
        default=None,
        description="Make Artifacts optional, if Artifacts doesn't generate or exist",
        title='Optional Artifact',
    )
    path: Optional[str] = Field(
        default=None,
        description='Path is the container path to the artifact',
        title='Artifact Path',
    )
    env: Optional[str] = Field(
        default=None,
        description='Env is the environment variable name which value is the path to the artifact',
        title='Artifact Environment Variable',
    )


class ImageRef(RootModel[str]):
    root: str = Field(
        ...,
        description='The Image reference name from the list of Image resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Image Reference',
    )


class SecretRef(RootModel[str]):
    root: str = Field(
        ...,
        description='The Secret reference name from the list of Secret resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Secret Reference',
    )


class UserSecretRef(SecretRef):
    pass


class BuildCredentials(BaseModel):
    image_ref: Optional[ImageRef] = Field(
        default=None,
        alias='imageRef',
        description='The image reference from the list of project images, to be used as the base-image for this build, cannot be used with baseImage field.',
        title='Image Reference',
    )
    secret_ref: Optional[SecretRef] = Field(
        default=None,
        alias='secretRef',
        description="A secret reference from the list of project secrets, with 'registry', 'username', 'password' keys set, to be used as Docker credentials for pulling the base-image",
        title='Secret Reference',
    )
    user_secret_ref: Optional[UserSecretRef] = Field(
        default=None,
        alias='userSecretRef',
        description="A user secret reference from the list of user secrets, with 'registry', 'username', 'password' keys set, to be used as Docker credentials for pulling the base-image",
        title='User Secret Reference',
    )


class SourceRef(RootModel[str]):
    root: str = Field(
        ...,
        description='The source repository reference from the list of connected repositories',
        max_length=255,
        min_length=1,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Source Repository Reference',
    )


class ConfigMapRefEnvVar(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description="The ConfigMap's Environment Variable Name",
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='ConfigMap Environment Variable',
    )
    key: str = Field(
        ...,
        description="The ConfigMap's data key to use as the value of the Environment Variable",
        title="ConfigMap's Data Key",
    )


class ConfigMapSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    data: dict[str, Any] = Field(
        ...,
        description="The ConfigMap's data, a dictionary of key-value pairs, values will be converted to string",
        title='ConfigMap Data',
    )


class ConfigmapParameterRef(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The ConfigMap reference to mount in the container',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='ConfigMap Reference',
    )
    key: str = Field(
        ...,
        description='The ConfigMap key to use as the value of the Environment Variable',
        title='ConfigMap Key',
    )


class BuildRef(RootModel[str]):
    root: str = Field(
        ...,
        description='The Build name reference from the list of Build resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Build Reference',
    )


class Family(Enum):
    """
    The resource family of the resource request, if not provided only cpu and memory will be used for scheduling
    """

    e2 = 'e2'
    n2 = 'n2'
    n2d = 'n2d'
    c3 = 'c3'
    c3d = 'c3d'


class ContinueOn(BaseModel):
    """
    ContinueOn defines if a pipeline should continue even if a task or step fails/errors. It can be specified if the workflow should continue when the pod errors, fails or both.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    error: Optional[bool] = Field(default=None, title='Error')
    failed: Optional[bool] = Field(default=None, title='Failed')


class SecretRef1(RootModel[str]):
    root: str = Field(
        ...,
        description='The Secret reference name from the list of Secret resources',
        max_length=255,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Secret Reference',
    )


class CustomDomainSpec(BaseModel):
    name: str = Field(
        ...,
        description='A Fully-Qualified Domain Name (case-insensitive), using only a-z, 0-9 and - (hifen) characters.',
        max_length=255,
        pattern='^([A-Za-z0-9][A-Za-z0-9-]{0,62}[A-Za-z0-9]\\.)+[A-Za-z]{2,63}\\.?$',
        title='Domain Name',
    )
    secret_ref: Optional[SecretRef1] = Field(
        default=None,
        alias='secretRef',
        description='A reference to the Secret containing the SSL/TLS certificate and private cert and key for the Custom Domain, the Secret expect data with 2 keys `tls.crt` and `tls.key`.',
        title='Secret Reference',
    )


class Frequency(Enum):
    """
    The frequency occurrence of each DAG cycle, e.g. @hourly, @daily, @weekly, @monthly, @yearly
    """

    field_minutely = '@minutely'
    field_hourly = '@hourly'
    field_daily = '@daily'
    field_weekly = '@weekly'
    field_monthly = '@monthly'
    field_yearly = '@yearly'


class CyclicDag(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    start_cycle: AwareDatetime = Field(
        ...,
        alias='startCycle',
        description='The start cycle in UTC of the DAG as an iso8601 string i.e. YYYY-MM-DDTHH:MM:SSZ or without timezone info. If no timezone is provided, it will be treated as UTC (Z suffix).',
        title='Startcycle',
    )
    end_cycle: AwareDatetime = Field(
        ...,
        alias='endCycle',
        description='The end cycle in UTC of the DAG as an iso8601 string i.e. YYYY-MM-DDTHH:MM:SSZ with or without timezone info. If no timezone is provided, it will be treated as UTC (Z suffix).',
        title='Endcycle',
    )
    frequency: Frequency = Field(
        ...,
        description='The frequency occurrence of each DAG cycle, e.g. @hourly, @daily, @weekly, @monthly, @yearly',
        title='Frequency',
    )
    interval: int = Field(
        default=1,
        description='The frequency interval multiplier between each DAG cycle',
        gt=0,
        title='Interval',
    )
    parallel_chunks: int = Field(
        default=1,
        alias='parallelChunks',
        description='The number of concurrent chunks to run in parallel. Defaults to 1. A concurrent chunk will ignore dependencies from previous chunks',
        gt=0,
        title='Parallelchunks',
    )


class DatasourceActionType(Enum):
    created = 'created'
    updated = 'updated'
    deleted = 'deleted'


class DockerImageURL(RootModel[str]):
    root: str = Field(..., title='DockerImageURL')


class Medium(Enum):
    """
    What type of storage medium should back this directory. The default is to use the node's default medium (disk/SSD). Must be an empty string (default) or 'Memory'.
    """

    field_ = ''
    memory = 'Memory'


class GitHubSourceRepositorySpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_url: str = Field(
        default='https://github.com',
        alias='baseUrl',
        description='The base URL for GitHub',
        title='GitHub Base URL',
    )
    username: str = Field(
        ...,
        description='The GitHub repository owner or username',
        max_length=255,
        title='GitHub Repository Owner/Username',
    )
    repository: str = Field(
        ..., title='A GitHub Repository Name with Owner/repo-name format'
    )


class GitlabSourceRepositorySpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_url: str = Field(
        default='https://gitlab.com',
        alias='baseUrl',
        description='The base URL for GitLab',
        title='GitLab Base URL',
    )
    username: str = Field(
        ...,
        description='The GitLab username to use for authentication',
        max_length=255,
        title='GitLab Username',
    )
    project: str = Field(
        ...,
        title='A GitLab Project path such as "my-org/namespace/project" or a projectID number (as string)',
    )


class HTTPHeader(BaseModel):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """

    name: str = Field(
        ...,
        description='The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.',
        title='Name',
    )
    value: str = Field(..., description='The header field value', title='Value')


class SecretRef2(SecretRef):
    pass


class ImageSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    image: DockerImageURL = Field(
        ...,
        description='Image reference from project Images or a public or a private image URL, private images requires username and password or secret to be set',
        title='Image reference or URL',
    )
    secret_ref: Optional[SecretRef2] = Field(
        default=None,
        alias='secretRef',
        description="Image Secret Reference from project Secrets containing 'username' and 'password' key:value pairs",
        title='Image Secret Reference',
    )
    user_secret_ref: Optional[UserSecretRef] = Field(
        default=None,
        alias='userSecretRef',
        description="User Secret Reference from user Secrets containing 'username' and 'password' key:value pairs",
        title='User Secret Reference',
    )


class InterCycleDependency(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the dependency',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    look_back: int = Field(
        default=0,
        alias='lookBack',
        description='LookBack is the number of cycles to look back for the dependency, defaults to 0 which translates to depend at the same cycle',
        gt=-1,
        title='Look Back',
    )


class KeyToPath(BaseModel):
    key: str = Field(
        ...,
        description="The Secret's data key to mount as a file inside the specified path",
        title='Secret Data Key',
    )
    mode: Optional[int] = Field(
        default=None,
        description='mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.',
        title='File Mode',
    )
    path: str = Field(
        ...,
        description="path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.",
        pattern='^[a-zA-Z0-9][a-zA-Z0-9_/.-]+$',
        title="Secret's key item mount path",
    )


class Type(Enum):
    """
    The type of notification channel (e.g., 'email', 'slack', 'gchat', 'teams', 'webhook')
    """

    email = 'email'
    slack = 'slack'
    gchat = 'gchat'
    teams = 'teams'
    webhook = 'webhook'


class NotificationChannel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The name of the notification channel',
        max_length=100,
        title='Notification Channel Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    type: Type = Field(
        ...,
        description="The type of notification channel (e.g., 'email', 'slack', 'gchat', 'teams', 'webhook')",
        title='Notification Channel Type',
    )
    recipients: Optional[list[str]] = Field(
        default=None,
        description='List of recipients for the notification. For email, this is a list of email addresses. For Slack and Teams this can be a list of user IDs or channel names and for Gchat it should be a list of Webhook-Urls.',
        title='Notification Recipients',
    )
    mentions: Optional[list[str]] = Field(
        default=None,
        description='List of users to mention in the notification. For Slack and Teams this can be a list of user IDs or usernames, for Gchat it should be a list of user IDs. Email does not support mentions.',
        title='Mentions',
    )


class TaskRef(RootModel[str]):
    root: str = Field(
        ...,
        description='TaskRef is the name of the task to execute',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )


class PipelineRef(RootModel[str]):
    root: str = Field(
        ...,
        description='PipelineRef is the name of the pipeline to execute',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )


class Phase(Enum):
    pending = 'Pending'
    running = 'Running'
    succeeded = 'Succeeded'
    skipped = 'Skipped'
    failed = 'Failed'
    error = 'Error'
    omitted = 'Omitted'


class Schedule(Enum):
    """
    Schedule is a schedule to run the Workflow in Cron format
    """

    field_minutely = '@minutely'
    field_hourly = '@hourly'
    field_daily = '@daily'
    field_weekly = '@weekly'
    field_monthly = '@monthly'
    field_yearly = '@yearly'


class Schedule1(RootModel[str]):
    root: str = Field(
        ...,
        description='CronEvery is a time duration representation as a string e.g. @every 5m, @every 5h, @every 5d, @every 1h30m, @every 1d12h30m',
        pattern='@every\\s(?P<value>\\d+)(?P<unit>[dhms])',
        title='Schedule',
    )


class Delay(RootModel[str]):
    root: str = Field(
        ...,
        description='A time duration representation as a string e.g. 5m, 5h, 5d, 1h30m, 1d12h30m',
        pattern='(?P<value>\\d+)(?P<unit>[dhms])',
        title='Delay',
    )


class ConcurrencyPolicy(Enum):
    """
    ConcurrencyPolicy is the concurrency policy that will be used when scheduled runs overlaps. Allowed values are "Allow", "Forbid", "Replace". Default is "Allow".
    """

    allow = 'Allow'
    forbid = 'Forbid'
    replace = 'Replace'


class PipelineCronTrigger(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    schedule: Union[Schedule, Schedule1, str] = Field(
        ...,
        description='Schedule is a schedule to run the Workflow in Cron format',
        title='Schedule',
    )
    delay: Optional[Delay] = Field(
        default=None,
        description='Delay is a time difference from when this pipeline should start to be executed in relation to scheduled time. e.g. 30m, 1h, 1d',
        title='Delay',
    )
    failed_jobs_history_limit: Optional[int] = Field(
        default=3,
        alias='failedJobsHistoryLimit',
        description='FailedJobsHistoryLimit is the number of failed pipelines to be kept at a time',
        title='Failedjobshistorylimit',
    )
    successful_jobs_history_limit: Optional[int] = Field(
        default=3,
        alias='successfulJobsHistoryLimit',
        description='SuccessfulJobsHistoryLimit is the number of successful jobs to be kept at a time',
        title='Successfuljobshistorylimit',
    )
    suspend: Optional[bool] = Field(
        default=None,
        description='Suspend is a flag that will stop new CronWorkflows from running if set to true',
        title='Suspend',
    )
    timezone: str = Field(
        default='UTC',
        description='Timezone is the timezone against which the cron schedule will be calculated, e.g. "Asia/Tokyo". Default is UTC.',
        title='Timezone',
    )
    concurrency_policy: Optional[ConcurrencyPolicy] = Field(
        default=None,
        alias='concurrencyPolicy',
        description='ConcurrencyPolicy is the concurrency policy that will be used when scheduled runs overlaps. Allowed values are "Allow", "Forbid", "Replace". Default is "Allow".',
        title='Concurrencypolicy',
    )


class Timeout(RootModel[int]):
    root: int = Field(
        ...,
        description="Timeout allows to set the total execution timeout in seconds counting from the Task's start time. If the Task is not completed before the timeout, it will be terminated.",
        gt=0,
        title='Timeout',
    )


class Phase1(Enum):
    """
    The pipeline phase to trigger the event, e.g. Pending, Running, Succeeded, Failed, Error, Skipped or Omitted
    """

    pending = 'Pending'
    running = 'Running'
    succeeded = 'Succeeded'
    skipped = 'Skipped'
    failed = 'Failed'
    error = 'Error'
    omitted = 'Omitted'


class Timeout1(RootModel[int]):
    root: int = Field(
        ...,
        description="Timeout allows to set the total execution timeout in seconds counting from the Pipeline's start time. If the Pipeline is not completed before the timeout, it will be terminated.",
        gt=0,
        title='Timeout',
    )


class PipelineTriggerParameter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the parameter',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )


class UserRef(RootModel[str]):
    root: str = Field(
        ...,
        description='The User reference name from the list of User resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title="User's Reference",
    )


class Quantity(RootModel[Union[str, int, float]]):
    root: Union[str, int, float] = Field(
        ...,
        description='The string input value of a quantity resource',
        title='Quantity',
    )


class MaxDuration(RootModel[str]):
    root: str = Field(
        ...,
        description='A time duration representation as a string e.g. 5m, 5h, 5d, 1h30m, 1d12h30m',
        pattern='(?P<value>\\d+)(?P<unit>[dhms])',
        title='Maxduration',
    )


class RetryBackoff(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    duration: str = Field(
        ...,
        description='Duration is the amount of time to wait before retrying the container. Minimum value is 1s',
        pattern='(?P<value>\\d+)(?P<unit>[dhms])',
        title='Duration',
    )
    factor: int = Field(
        default=1,
        description='Factor is the amount to multiply the duration by on each retry.',
        gt=1,
        title='Factor',
    )
    max_duration: Optional[MaxDuration] = Field(
        default=None,
        alias='maxDuration',
        description='MaxDuration is the maximum amount of time allowed for retrying the container. Minimum value is 1s',
        title='Maxduration',
    )


class RetryStrategy(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    node_anti_affinity: Optional[bool] = Field(
        default=None,
        alias='nodeAntiAffinity',
        description='NodeAntiAffinity is the preference to avoid retrying a task on the same node.',
        title='Nodeantiaffinity',
    )
    limit: int = Field(
        default=0,
        description='Limit is the maximum number of retry attempts when retrying a container. It does not include the original container; the maximum number of total attempts will be `limit + 1`.',
        gt=0,
        title='Limit',
    )
    backoff: Optional[RetryBackoff] = Field(
        default=None,
        description='Backoff is the amount of time to wait before retrying the container. Minimum value is 1ms',
    )


class SecretKeyRef(BaseModel):
    name: str = Field(
        ...,
        description="The Secret's name to use as source of the Environment Variable value",
        max_length=63,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Secret Name',
    )
    key: str = Field(
        ...,
        description="The Secret's data key to use as the value of the Environment Variable",
        title="Secret's Data Key",
    )


class SecretRefMounted(BaseModel):
    name: str = Field(
        ...,
        description='The Secret reference name from the list of Secret resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Secret Reference Name',
    )
    keys: Optional[list[KeyToPath]] = Field(
        default=None,
        description="List of Secret's data keys to mount as files inside a folder represented by path",
        title="Secret's Data Keys",
    )
    path: Optional[str] = Field(
        default=None,
        description="Mount each of the secret's data keys or the ones defined in 'keys' as files inside the specified path",
        pattern='^[/a-zA-Z0-9][a-zA-Z0-9_/.-]+$',
        title="Secret's Mount Path",
    )


class MinReplicas(RootModel[int]):
    root: int = Field(
        ...,
        description='The minimum number of service replicas containers to keep running. Default to 0, however, if metric is cpu or memory, minScale must be greater or equal to 1.',
        ge=0,
        title='Minimum Replicas',
    )


class MaxReplicas(RootModel[int]):
    root: int = Field(
        ...,
        description='The maximum number of service replicas containers to scale up to, default to 3',
        ge=0,
        title='Maximum Replicas',
    )


class Metric(Enum):
    """
    The metric to use for autoscaling. Options are `concurrency` (simultaneous request over `targetWindow` period) or `rps` (requests per second) or `cpu` or `memory`. CPU and Memory target units are millicores and MiB respectivelly. Default to `concurrency`
    """

    concurrency = 'concurrency'
    rps = 'rps'
    cpu = 'cpu'
    memory = 'memory'


class TargetPercentage(RootModel[int]):
    root: int = Field(
        ...,
        description='A percentage for the target metric to reach before starting scaling up. Default to 100%.',
        ge=0,
        le=100,
        title='Target Percentage',
    )


class TargetWindow(RootModel[int]):
    root: int = Field(
        ...,
        description='The target sliding time window in seconds to calculate the metric average. Default to 60 seconds. Minimum 6 seconds and maximum 1 hour.',
        gt=6,
        le=3600,
        title='Target Time Window',
    )


class ServiceAutoscaleSpec(BaseModel):
    min_replicas: Optional[MinReplicas] = Field(
        default=None,
        alias='minReplicas',
        description='The minimum number of service replicas containers to keep running. Default to 0, however, if metric is cpu or memory, minScale must be greater or equal to 1.',
        title='Minimum Replicas',
    )
    max_replicas: Optional[MaxReplicas] = Field(
        default=None,
        alias='maxReplicas',
        description='The maximum number of service replicas containers to scale up to, default to 3',
        title='Maximum Replicas',
    )
    metric: Optional[Metric] = Field(
        default=None,
        description='The metric to use for autoscaling. Options are `concurrency` (simultaneous request over `targetWindow` period) or `rps` (requests per second) or `cpu` or `memory`. CPU and Memory target units are millicores and MiB respectivelly. Default to `concurrency`',
        title='Metric',
    )
    target: Optional[int] = Field(
        default=None,
        description='The target value for the metric. Default to 100.',
        title='Target',
    )
    target_percentage: Optional[TargetPercentage] = Field(
        default=None,
        alias='targetPercentage',
        description='A percentage for the target metric to reach before starting scaling up. Default to 100%.',
        title='Target Percentage',
    )
    target_window: Optional[TargetWindow] = Field(
        default=None,
        alias='targetWindow',
        description='The target sliding time window in seconds to calculate the metric average. Default to 60 seconds. Minimum 6 seconds and maximum 1 hour.',
        title='Target Time Window',
    )


class Port(RootModel[int]):
    root: int = Field(
        ...,
        description="The Service's Health-Check Port, default's to ServicePort",
        ge=0,
        le=65535,
        title='Health Check Port',
    )


class ServiceHealthCheck(BaseModel):
    path: str = Field(
        ...,
        description="The Service's Health-Check Path",
        max_length=256,
        title='Health Check Path',
    )
    port: Optional[Port] = Field(
        default=None,
        description="The Service's Health-Check Port, default's to ServicePort",
        title='Health Check Port',
    )
    headers: Optional[list[HTTPHeader]] = Field(
        default=None,
        description='Custom headers to set in the request. HTTP allows repeated headers.',
        title='Headers',
    )


class DisplayName(RootModel[str]):
    root: str = Field(
        ...,
        description="The Service's Route human readable name to be displayed in Oceanum.io Apps Dashboard",
        max_length=256,
        title='Display Name (DEPRECATED)',
    )


class Description(RootModel[str]):
    root: str = Field(
        ...,
        description="The Service's Route Description to be displayed in Oceanum.io Apps Dashboard, if not provided fallback to Service's Description",
        max_length=255,
        title='Description (DEPRECATED)',
    )


class SourceRefParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The Resource reference name from the list of Project resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    branch: Optional[str] = Field(
        default=None,
        description='The branch to use for cloning the Source Repository and monitor for Git push-events, can be overwritten at stage level, defaults to the Source Repository default branch',
        title='Source Repository Reference Branch',
    )
    tag: Optional[str] = Field(
        default=None,
        description='The tag to use for cloning the Source Repository and monitor for Git push-events, can be overwritten at stage level',
        title='Source Repository Reference Tag',
    )


class SourceRepositorySpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    github: Optional[GitHubSourceRepositorySpec] = Field(
        default=None,
        description='A GitHub repository to use as the source repository',
        title='GitHub Source Repository',
    )
    gitlab: Optional[GitlabSourceRepositorySpec] = Field(
        default=None,
        description='A GitLab repository to use as the source repository',
        title='GitLab Source Repository',
    )
    default_branch: str = Field(
        default='main',
        alias='defaultBranch',
        description='The default branch to use for the source repository',
        max_length=24,
        title='Default Branch',
    )
    secret_ref: Optional[Union[SecretRef2, SecretKeyRef]] = Field(
        default=None,
        alias='secretRef',
        description="The name of a Secret containing a 'token' data key for the source repository or a SecretKeyRef with name and key.",
        title='Source Repository Secret Reference',
    )
    user_secret_ref: Optional[Union[UserSecretRef, SecretKeyRef]] = Field(
        default=None,
        alias='userSecretRef',
        description="The name of a Secret containing a 'token' data key for the repository user or a SecretKeyRef with name and key.",
        title='User Secret Reference',
    )


class StageBuildStatus(BaseModel):
    name: str = Field(
        ..., description='The name of the build in the spec file', title='Build name'
    )
    image_digest: str = Field(
        ...,
        alias='imageDigest',
        description='The last image digest used to build this stage',
        title='Last Image Digest',
    )
    git_ref: Optional[str] = Field(
        default=None,
        alias='gitRef',
        description='The source repository branch or tag that triggered this update if has a sourceRef',
        title='Source Repository Reference',
    )
    commit_sha: Optional[str] = Field(
        default=None,
        alias='commitSHA',
        description='The source repository commit SHA reference that triggered this update if has a sourceRef',
        title='Source Commit SHA',
    )
    updated_at: Optional[AwareDatetime] = Field(
        default=None,
        alias='updatedAt',
        description='The time this push event was received if has a sourceRef',
        title='Source Commit Time',
    )


class Task(RootModel[str]):
    root: str = Field(
        ...,
        description='The Task reference name from the list of Task resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Task Reference',
    )


class Pipeline(RootModel[str]):
    root: str = Field(
        ...,
        description='The Pipeline reference name from the list of Pipeline resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Pipeline Reference',
    )


class Service(RootModel[str]):
    root: str = Field(
        ...,
        description='The Service reference name from the list of Service resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Service Reference',
    )


class Notebook(Service):
    pass


class SourceRef1(RootModel[str]):
    root: str = Field(
        ...,
        description='The source repository reference that triggered this update if has a sourceRef',
        max_length=255,
        min_length=1,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Source Repository Reference',
    )


class StageSourceStatus(BaseModel):
    name: str = Field(
        ...,
        description='The name of the source repository that triggered this update',
        title='Stage Source Name',
    )
    source_ref: Optional[SourceRef1] = Field(
        default=None,
        alias='sourceRef',
        description='The source repository reference that triggered this update if has a sourceRef',
        title='Source Repository Reference',
    )
    commit_sha: Optional[str] = Field(
        default=None,
        alias='commitSHA',
        description='The source repository commit SHA reference that triggered this update if has a sourceRef',
        title='Source Commit Reference',
    )
    latest_tag: Optional[str] = Field(
        default=None,
        alias='latestTag',
        description='The latest source repository tag that triggered this update if has a sourceRef',
        title='Latest Source Tag',
    )
    branch: Optional[str] = Field(
        default=None,
        description='The source repository branch that triggered this update if has a sourceRef',
        title='Source Repository Branch',
    )
    updated_at: Optional[AwareDatetime] = Field(
        default=None,
        alias='updatedAt',
        description='The time this push event was received if has a sourceRef',
        title='Source Commit Time',
    )


class Status(Enum):
    """
    The current state of the stage
    """

    created = 'created'
    updating = 'updating'
    healthy = 'healthy'
    degraded = 'degraded'
    error = 'error'
    deactivated = 'deactivated'


class StageSyncStatus(BaseModel):
    status: Status = Field(
        ..., description='The current state of the stage', title='Stage Status'
    )
    error_message: Optional[str] = Field(
        default=None,
        alias='errorMessage',
        description='The last error message if the stage is in error state',
        title='Error Message',
    )
    updated_at: Optional[AwareDatetime] = Field(
        default=None,
        alias='updatedAt',
        description='Last time this stage was synced from source or image repository',
        title='Last Sync Time',
    )


class Branch(RootModel[str]):
    root: str = Field(
        ...,
        description='Source repository branch to monitor for changes, only commits to this branch will trigger an update for this deployment stage. Accepts wildcards for example',
        max_length=32,
        title='Source Repository Branch',
    )


class StageTrackSpec(BaseModel):
    branch: Optional[Branch] = Field(
        default=None,
        description='Source repository branch to monitor for changes, only commits to this branch will trigger an update for this deployment stage. Accepts wildcards for example',
        title='Source Repository Branch',
    )
    tag: Optional[str] = Field(
        default=None,
        description='Source repository tag Regular Expression to monitor for changes, triggering an update for this deployment stage and fixing each respective build image tag to the tag value.',
        title='Image or Source Repository Tag',
    )


class StepRef(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of a previous step',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    parameter_ref: Optional[str] = Field(
        default=None,
        alias='parameterRef',
        description='Parameter is the name of the output parameter from a previous step',
        title='Parameterref',
    )
    artifact_ref: Optional[str] = Field(
        default=None,
        alias='artifactRef',
        description='ArtifactName is the name of the output artifact from a previous step template',
        title='Artifactref',
    )


class StorageEventType(Enum):
    created = 'created'
    modified = 'modified'
    deleted = 'deleted'


class StorageProtocol(Enum):
    ftp = 'ftp'
    s3 = 's3'
    oceanum = 'oceanum'


class TaskParameter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ..., description='The name of the Task Parameter', title='Parameter Name'
    )
    value: Optional[str] = Field(
        default=None,
        description='Default value to use for an input/output parameter if a value was not supplied as Arguments',
        title='Parameter Value',
    )
    configmap_ref: Optional[ConfigmapParameterRef] = Field(
        default=None,
        alias='configmapRef',
        description='ConfigMapRef is the name of the configmap that contains the parameter value',
        title='Value from ConfigMap Reference',
    )
    description: Optional[str] = Field(
        default=None,
        description='Description is the parameter description',
        title='Parameter Description',
    )
    env: Optional[str] = Field(
        default=None,
        description='Env is the environment variable name that this parameter can be accessed by inside the container',
        title='Parameter Environment Variable',
    )
    path: Optional[str] = Field(
        default=None,
        description='Path in the container where the parameter value is read from',
        title='Parameter Path',
    )


class Timeout2(Timeout):
    pass


class TierOptions(Enum):
    frontend = 'frontend'
    backend = 'backend'


class TimeFilter(BaseModel):
    """
    TimeFilter describes a window in time. It filters out events that occur outside the time limits. In other words, only events that occur after Start and before Stop will pass this filter.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    start: str = Field(
        ...,
        description='Start is the beginning of a time window in UTC. Before this time, events for this dependency are ignored. Format is hh:mm:ss.',
        pattern='^(?:[01]\\d|2[0-3]):([0-5][0-9]):([0-5][0-9])$',
        title='Start',
    )
    stop: str = Field(
        ...,
        description='Stop is the end of a time window in UTC. After or equal to this time, events for this dependency are ignored and Format is hh:mm:ss. If it is smaller than Start, it is treated as next day of Start (e.g.: 22:00:00-01:00:00 means 22:00:00-25:00:00).',
        pattern='^(?:[01]\\d|2[0-3]):([0-5][0-9]):([0-5][0-9])$',
        title='Stop',
    )


class ResourceUsageSchema(BaseModel):
    start_time: Optional[AwareDatetime] = Field(
        default=None, description='The start time of the usage data', title='Start Time'
    )
    end_time: Optional[AwareDatetime] = Field(
        default=None, description='The end time of the usage data', title='End Time'
    )
    cpu: Optional[int] = Field(
        default=0, description='The CPU usage in millicores', title='CPU'
    )
    memory: Optional[int] = Field(
        default=0, description='The Memory usage in MiB', title='Memory'
    )
    ephemeral_storage: Optional[int] = Field(
        default=0,
        description='The Ephemeral Storage usage in MiB',
        title='Ephemeral Storage',
    )
    persistent_storage: Optional[int] = Field(
        default=0,
        description='The Persistent Storage usage in MiB',
        title='Persistent Storage',
    )


class SourceType(RootModel[str]):
    root: str = Field(..., max_length=255, title='Source Type')


class Repository(RootModel[str]):
    root: str = Field(..., max_length=255, title='Repository')


class SourceSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    source_type: Optional[SourceType] = Field(default=None, title='Source Type')
    repository: Optional[Repository] = Field(default=None, title='Repository')
    status: str = Field(default='pending', max_length=20, title='Status')


class StagedRunSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    arguments: Optional[dict[str, Any]] = Field(default=None, title='Arguments')
    message: Optional[str] = Field(default=None, title='Message')
    status: str = Field(..., max_length=20, title='Status')
    started_at: Optional[AwareDatetime] = Field(default=None, title='Started At')
    finished_at: Optional[AwareDatetime] = Field(default=None, title='Finished At')


class TaskSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the task', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')


class ProjectFilterSchema(BaseModel):
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    user: Optional[str] = Field(
        default=None, description='Filter by user email', title='User'
    )
    search: Optional[str] = Field(
        default=None,
        description='Filter by name or description contains (case-insensitive)',
        title='Search',
    )
    status: Optional[str] = Field(
        default=None, description='Filter by project status', title='Status'
    )


class RevisionItemSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the spec revision', title='ID'
    )
    author: str = Field(..., title='Author')
    created_at: AwareDatetime = Field(..., title='Created At')
    number: int = Field(default=0, title='Number')
    status: str = Field(default='created', max_length=20, title='Status')


class StageItemsSchema(BaseModel):
    id: str = Field(..., description='The unique identifier of the stage', title='ID')
    name: str = Field(..., max_length=255, title='Name')
    status: str = Field(default='created', max_length=20, title='Status')
    error_message: str = Field(default='', title='Error Message')
    updated_at: AwareDatetime = Field(..., title='Updated At')


class GetProjectFilterSchema(BaseModel):
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    user: Optional[str] = Field(
        default=None, description='Filter by user email', title='User'
    )


class Op(Enum):
    """
    The operation to perform
    """

    add = 'add'
    replace = 'replace'
    remove = 'remove'


class JSONPatchOpSchema(BaseModel):
    op: Op = Field(..., description='The operation to perform', title='Operation')
    path: str = Field(
        ...,
        description='The path to the value to add, remove or replace',
        examples=['/resources/stages/0/name', '/resources/services/0/env/0/value'],
        title='JSON Path',
    )
    value: Optional[Union[str, dict[str, Any], list, int, float, bool]] = Field(
        default=None,
        description='The value to add or replace, ignored for remove operations',
        examples=['value', 1, 1.0, True, None, {'key': 'value'}, ['value1', 'value2']],
        title='Value',
    )


class SearchStagedResourceFilterSchema(BaseModel):
    user: Optional[str] = Field(
        default=None, description='Filter by project owner email', title='User'
    )
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    project: Optional[str] = Field(
        default=None, description='Filter by project name', title='Project'
    )
    stage: Optional[str] = Field(
        default=None, description='Filter by stage name', title='Stage'
    )
    search: Optional[str] = Field(
        default=None,
        description='Filter by name or description contains (case-insensitive)',
        title='Search',
    )


class StagedResourceFilterSchema(BaseModel):
    user: Optional[str] = Field(
        default=None, description='Filter by project owner email', title='User'
    )
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    project: Optional[str] = Field(
        default=None, description='Filter by project name', title='Project'
    )
    stage: Optional[str] = Field(
        default=None, description='Filter by stage name', title='Stage'
    )


class TaskRunsSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the task', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    runs: list[StagedRunSchema] = Field(..., title='Runs')


class SubmitForm(BaseModel):
    parameters: dict[str, Any] = Field(..., title='Parameters')


class RunFilterSchema(BaseModel):
    user: Optional[str] = Field(
        default=None, description='Filter by project owner email', title='User'
    )
    org: Optional[str] = Field(
        default=None, description='Filter by org name', title='Org'
    )
    project: Optional[str] = Field(
        default=None, description='Filter by project name', title='Project'
    )
    stage: Optional[str] = Field(
        default=None, description='Filter by stage name', title='Stage'
    )
    name: Optional[str] = Field(
        default=None, description='Filter by Build, Task or Pipeline name', title='Name'
    )
    created_after: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by creation time (ISO format)',
        title='Created After',
    )
    created_before: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by creation time (ISO format)',
        title='Created Before',
    )
    started_after: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by start time (ISO format)',
        title='Started After',
    )
    started_before: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by end time (ISO format)',
        title='Started Before',
    )
    finished_after: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by finish time (ISO format)',
        title='Finished After',
    )
    finished_before: Optional[AwareDatetime] = Field(
        default=None,
        description='Filter by finish time (ISO format)',
        title='Finished Before',
    )
    status: Optional[str] = Field(
        default=None, description='Filter by run status', title='Status'
    )


class PipelineRunsSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    schedule: Optional[str] = Field(
        default=None, description='The cron schedule for the pipeline', title='Schedule'
    )
    suspended: Optional[bool] = Field(
        default=False,
        description='The suspended status of the pipeline',
        title='Suspended',
    )
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the pipeline', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    runs: list[StagedRunSchema] = Field(..., title='Runs')


class BuildRunsSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    source_ref: Optional[str] = Field(
        default=None,
        description='The source branch or tag reference that triggered the last successful build',
        title='Source Ref',
    )
    commit_sha: Optional[str] = Field(
        default=None,
        description='The commit SHA of the source code that triggered the last successful build',
        title='Commit SHA',
    )
    image_digest: Optional[str] = Field(
        default=None,
        description='The image digest of the built image from the last successful build',
        title='Image Digest',
    )
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the build', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')
    runs: list[StagedRunSchema] = Field(..., title='Runs')


class OrgSchema(BaseModel):
    tier: QuotaTier
    usage: QuotaTier
    members: list[str] = Field(default=[], title='Members')
    projects: list[str] = Field(default=[], title='Projects')
    resources: list[UserResourceSchema] = Field(..., title='Resources')
    name: str = Field(..., max_length=150, title='Name')


class UserSchema(BaseModel):
    orgs: list[OrgSchema] = Field(default=[], title='Orgs')
    deployable_orgs: list[str] = Field(default=[], title='Deployable Orgs')
    admin_orgs: list[str] = Field(default=[], title='Admin Orgs')
    current_org: Optional[str] = Field(default=None, title='Current Org')
    projects: list[str] = Field(default=[], title='Projects')
    username: str = Field(
        ...,
        description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
        max_length=150,
        title='Username',
    )
    email: Optional[Email] = Field(default=None, title='Email Address')
    token: Optional[Token] = Field(
        default=None,
        description="The user's DPM API authentication token",
        title='Token',
    )


class ErrorResponse(BaseModel):
    detail: Optional[Union[list[ValidationErrorDetail], dict[str, Any], str]] = Field(
        default=None, title='Detail'
    )


class ConfigMapRefMounted(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The ConfigMap reference name from the list of ConfigMap resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='ConfigMap Reference Name',
    )
    keys: Optional[list[KeyToPath]] = Field(
        default=None,
        description="List of ConfigMap's data keys to mount as files inside a folder represented by path",
        title="ConfigMap's Data Keys",
    )
    path: str = Field(
        ...,
        description="Mount each of the secret's data keys or the ones defined in 'keys' as files inside the specified path",
        pattern='^[/a-zA-Z0-9][a-zA-Z0-9_/.-]+$',
        title="ConfigMap's Mount Path",
    )


class ContainerResources(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cpu: Optional[Quantity] = Field(
        default=None,
        description='The quantity of CPU resources, if not provided a system default or parent attribute will be applied',
        title='CPU Quantity',
    )
    memory: Optional[Quantity] = Field(
        default=None,
        description='The quantity of Memory resources, if not provided a system default or parent attribute will be applied',
        title='Memory Quantity',
    )
    storage: Optional[Quantity] = Field(
        default=None,
        description='The quantity of local disk storage required, if not provided, a system default or parent attribute will be applied.',
        title='Ephemeral Storage Quantity',
    )
    family: Optional[Family] = Field(
        default=None,
        description='The resource family of the resource request, if not provided only cpu and memory will be used for scheduling',
        title='Machine Family',
    )
    on_demand: Optional[bool] = Field(
        default=None,
        alias='onDemand',
        description='If the resource request can be scheduled on an on-demand instance (recommended for production workloads). Default is False.',
        title='On-Demand Instance',
    )
    node_labels: Optional[dict[str, str]] = Field(
        default=None,
        alias='nodeLabels',
        description='The node-pool labels to match for scheduling the resource request',
        title='Node Labels',
    )


class DatasourceEventTrigger(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    action_type: DatasourceActionType = Field(
        default='created',
        alias='actionType',
        description='actionType is the event action to trigger the pipeline, e.g. "created", "updated", "deleted"',
        title='Datasource Event Action Type',
    )
    id_filters: Optional[list[str]] = Field(
        default=None,
        alias='idFilters',
        description='idFilters, is list of Datasource IDs.',
        title='Datasource ID Filter',
    )
    name_filter: Optional[list[str]] = Field(
        default=None,
        alias='nameFilter',
        description='nameFilter is a list of Datasource name to filter by the datasource\'s "name" attribute',
        title='Datsource Name Filter',
    )
    driver_filter: Optional[str] = Field(
        default=None,
        alias='driverFilter',
        description='driverFilter a Datasource driver name to filter by the datasource\'s "driver" attribute',
        title='Datasource Driver Filter',
    )
    time_filter: Optional[TimeFilter] = Field(
        default=None,
        alias='timeFilter',
        description='timeFilter is the time filter to limit the events that will trigger the pipeline, only events that occur after Start and before Stop will pass this filter',
        title='Event Time Filter',
    )
    parameters: Optional[list[PipelineTriggerParameter]] = Field(
        default=None,
        description="Propagate values from the event parameters into the triggered pipeline parameters values, the event parameters are 'entity', 'id', 'action', 'modified', 'driver' and 'name'",
        title='Pipeline Trigger Parameters',
    )


class EmptyDirVolumeSource(BaseModel):
    """
    Represents an empty directory for a Container. Empty directory volumes support ownership management and SELinux relabeling.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    medium: Optional[Medium] = Field(
        default=None,
        description="What type of storage medium should back this directory. The default is to use the node's default medium (disk/SSD). Must be an empty string (default) or 'Memory'.",
        title='Medium',
    )
    size_limit: Optional[Quantity] = Field(
        default=None,
        alias='sizeLimit',
        description='sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined.',
    )


class EnvVarValue(BaseModel):
    """
    Represents an environment variable present in a Container.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name of the environment variable. Must be a C_IDENTIFIER.',
        title='Environment Variable Name',
    )
    value: Optional[str] = Field(
        default=None,
        description='Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".',
        title='Environment Variable Value',
    )
    secret_ref: Optional[SecretKeyRef] = Field(
        default=None,
        alias='secretRef',
        description='The secret reference to mount in the container',
        title='Secret Reference',
    )
    user_secret_ref: Optional[SecretKeyRef] = Field(
        default=None,
        alias='userSecretRef',
        description="The User's Secret reference to mount in the container",
        title='User Secret Reference',
    )
    configmap_ref: Optional[ConfigMapRefEnvVar] = Field(
        default=None,
        alias='configmapRef',
        description='The ConfigMap reference to mount in the container',
        title='ConfigMap Reference',
    )


class PersistentVolumeSource(BaseModel):
    """
    PersistentVolumeSource is the specification of a persistent volume. The volume will persist across restarts of the container. Only 1 container at a time can use the volume, so no autoscaling or parallelism supported. Removing the container from deployment Stage or changing the name will delete PersistentVolume resource.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    size_limit: Optional[Quantity] = Field(
        default=None,
        alias='sizeLimit',
        description='sizeLimit is the total amount of persistent storage required for this volume.',
    )


class PipelineArguments(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    parameters: Optional[list[TaskParameter]] = Field(
        default=None,
        description='Parameters declares default parameters passed to all tasks, which can be overridden by individual tasks or during pipeline execution',
        title='Parameters',
    )


class PipelinePhaseEventSource(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pipeline_ref: str = Field(
        ...,
        alias='pipelineRef',
        description='Trigger this pipeline when other pipeline from same project is complete',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Pipeline Reference',
    )
    phase: Phase1 = Field(
        default='Succeeded',
        description='The pipeline phase to trigger the event, e.g. Pending, Running, Succeeded, Failed, Error, Skipped or Omitted',
        title='Pipeline Phase',
    )
    parameters: Optional[list[PipelineTriggerParameter]] = Field(
        default=None,
        description='Propagate values from the dependency pipeline parameters into the triggered pipeline parameters values',
        title='Pipeline Trigger Parameters',
    )


class PipelineTaskArtifact(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the input artifact',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    step_ref: Optional[StepRef] = Field(
        default=None,
        alias='stepRef',
        description='Step is the name of a previous step that produces the artifact',
    )
    optional: Optional[bool] = Field(
        default=None,
        description="Make Artifacts optional, if Artifacts doesn't generate or exist",
        title='Optional',
    )
    path: Optional[str] = Field(
        default=None,
        description='Path is the container path to the artifact',
        title='Path',
    )
    sub_path: Optional[str] = Field(
        default=None,
        alias='subPath',
        description='SubPath allows an artifact to be sourced from a subpath within the specified source',
        title='Subpath',
    )


class PipelineTaskParameter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ..., description='The name of the Task Parameter', title='Parameter Name'
    )
    value: Optional[str] = Field(
        default=None,
        description='Default value to use for an input/output parameter if a value was not supplied as Arguments',
        title='Parameter Value',
    )
    configmap_ref: Optional[ConfigmapParameterRef] = Field(
        default=None,
        alias='configmapRef',
        description='ConfigMapRef is the name of the configmap that contains the parameter value',
        title='Value from ConfigMap Reference',
    )
    step_ref: Optional[StepRef] = Field(
        default=None,
        alias='stepRef',
        description='stepRef is the name of a previous step that produces the parameter',
    )


class PipelineVolume(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name of the volume',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    size: Quantity = Field(
        default_factory=lambda: Quantity.model_validate('10G'),
        description='Size of the volume in Quantity format',
    )
    path: Optional[str] = Field(
        default=None,
        description='Path is the container path to mount the volume, by default the volume will be mounted to /mnt/<name>',
        title='Path',
    )


class ProjectedVolumeMount(BaseModel):
    """
    Represents a projected volume mount that lasts the lifetime of a pod.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The name of the projected mounted volume.',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Volume Name',
    )
    configmap_ref: Optional[ConfigMapRefMounted] = Field(
        default=None,
        alias='configmapRef',
        description='Reference to a ConfigMap name and keys to mount in the container',
    )
    secret_ref: Optional[SecretRefMounted] = Field(
        default=None,
        alias='secretRef',
        description='Reference to a Secret name and keys to mount in the container',
    )
    user_secret_ref: Optional[SecretRefMounted] = Field(
        default=None,
        alias='userSecretRef',
        description='Reference to a User Secret name and keys to mount in the container',
    )


class ServiceRouteSpec(BaseModel):
    display_name: Optional[DisplayName] = Field(
        default=None,
        alias='displayName',
        description="The Service's Route human readable name to be displayed in Oceanum.io Apps Dashboard",
        title='Display Name (DEPRECATED)',
    )
    description: Optional[Description] = Field(
        default=None,
        description="The Service's Route Description to be displayed in Oceanum.io Apps Dashboard, if not provided fallback to Service's Description",
        title='Description (DEPRECATED)',
    )
    publish_app: bool = Field(
        default=False,
        alias='publishApp',
        description="Publish the Service's Route in Oceanum.io Dashboard. Default to `false`",
        title='Publish App (DEPRECATED)',
    )
    tier: Optional[TierOptions] = Field(
        default='frontend',
        description="The Service's Route Tier, default to `frontend`. Options are `frontend` or `backend`",
        title='Tier',
    )
    custom_domains: Optional[list[CustomDomainSpec]] = Field(
        default=None,
        alias='customDomains',
        description="The Service's Route Domains",
        title='Custom Domains',
    )
    open_access: bool = Field(
        default=False,
        alias='openAccess',
        description="Open Access to the Service's Route, no Authentication or permission required",
        title='Open Access (DEPRECATED)',
    )


class StageStatusSpec(BaseModel):
    source_status: Optional[list[StageSourceStatus]] = Field(
        default=None,
        alias='sourceStatus',
        description='Current Source Repository information about this deployment Stage',
        title='Stage Source Status',
    )
    build_status: Optional[list[StageBuildStatus]] = Field(
        default=None,
        alias='buildStatus',
        description='List of Image Builds built and deployed with this stage (read-only).',
        title='Stage Builds',
    )
    sync_status: StageSyncStatus = Field(
        ...,
        alias='syncStatus',
        description='Current Sync information about this deployment Stage',
        title='Stage Sync Status',
    )


class StorageEventTrigger(BaseModel):
    """
    StorageEventTrigger is a trigger that is fired when a storage event occurs.
    It can be used to trigger a pipeline when a file is created, modified or
    deleted in the Oceanum Storage service.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    event_type: list[StorageEventType] = Field(
        default=['created', 'modified'],
        alias='eventType',
        description='eventType is the event action to trigger the pipeline, e.g. "created", "modified" or "deleted"',
        title='Storage Event Type',
    )
    bucket_filters: Optional[list[str]] = Field(
        default=None,
        alias='bucketFilters',
        description="bucketFilters is a list of Org names to filter by. Defaults to project's Org.",
        title='Storage Bucket Filter',
    )
    protocol_filters: Optional[list[StorageProtocol]] = Field(
        default=None,
        alias='protocolFilters',
        description='Protocol is the transfer protocol to filter by, e.g. "s3", "ftp" and "oceanum" are supported. ',
        title='Storage Protocol Filters',
    )
    object_filters: list[str] = Field(
        ...,
        alias='objectFilters',
        description='objectFilters is a list of object paths to filter by, the paths are the full path to the object in the storage, e.g. "path/to/object.txt"or a regular expression (starting with "^")or using a glob wildcard "*" to match multiple objects.',
        title='Storage Object Filter',
    )
    time_filter: Optional[TimeFilter] = Field(
        default=None,
        alias='timeFilter',
        description='timeFilter is the time filter to limit the events that will trigger the pipeline, only events that occur after Start and before Stop will pass this filter',
        title='Event Time Filter',
    )
    parameters: Optional[list[PipelineTriggerParameter]] = Field(
        default=None,
        description="Propagate values from the event parameters into the triggered pipeline parameters values, the event parameters are 'protocol', 'eventType', 'object' and 'timestamp'.",
        title='Pipeline Trigger Parameters',
    )


class TaskInputs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    parameters: list[TaskParameter] = Field(
        default=[],
        description='Input parameters a Task expect as Arguments',
        title='Task Input Parameters',
    )
    artifacts: list[Artifact] = Field(
        default=[],
        description='Input artifacts a Task expect as Arguments',
        title='Task Input Artifacts',
    )


class TaskOutputs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    parameters: list[TaskParameter] = Field(
        default=[],
        description='Output parameters a Task expect as Arguments',
        title='Task Output Parameters',
    )
    artifacts: list[Artifact] = Field(
        default=[],
        description='Output artifacts a Task expect as Arguments',
        title='Task Output Artifacts',
    )


class Volume(BaseModel):
    """
    Volume represents a named volume in a container.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(..., description="Volume's name", title='Name')
    empty_dir: Optional[EmptyDirVolumeSource] = Field(
        default=None,
        alias='emptyDir',
        description="emptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
    )
    persistent_volume: Optional[PersistentVolumeSource] = Field(
        default=None,
        alias='persistentVolume',
        description='persistentVolume represents a persistent volume that is attached to the host and mounted into the pod in the same way that a local volume would be. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes',
    )
    path: Optional[str] = Field(
        default=None,
        description="Path in the container where the volume should be mounted. Must not contain ':'",
        title='Path',
    )


class BuildSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    source_ref: Optional[str] = Field(
        default=None,
        description='The source branch or tag reference that triggered the last successful build',
        title='Source Ref',
    )
    commit_sha: Optional[str] = Field(
        default=None,
        description='The commit SHA of the source code that triggered the last successful build',
        title='Commit SHA',
    )
    image_digest: Optional[str] = Field(
        default=None,
        description='The image digest of the built image from the last successful build',
        title='Image Digest',
    )
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the build', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')


class PipelineSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the staged resource', title='ID'
    )
    org: str = Field(..., title='Org')
    stage: str = Field(..., title='Stage')
    project: str = Field(..., title='Project')
    schedule: Optional[str] = Field(
        default=None, description='The cron schedule for the pipeline', title='Schedule'
    )
    suspended: Optional[bool] = Field(
        default=False,
        description='The suspended status of the pipeline',
        title='Suspended',
    )
    last_run: Optional[StagedRunSchema] = Field(
        default=None, description='The last run of the pipeline', title='Last Run'
    )
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(default=None, title='Description')
    object_ref: Optional[ObjectRef] = Field(default=None, title='Object Ref')
    created_at: AwareDatetime = Field(..., title='Created At')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    details: Optional[dict[str, Any]] = Field(default=None, title='Details')


class StageResourcesSchema(BaseModel):
    routes: list[RouteSchema] = Field(..., title='Routes')
    builds: list[BuildSchema] = Field(..., title='Builds')
    pipelines: list[PipelineSchema] = Field(..., title='Pipelines')
    tasks: list[TaskSchema] = Field(..., title='Tasks')
    sources: list[SourceSchema] = Field(..., title='Sources')
    id: Optional[int] = Field(default=None, title='ID')


class ProjectItemSchema(BaseModel):
    id: str = Field(..., description='The unique identifier of the project', title='ID')
    last_revision: Optional[RevisionItemSchema] = Field(
        default=None,
        description='The last revision of the project spec',
        title='Last Revision',
    )
    stages: list[StageItemsSchema] = Field(..., title='Stages')
    current_usage: ResourceUsageSchema = Field(
        default_factory=lambda: ResourceUsageSchema.model_validate(
            {
                'start_time': None,
                'end_time': None,
                'cpu': 0,
                'memory': 0,
                'ephemeral_storage': 0,
                'persistent_storage': 0,
            }
        ),
        description='The current compute resources usage of the project (only running containers)',
    )
    owner: str = Field(..., title='Owner')
    org: str = Field(..., title='Org')
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(
        default=None,
        description='A description of the project, auto-generated from the spec',
        title='Description',
    )
    created_at: AwareDatetime = Field(..., title='Created At')
    status: str = Field(default='created', max_length=20, title='Status')


class ContainerImageSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[DockerImageURL] = Field(
        default=None, description='A Public Image Repository URL', title='Public Image'
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image_ref: Optional[ImageRef] = Field(
        default=None,
        alias='imageRef',
        description='Image repository from the list of defined Project images to run the container',
        title='Image Repository Reference',
    )
    build_ref: Optional[BuildRef] = Field(
        default=None,
        alias='buildRef',
        description='The build reference from the list of Project builds',
        title='Image Build reference',
    )


class PipelineTaskArguments(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    artifacts: Optional[list[PipelineTaskArtifact]] = Field(
        default=None,
        description='Artifacts declares the artifacts that a step produces',
        title='Artifacts',
    )
    parameters: Optional[list[PipelineTaskParameter]] = Field(
        default=None,
        description='Parameters declares the parameters that a step produces',
        title='Parameters',
    )


class PipelineTriggers(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cron: Optional[PipelineCronTrigger] = Field(
        default=None, description='Cron expression for triggering the pipeline'
    )
    pipeline_phase: Optional[list[PipelinePhaseEventSource]] = Field(
        default=None,
        alias='pipelinePhase',
        description='Trigger this pipeline when other pipeline phase from same project is reached',
        title='Pipelinephase',
    )
    datasource_event: Optional[DatasourceEventTrigger] = Field(
        default=None,
        alias='datasourceEvent',
        description='Trigger this pipeline when a Datamesh Datasource event is emitted',
    )
    storage_event: Optional[StorageEventTrigger] = Field(
        default=None,
        alias='storageEvent',
        description='Trigger this pipeline when a Storage event is emitted',
    )


class StageDetailsSchema(BaseModel):
    id: str = Field(..., description='The unique identifier of the stage', title='ID')
    name: str = Field(..., max_length=255, title='Name')
    status: str = Field(default='created', max_length=20, title='Status')
    error_message: str = Field(default='', title='Error Message')
    updated_at: AwareDatetime = Field(..., title='Updated At')
    resources: Optional[StageResourcesSchema] = Field(
        default=None,
        description='The staged resources status details for the stage.',
        title='Resources',
    )
    spec: Optional[dict[str, Any]] = Field(
        default=None,
        description='The project spec resources rendered for the stage, including stage overlays and defaults',
        title='Staged Resources Spec',
    )
    current_revision: int = Field(
        default=0,
        description='The current revision number of the stage',
        title='Current Revision',
    )


class BuildSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='default',
        description='The build name',
        max_length=32,
        title='Build Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    source_ref: Optional[Union[SourceRef, SourceRefParams]] = Field(
        default=None,
        alias='sourceRef',
        description='The source repository reference from the list of connected repositories',
        title='Source repository reference',
    )
    base_image: Optional[Union[DockerImageURL, ContainerImageSpec]] = Field(
        default=None,
        alias='baseImage',
        description='        The build base-image, can be any public image, for private base images see imageRef field',
        title='Base Image',
    )
    credentials: Optional[BuildCredentials] = Field(
        default=None,
        description='The build credentials to be used for private base-image',
        title='Build Credentials',
    )
    build_command: Optional[str] = Field(
        default=None,
        alias='buildCommand',
        description='        The build command to be executed on the base-image, for multiple commands,        use a script file using a relative path from the source repository root and execute the script        in this field.        ',
        title='Build Command',
    )
    test_command: Optional[str] = Field(
        default=None,
        alias='testCommand',
        description='        The test command to be executed at the end of this image build, for mltiple commands,        use a script file using a relative path from the source repository root and execute the script        in this field.        ',
        title='Test Command',
    )
    dockerfile: Optional[Union[Path, str]] = Field(
        default=None,
        description='        The Dockerfile path relative to source-code root, to be executed on the base-image,         Cannot be provided with baseImage or buildCommand.        ',
        title='Build Dockerfile',
    )


class ContainerCommandRequiredSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='main',
        description='The container name',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Container Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Union[DockerImageURL, ContainerImageSpec] = Field(
        ..., description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: str = Field(
        ...,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )


class ContainerOverlay(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='main',
        description='The container name',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Container Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Optional[Union[DockerImageURL, ContainerImageSpec]] = Field(
        default=None, description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: Optional[str] = Field(
        default=None,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )


class NotebookSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='main',
        description='The container name',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Container Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Union[DockerImageURL, ContainerImageSpec] = Field(
        default='quay.io/jupyter/minimal-notebook:latest',
        description='A Public Image Repository URL, a Build reference or a Image resource reference',
        title='Notebook Image',
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: Optional[str] = Field(
        default='/bin/bash -c \'export PATH="$PATH:/home/jovyan/work/.local/bin" && conda config --prepend pkgs_dirs /home/jovyan/work/.conda/pkgs && start-notebook.py --ip=0.0.0.0 --port=8888 --no-browser --NotebookApp.token="" --LabApp.extra_labextensions_path=/home/jovyan/work/.local/share/jupyter/labextensions\'',
        description='The command to run in the container',
        title='Command',
    )
    service_port: int = Field(
        default=8888,
        alias='servicePort',
        description='The ServicePort',
        ge=0,
        le=65535,
        title='Service Port',
    )
    health_check: ServiceHealthCheck = Field(
        default_factory=lambda: ServiceHealthCheck.model_validate(
            {'path': '/', 'port': 8888, 'headers': None}
        ),
        alias='healthCheck',
        description='The Service Health Check parameters',
        title='Service Health Check',
    )
    route: ServiceRouteSpec = Field(
        default_factory=lambda: ServiceRouteSpec.model_validate(
            {
                'displayName': None,
                'description': None,
                'publishApp': False,
                'tier': 'frontend',
                'customDomains': [],
                'openAccess': False,
            }
        ),
        description="The Service's Route",
        title='Service Route',
    )
    autoscale: Optional[ServiceAutoscaleSpec] = Field(
        default=None,
        description="The Service's Autoscale parameters. ",
        title='Service Autoscale',
    )


class PhaseHook(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the task',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    arguments: Optional[PipelineTaskArguments] = Field(
        default=None,
        description='Arguments are the parameters and artifacts arguments passed to the task.',
    )
    task_ref: Optional[TaskRef] = Field(
        default=None,
        alias='taskRef',
        description='TaskRef is the name of the task to execute',
        title='Taskref',
    )
    pipeline_ref: Optional[PipelineRef] = Field(
        default=None,
        alias='pipelineRef',
        description='PipelineRef is the name of the pipeline to execute',
        title='Pipelineref',
    )
    phases: list[Phase] = Field(
        ...,
        description='Pipeline or Task status phase which the hook is executed.',
        title='Phases',
    )


class PipelineDAGTask(BaseModel):
    """
    DAGTask represents a node in the graph during DAG execution
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the task',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    arguments: Optional[PipelineTaskArguments] = Field(
        default=None,
        description='Arguments are the parameters and artifacts arguments passed to the task.',
    )
    task_ref: Optional[TaskRef] = Field(
        default=None,
        alias='taskRef',
        description='TaskRef is the name of the task to execute',
        title='Taskref',
    )
    pipeline_ref: Optional[PipelineRef] = Field(
        default=None,
        alias='pipelineRef',
        description='PipelineRef is the name of the pipeline to execute',
        title='Pipelineref',
    )
    continue_on: Optional[ContinueOn] = Field(
        default=None,
        alias='continueOn',
        description='ContinueOn allows to proceed with the following step even if this step fails. Errors and Failed states can be specified',
    )
    hooks: Optional[list[PhaseHook]] = Field(
        default=None,
        description='Hooks are a list of status PhaseHooks for this step, overrides pipeline defaults.',
        title='Hooks',
    )
    dependencies: list[Union[str, InterCycleDependency]] = Field(
        default=[],
        description='Dependencies are names of previous PipelineDagTasks which this depends on, InterCycleDependencies is only used with CyclicDAG',
        title='Dependencies',
    )


class PipelineDefaults(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='defaults',
        description='Name is the name of the default task, defaults to "defaults"',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Optional[Union[DockerImageURL, ContainerImageSpec]] = Field(
        default=None, description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: Optional[str] = Field(
        default=None,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )
    inputs: Optional[TaskInputs] = Field(
        default=None,
        description='Inputs describe what inputs parameters and artifacts are supplied to this template',
    )
    outputs: Optional[TaskOutputs] = Field(
        default=None,
        description='Outputs describe the parameters and artifacts that this template produces',
    )
    parallelism: Optional[int] = Field(
        default=None,
        description='Parallelism limits the max total parallel pods that can execute at the same time within the boundaries of this template invocation. If additional steps/dag templates are invoked, the pods created by those templates will not be counted towards this total.',
        title='Parallelism',
    )
    retry_strategy: Optional[RetryStrategy] = Field(
        default=None,
        alias='retryStrategy',
        description='RetryStrategy describes how to retry a template when it fails',
    )
    timeout: Optional[Timeout] = Field(
        default=None,
        description="Timeout allows to set the total execution timeout in seconds counting from the Task's start time. If the Task is not completed before the timeout, it will be terminated.",
        title='Timeout',
    )
    hooks: Optional[list[PhaseHook]] = Field(
        default=None,
        description='Hooks are a list of lifecycle hooks for all the steps, is overriden when also defined in Step or DAG step hooks',
        title='Hooks',
    )


class PipelineOverlay(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    arguments: Optional[PipelineArguments] = Field(
        default=None,
        description='Arguments are the parameter and artifact arguments to the template',
    )
    triggers: Optional[PipelineTriggers] = Field(
        default=None, title='Pipeline Triggers'
    )
    defaults: Optional[PipelineDefaults] = Field(
        default=None,
        description='Default values for pipeline tasks',
        title='Pipeline Defaults',
    )


class PipelineRefParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The Resource reference name from the list of Project resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    overlay: Optional[PipelineOverlay] = Field(
        default=None,
        description='Overlay is the pipeline overlay to apply to the referenced pipeline',
    )


class PipelineStepTask(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='Name is the name of the task',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    arguments: Optional[PipelineTaskArguments] = Field(
        default=None,
        description='Arguments are the parameters and artifacts arguments passed to the task.',
    )
    task_ref: Optional[TaskRef] = Field(
        default=None,
        alias='taskRef',
        description='TaskRef is the name of the task to execute',
        title='Taskref',
    )
    pipeline_ref: Optional[PipelineRef] = Field(
        default=None,
        alias='pipelineRef',
        description='PipelineRef is the name of the pipeline to execute',
        title='Pipelineref',
    )
    continue_on: Optional[ContinueOn] = Field(
        default=None,
        alias='continueOn',
        description='ContinueOn allows to proceed with the following step even if this step fails. Errors and Failed states can be specified',
    )
    hooks: Optional[list[PhaseHook]] = Field(
        default=None,
        description='Hooks are a list of status PhaseHooks for this step, overrides pipeline defaults.',
        title='Hooks',
    )


class ServiceOverlay(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='main',
        description='The container name',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Container Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Optional[Union[DockerImageURL, ContainerImageSpec]] = Field(
        default=None, description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: Optional[str] = Field(
        default=None,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )
    route: Optional[ServiceRouteSpec] = Field(
        default=None, description="The Service's Route", title='Service Route'
    )
    autoscale: Optional[ServiceAutoscaleSpec] = Field(
        default=None,
        description="The Service's Autoscale parameters",
        title='Service Autoscale',
    )


class ServiceRefParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The Resource reference name from the list of Project resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    overlay: Optional[ServiceOverlay] = Field(
        default=None,
        description='The Service overlay to apply to the referenced Service',
        title='Service Overlay',
    )


class ServiceSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        default='main',
        description='The container name',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Container Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Union[DockerImageURL, ContainerImageSpec] = Field(
        ..., description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: str = Field(
        ...,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )
    service_port: int = Field(
        default=80,
        alias='servicePort',
        description='The ServicePort',
        ge=0,
        le=65535,
        title='Service Port',
    )
    health_check: ServiceHealthCheck = Field(
        ...,
        alias='healthCheck',
        description='The Service Health Check parameters',
        title='Service Health Check',
    )
    route: ServiceRouteSpec = Field(
        default_factory=lambda: ServiceRouteSpec.model_validate(
            {
                'displayName': None,
                'description': None,
                'publishApp': False,
                'tier': 'frontend',
                'customDomains': [],
                'openAccess': False,
            }
        ),
        description="The Service's Route",
        title='Service Route',
    )
    autoscale: Optional[ServiceAutoscaleSpec] = Field(
        default=None,
        description="The Service's Autoscale parameters. ",
        title='Service Autoscale',
    )


class TaskRefParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The Resource reference name from the list of Project resources',
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    overlay: Optional[ContainerOverlay] = Field(
        default=None,
        description='The Task overlay to apply to the referenced Task',
        title='Task Overlay',
    )


class TaskSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='A unique name for the Task within the Pipeline',
        title='Task Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    resources: Optional[ContainerResources] = Field(
        default=None,
        description='The machine (CPU, memory, disk) resource-requirements, if not provided a system default or parent resource attribute will be applied',
        title='Container Resources',
    )
    env: Optional[list[EnvVarValue]] = Field(
        default=None, title='Container Environment Variables'
    )
    mounts: Optional[list[ProjectedVolumeMount]] = Field(
        default=None,
        description='List of existing ConfigMaps or Secrets references to mount in the container',
        title='Container Mounts',
    )
    image: Union[DockerImageURL, ContainerImageSpec] = Field(
        ..., description='A Public Image Repository URL', title='Public Image'
    )
    sidecars: Optional[list[ContainerCommandRequiredSpec]] = Field(
        default=None,
        description='List of arbitrary sidecar containers to start with the main container',
        title='Sidecar Containers',
    )
    volumes: Optional[list[Volume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted in Tasks.',
        title='Volumes',
    )
    command: str = Field(
        ...,
        description='The container command to be executed, accepts environment variables with sintax $(VAR_NAME)',
        title='Container Command',
    )
    inputs: Optional[TaskInputs] = Field(
        default=None,
        description='Inputs describe what inputs parameters and artifacts are supplied to this template',
    )
    outputs: Optional[TaskOutputs] = Field(
        default=None,
        description='Outputs describe the parameters and artifacts that this template produces',
    )
    parallelism: Optional[int] = Field(
        default=None,
        description='Parallelism limits the max total parallel pods that can execute at the same time within the boundaries of this template invocation. If additional steps/dag templates are invoked, the pods created by those templates will not be counted towards this total.',
        title='Parallelism',
    )
    retry_strategy: Optional[RetryStrategy] = Field(
        default=None,
        alias='retryStrategy',
        description='RetryStrategy describes how to retry a template when it fails',
    )
    timeout: Optional[Timeout2] = Field(
        default=None,
        description="Timeout allows to set the total execution timeout in seconds counting from the Task's start time. If the Task is not completed before the timeout, it will be terminated.",
        title='Timeout',
    )


class PipelineParallelSteps(RootModel[list[PipelineStepTask]]):
    root: list[PipelineStepTask] = Field(..., title='PipelineParallelSteps')


class PipelineSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    arguments: Optional[PipelineArguments] = Field(
        default=None,
        description='Arguments are the parameter and artifact arguments to the template',
    )
    triggers: Optional[PipelineTriggers] = Field(
        default=None, title='Pipeline Triggers'
    )
    defaults: Optional[PipelineDefaults] = Field(
        default=None,
        description='Default values for pipeline tasks',
        title='Pipeline Defaults',
    )
    dag: Optional[list[PipelineDAGTask]] = Field(
        default=None,
        description='List of arbitrary pipeline tasks',
        title='Pipeline Tasks',
    )
    cyclic_dag: Optional[CyclicDag] = Field(
        default=None,
        alias='cyclicDag',
        description='CyclicDag is a DAG that repeats on a schedule',
    )
    fail_fast: bool = Field(
        default=True,
        alias='failFast',
        description='Only for DAGs, failFast will stop the execution of the pipeline if any node fails. Set to false to allow DAG to continue execution even if a any of the node fails. Steps always fail fast unless continueOn is set',
        title='Failfast',
    )
    hooks: Optional[list[PhaseHook]] = Field(
        default=None,
        description='Hooks are a list of lifecycle hooks for all the steps, is overriden when also defined in Step or DAG step hooks',
        title='Hooks',
    )
    steps: Optional[list[PipelineParallelSteps]] = Field(
        default=None,
        description='Steps define a series of sequential/parallel workflow steps',
        title='Steps',
    )
    volumes: Optional[list[PipelineVolume]] = Field(
        default=None,
        description='Volumes is a list of volumes that can be mounted by containers in a template',
        title='Volumes',
    )
    timeout: Optional[Timeout1] = Field(
        default=None,
        description="Timeout allows to set the total execution timeout in seconds counting from the Pipeline's start time. If the Pipeline is not completed before the timeout, it will be terminated.",
        title='Timeout',
    )


class StageResourcesSpec(BaseModel):
    tasks: Optional[Union[list[Task], list[TaskRefParams]]] = Field(
        default=None,
        description='List of standalone Tasks to be executed in this deployment stage',
        title='Stage Tasks',
    )
    pipelines: Optional[Union[list[Pipeline], list[PipelineRefParams]]] = Field(
        default=None,
        description='Pipelines to be deployed in this deployment stage',
        title='Stage Pipelines',
    )
    services: Optional[Union[list[Service], list[ServiceRefParams]]] = Field(
        default=None,
        description='List of Services to be deployed in this deployment stage',
        title='Stage Services',
    )
    notebooks: Optional[Union[list[Notebook], list[ServiceRefParams]]] = Field(
        default=None,
        description='List of Notebooks to be deployed in this deployment stage',
        title='Stage Notebooks',
    )


class StageSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        description='The name of the deployment stage',
        max_length=12,
        min_length=1,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Stage Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    active: Optional[bool] = Field(
        default=True,
        description='Whether this stage is active or not',
        title='Stage Active',
    )
    resources: Optional[StageResourcesSpec] = Field(
        default=None,
        description='Resources to be deployed in this deployment stage',
        title='Stage Resources',
    )
    track: Optional[StageTrackSpec] = Field(
        default=None,
        description='Source repository tracking information for this deployment stage',
        title='Stage Tracking',
    )
    status: Optional[StageStatusSpec] = Field(
        default=None,
        description='Current Sync information about this deployment Stage (read-only)',
        title='Stage Status',
    )


class ProjectResourcesSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    configmaps: list[ConfigMapSpec] = Field(
        default=[], description='List of project configmaps', title='Project ConfigMaps'
    )
    secrets: list[SecretSpec] = Field(
        default=[], description='List of project secrets', title='Project Secrets'
    )
    channels: list[NotificationChannel] = Field(
        default=[],
        description='List of project notification channels',
        title='Project Notification Channels',
    )
    images: list[ImageSpec] = Field(
        default=[], description='List of project images', title='Project Images'
    )
    sources: list[SourceRepositorySpec] = Field(
        default=[],
        description='List of project source repositories',
        title='Project Sources',
    )
    builds: list[BuildSpec] = Field(
        default=[], description='List of project builds', title='Project Builds'
    )
    tasks: list[Union[TaskSpec, PipelineDefaults]] = Field(
        default=[], description='List of project tasks', title='Project Tasks'
    )
    pipelines: list[PipelineSpec] = Field(
        default=[], description='List of project pipelines', title='Project Pipelines'
    )
    services: list[ServiceSpec] = Field(
        default=[], description='List of project services', title='Project Services'
    )
    notebooks: list[NotebookSpec] = Field(
        default=[], description='List of project notebooks', title='Project Notebooks'
    )
    stages: list[StageSpec] = Field(
        default=[],
        description='List of project deployment stages',
        title='Project Stages',
    )


class ProjectSpec(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str = Field(
        ...,
        max_length=32,
        min_length=3,
        pattern='^[a-z]([a-z0-9-]+[a-z0-9])?$',
        title='Resource Name',
    )
    description: Optional[str] = Field(default=None, title='Resource Description')
    notifications: Optional[list[BaseNotificationConfig]] = Field(
        default=None,
        description='List of notification configurations for the resource',
        title='Notifications',
    )
    version: str = Field(
        default='v1',
        description='The Project Specification version',
        title='Project Spec Version',
    )
    user_ref: Optional[UserRef] = Field(
        default=None,
        alias='userRef',
        description='The Organization normalized name for the project to be deployed as',
        title='Project User Reference',
    )
    member_ref: Optional[EmailStr] = Field(
        default=None,
        alias='memberRef',
        description='The Organization Member email, owner of the project.',
        title='Project User Member Reference',
    )
    active: bool = Field(
        default=True,
        description='Whether this project is active to be deployed or not',
        title='Project Active',
    )
    resources: Optional[ProjectResourcesSpec] = Field(
        default=None, title='Project Resources'
    )


class RevisionDetailsSchema(BaseModel):
    id: str = Field(
        ..., description='The unique identifier of the spec revision', title='ID'
    )
    author: str = Field(..., title='Author')
    created_at: AwareDatetime = Field(..., title='Created At')
    number: int = Field(default=0, title='Number')
    status: str = Field(default='created', max_length=20, title='Status')
    spec: ProjectSpec = Field(..., description='The project spec', title='Spec')


class ProjectDetailsSchema(BaseModel):
    id: str = Field(..., description='The unique identifier of the project', title='ID')
    last_revision: Optional[RevisionDetailsSchema] = Field(
        default=None,
        description='The last revision of the project spec',
        title='Last Revision',
    )
    stages: list[StageDetailsSchema] = Field(..., title='Stages')
    current_usage: ResourceUsageSchema = Field(
        default_factory=lambda: ResourceUsageSchema.model_validate(
            {
                'start_time': None,
                'end_time': None,
                'cpu': 0,
                'memory': 0,
                'ephemeral_storage': 0,
                'persistent_storage': 0,
            }
        ),
        description='The current compute resources usage of the project (only running containers)',
    )
    owner: str = Field(..., title='Owner')
    org: str = Field(..., title='Org')
    name: str = Field(..., max_length=255, title='Name')
    description: Optional[str] = Field(
        default=None,
        description='A description of the project, auto-generated from the spec',
        title='Description',
    )
    created_at: AwareDatetime = Field(..., title='Created At')
    status: str = Field(default='created', max_length=20, title='Status')
    cumulative_usage: ResourceUsageSchema = Field(
        default_factory=lambda: ResourceUsageSchema.model_validate(
            {
                'start_time': None,
                'end_time': None,
                'cpu': 0,
                'memory': 0,
                'ephemeral_storage': 0,
                'persistent_storage': 0,
            }
        ),
        description='The accumulated compute resources usage-seconds of the project',
    )


ContainerCommandRequiredSpec.model_rebuild()
