# 工具模块接口说明

---

## 1. 概述

工具模块 (`utils/`) 提供项目内的通用基础能力，包括求解模型统一访问、日志与随机控制、全局解题状态、图像渲染对象等。

---

## 2. 模块结构

| 模块名               | 功能说明                 |
|-------------------|----------------------|
| `tool.py`         | 日志与随机数工具函数           |
| `impl_obj.py`     | 解题器全局状态接口（如总雷数与种子）   |
| `image_create.py` | 渲染模块，输出图像与文字构件       |

---

## 3. 接口总览

### tool.py

| 类型 | 名称                            | 说明         |
|----|-------------------------------|------------|
| 函数 | [`get_logger()`](#get_logger) | 获取项目通用日志对象 |
| 函数 | [`get_random()`](#get_random) | 获取全局随机数生成器 |

### impl_obj.py

| 类型 | 名称                          | 说明          |
|----|-----------------------------|-------------|
| 函数 | [`get_seed()`](#get_seed)   | 获取种子值或当前时间戳 |
| 函数 | [`get_total()`](#get_total) | 获取当前雷数信息    |

### image_create.py

| 类型 | 名称                             | 说明                |
|----|--------------------------------|-------------------|
| 函数 | [`get_text(...)`](#get_text)   | 构造文本显示元素          |
| 函数 | [`get_image(...)`](#get_image) | 构造图像显示元素          |
| 函数 | [`get_row(...)`](#get_row)     | 构造水平排列的显示元素组      |
| 函数 | [`get_col(...)`](#get_col)     | 构造垂直排列的显示元素组      |
| 函数 | [`get_dummy(...)`](#get_dummy) | 构造空白占位显示元素，用于布局补齐 |

### summon.solver.Switch

**函数**: [`switch.get(...)`]

---

## 4. 接口详解

### get\_logger()

**模块**：`tool.py`

**返回类型**：`logging.Logger`

**说明**：返回项目全局日志对象，支持 `.debug()` / `.info()` / `.warn()` / `.error()`。

---

### get\_random()

**模块**：`tool.py`

**返回类型**：`random.Random`

**说明**：返回项目使用的全局随机对象，确保所有模块共享统一的随机性源。

---

### get\_seed()

**模块**：`impl_obj.py`

**返回类型**：`int`

**说明**：获取当前全局随机对象的种子值，用于记录题目生成状态。

---

### get\_total()

**模块**：`impl_obj.py`

**返回类型**：`int`

**说明**：获取当前题板的总雷数，主要供左线规则引用。

---

### `get_text(...)`

**说明**：构造一个文本显示元素。

| 参数名                  | 类型                  | 说明                                  |                          |
|----------------------|---------------------|-------------------------------------|--------------------------|
| `text`               | `str`               | 文本内容                                |                          |
| `width`              | `float` or `"auto"` | 显示宽度，单位为格；可设为 `"auto"` 由系统自动判断      |                          |
| `height`             | `float` or `"auto"` | 显示高度，单位为格；可设为 `"auto"` 由系统自动判断      |                          |
| `cover_pos_label`    | `bool`              | 是否覆盖底层格子上的位置标记（如 `X=N`）             |                          |
| `color`              | `tuple[str, str]`   | 色彩设置，格式为两种颜色字符串：黑底文本色与白底文本色         |                          |
| `dominant_by_height` | \`bool              | 是否以高度为主导缩放维度，见下文“[主导方向说明](#主导方向说明)” |

---

### `get_image(...)`

**说明**：构造一个图像显示元素，从 `assets/` 目录加载 PNG 图像。

| 参数名                  | 类型                  | 说明                                  |                          |
|----------------------|---------------------|-------------------------------------|--------------------------|
| `image_path`         | `str`               | 图像路径（不含 `.png` 扩展名）                 |                          |
| `image_width`        | `float` or `"auto"` | 图像显示宽度，单位为格；可设为 `"auto"`            |                          |
| `image_height`       | `float` or `"auto"` | 图像显示高度，单位为格；可设为 `"auto"`            |                          |
| `cover_pos_label`    | `bool`              | 是否覆盖底层位置标记（如 `X=N`）                 |                          |
| `dominant_by_height` | \`bool              | 是否以高度为主导缩放维度，见下文“[主导方向说明](#主导方向说明)” |

---

### `get_row(...)`

**说明**：构造一组水平排列的显示元素。

| 参数名                  | 类型     | 说明                                        |                          |
|----------------------|--------|-------------------------------------------|--------------------------|
| `*args`              | 显示元素列表 | 所有子元素对象（如来自 `get_text()`、`get_image()` 等） |                          |
| `spacing`            | `int`  | 每个元素之间的间隔，单位为格                            |                          |
| `dominant_by_height` | \`bool | 是否以高度为主导缩放维度，见下文“[主导方向说明](#主导方向说明)”       |

---

### `get_col(...)`

**说明**：构造一组垂直排列的显示元素。

| 参数名                  | 类型     | 说明                                  |                          |
|----------------------|--------|-------------------------------------|--------------------------|
| `*args`              | 显示元素列表 | 所有子元素对象                             |                          |
| `spacing`            | `int`  | 每个元素之间的间隔，单位为格                      |                          |
| `dominant_by_height` | \`bool | 是否以高度为主导缩放维度，见下文“[主导方向说明](#主导方向说明)” |

---

### `get_dummy(...)`

**说明**：构造一个空白占位元素。

| 参数名      | 类型      | 说明      |
|----------|---------|---------|
| `width`  | `float` | 宽度，单位为格 |
| `height` | `float` | 高度，单位为格 |

---

### `switch.get(...)`

**说明**: 
* 该函数为一个类的调用api 供规则在创建约束的时候实现控制开关
* 将会在create_constraints的时候作为参数传入switch实体对象

**参数**:
* model(CpModel): 在create_constraints的时候的对应model对象 来控制在其中的具体开关
* obj(AbstractRule/AbstractValue/AbstractPositions):
  * AbstractRule: 传入则直接作为该规则的约束开关
  * AbstractValue: 传入该值的时候将会获取该Value的pos信息并进入下方Pos情况(必须拥有pos对象)
  * AbstractPositions: 传入的时候将会当作该格的约束开关

**备注**:
* 如果get被多次同个对象调用 则视为该规则拥有多个子规则 但是请保证顺序
* 如果pos被调用多次则所有该位置的开关都会被合并为一个总开关来视作是该位置的开关

**返回**: 返回一个Boolvar需要在create_constraints的时候使用If语句控制该约束的开关

---

### 主导方向说明
`dominant_by_height`

此参数决定元素在容器中的**缩放基准维度**，适用于行列布局内的对齐控制：

* 若设置为 `True`（高度主导）：

  * 在 `get_row(...)` 中，系统将统一所有子元素的高度，按相同比例缩放；
  * 宽度保持相对独立，可根据内容变化或拉伸；
  * 常用于图文组合，确保高度一致性。

* 若设置为 `False`（宽度主导）：

  * 在 `get_row(...)` 中，系统将统一子元素宽度；
  * 剩余总宽度按比例或自动分配；
  * 常用于图形平铺、网格展示等。

* 若设为 `None`：

  * 元素不会指定主导维度；
  * 父级容器根据上下文自动判断是否进行缩放处理；
  * 适合用于 `placeholder` 或非内容性元素。

> 注意：该参数控制的是**组内对齐策略**，并不会影响元素本身的渲染逻辑，需配合 `get_row()` 或 `get_col()` 使用才生效。

---

## 相关文档

### [README.md](../README.md) << 入口文档

### [rule_clue.md](./rule_clue.md) << 右线规则接口

### [rule_clue_mines.md](./rule_clue_mines.md) << 中线规则接口

### [rule_mines.md](./rule_mines.md) << 左线规则接口

### [board_api.md](./board_api.md) << 题板与坐标系统接口
