import pandas as pd
import matplotlib.pyplot as plt
plt.rcParams['font.family'] = 'Nirmala UI'  # or 'Mangal', 'Lohit Devanagari'
import re

devanagari_map = {
    "डएफ": "def",
    "इफ": "if",
    "इन": "in",
    "एल्स": "else",
    "फॉर": "for",
    "प्रिन्ट": "print",
    "रिटर्न": "return",
    "ट्रू": "True",
    "फालसे": "False",
    "इंडेक्स": "index",
    "ईंट": "int",
    "नोन": "None",
    "हट": "input",
    "टाइप": "type",
    "डफ": "df",
    "पद": "pd",
    "डाटफरमे": "DataFrame",
    "प्लॉट": "plot",
    "पलट" : "plt",
    "टाइटल": "title",
    "क्षलबेल": "xlabel",
    "यलबेल": "ylabel",
    "ग्रिड": "grid",
    "शो": "show",
    "क्ष": "x",
    "य": "y",
    "काइन्ड": "kind",
    "लाइन": "line",
    "ओ": "o",
    "मार्कर": "marker",
    
    "यक्ष": "ax",
    "गक": "gca",
    "सेट_क्षतिककलबेलस": "set_xticklabels",
    "सेट_यटिक्कलबेलस": "set_yticklabels",
    "गेट_क्षतिककलबेलस": "get_xticklabels",
    "गेट_यटिक्कलबेलस": "get_yticklabels",
    "लेबल।गेट_टेक्स्ट": "label.get_text",
    "लेबल": "label",


    "।": '.',
    "१": "1",
    "२": "2",
    "३": "3",
    "४": "4", 
    "५": "5",
    "६": "6",
    "७": "7",
    "८": "8",
    "९": "9",
    "०": "0"
}

def कूल(number):
    mapping = {
        "0": "०", "1": "१", "2": "२", "3": "३", "4": "४",
        "5": "५", "6": "६", "7": "७", "8": "८", "9": "९"
    }
    return ''.join(mapping.get(ch, ch) for ch in str(number))

def devanagari_to_python(code, mapping):
    # Step 1: Protect string literals
    string_literals = re.findall(r'"[^"]*"', code)
    protected = {s: f"__STR_{i}__" for i, s in enumerate(string_literals)}
    for s, token in protected.items():
        code = code.replace(s, token)

    # Step 2: Replace keywords
    for dev in sorted(mapping, key=len, reverse=True):
        code = code.replace(dev, mapping[dev])

    # Step 3: Restore string literals
    for s, token in protected.items():
        code = code.replace(token, s)

    return code
def चलाओ(dev_code, mapping=devanagari_map):
    py_code = devanagari_to_python(dev_code, mapping)
    exec(py_code)
