# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 config_nonsensitive: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 environment: pulumi.Input['ConnectorEnvironmentArgs'],
                 kafka_cluster: pulumi.Input['ConnectorKafkaClusterArgs'],
                 config_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 offsets: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_nonsensitive: Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input['ConnectorEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_sensitive: Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]] offsets: Connector partitions with offsets
        :param pulumi.Input[_builtins.str] status: The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.
               
               For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).
               
               > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.
               
               > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        pulumi.set(__self__, "config_nonsensitive", config_nonsensitive)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if config_sensitive is not None:
            pulumi.set(__self__, "config_sensitive", config_sensitive)
        if offsets is not None:
            pulumi.set(__self__, "offsets", offsets)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="configNonsensitive")
    def config_nonsensitive(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_nonsensitive")

    @config_nonsensitive.setter
    def config_nonsensitive(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "config_nonsensitive", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ConnectorEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ConnectorEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Input['ConnectorKafkaClusterArgs']:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: pulumi.Input['ConnectorKafkaClusterArgs']):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="configSensitive")
    def config_sensitive(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_sensitive")

    @config_sensitive.setter
    def config_sensitive(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_sensitive", value)

    @_builtins.property
    @pulumi.getter
    def offsets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]]:
        """
        Connector partitions with offsets
        """
        return pulumi.get(self, "offsets")

    @offsets.setter
    def offsets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]]):
        pulumi.set(self, "offsets", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.

        For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).

        > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.

        > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ConnectorState:
    def __init__(__self__, *,
                 config_nonsensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input['ConnectorEnvironmentArgs']] = None,
                 kafka_cluster: Optional[pulumi.Input['ConnectorKafkaClusterArgs']] = None,
                 offsets: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connector resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_nonsensitive: Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_sensitive: Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input['ConnectorEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]] offsets: Connector partitions with offsets
        :param pulumi.Input[_builtins.str] status: The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.
               
               For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).
               
               > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.
               
               > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        if config_nonsensitive is not None:
            pulumi.set(__self__, "config_nonsensitive", config_nonsensitive)
        if config_sensitive is not None:
            pulumi.set(__self__, "config_sensitive", config_sensitive)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if offsets is not None:
            pulumi.set(__self__, "offsets", offsets)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="configNonsensitive")
    def config_nonsensitive(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_nonsensitive")

    @config_nonsensitive.setter
    def config_nonsensitive(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_nonsensitive", value)

    @_builtins.property
    @pulumi.getter(name="configSensitive")
    def config_sensitive(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_sensitive")

    @config_sensitive.setter
    def config_sensitive(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_sensitive", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ConnectorEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ConnectorEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input['ConnectorKafkaClusterArgs']]:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input['ConnectorKafkaClusterArgs']]):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter
    def offsets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]]:
        """
        Connector partitions with offsets
        """
        return pulumi.get(self, "offsets")

    @offsets.setter
    def offsets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorOffsetArgs']]]]):
        pulumi.set(self, "offsets", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.

        For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).

        > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.

        > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("confluentcloud:index/connector:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_nonsensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[Union['ConnectorEnvironmentArgs', 'ConnectorEnvironmentArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
                 offsets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorOffsetArgs', 'ConnectorOffsetArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example Managed [Datagen Source Connector](https://docs.confluent.io/cloud/current/connectors/cc-datagen-source.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/managed-datagen-source-connector
        source = confluentcloud.Connector("source",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={},
            config_nonsensitive={
                "connector.class": "DatagenSource",
                "name": "DatagenSourceConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "kafka.topic": orders["topicName"],
                "output.data.format": "JSON",
                "quickstart": "ORDERS",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_write_on_target_topic,
                    app_connector_create_on_data_preview_topics,
                    app_connector_write_on_data_preview_topics,
                ]))
        ```

        ### Example Managed [Amazon S3 Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-s3-sink.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/s3-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "aws.access.key.id": "***REDACTED***",
                "aws.secret.access.key": "***REDACTED***",
            },
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "S3_SINK",
                "name": "S3_SINKConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "s3.bucket.name": "<s3-bucket-name>",
                "output.data.format": "JSON",
                "time.interval": "DAILY",
                "flush.size": "1000",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Managed [Amazon S3 Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-s3-sink.html) that uses a service account to communicate with your Kafka cluster and IAM Roles for AWS authentication
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/s3-sink-connector-assume-role
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={},
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "S3_SINK",
                "name": "S3_SINKConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "s3.bucket.name": "<s3-bucket-name>",
                "output.data.format": "JSON",
                "time.interval": "DAILY",
                "flush.size": "1000",
                "tasks.max": "1",
                "authentication.method": "IAM Roles",
                "provider.integration.id": main["id"],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                    main,
                    s3_access_role,
                ]))
        ```

        ### Example Managed [Amazon DynamoDB Connector](https://docs.confluent.io/cloud/current/connectors/cc-amazon-dynamo-db-sink.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/dynamo-db-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "aws.access.key.id": "***REDACTED***",
                "aws.secret.access.key": "***REDACTED***",
            },
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "DynamoDbSink",
                "name": "DynamoDbSinkConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "aws.dynamodb.pk.hash": "value.userid",
                "aws.dynamodb.pk.sort": "value.pageid",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Managed [MySQL Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-mysql-sink.html) that uses a service account to communicate with your Kafka cluster

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/manage-offsets-source-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "connection.password": "***REDACTED***",
            },
            config_nonsensitive={
                "connector.class": "MySqlSink",
                "name": "MySQLSinkConnector_0",
                "topics": orders["topicName"],
                "input.data.format": "AVRO",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "db.name": "test_database",
                "connection.user": "confluent_user",
                "connection.host": "dev-testing-temp.abcdefghijk.us-west-7.rds.amazonaws.com",
                "connection.port": "3306",
                "insert.mode": "INSERT",
                "auto.create": "true",
                "auto.evolve": "true",
                "tasks.max": "1",
            },
            offsets=[
                {
                    "partition": {
                        "kafka_partition": "0",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "100",
                    },
                },
                {
                    "partition": {
                        "kafka_partition": "1",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "200",
                    },
                },
                {
                    "partition": {
                        "kafka_partition": "2",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "300",
                    },
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Custom [Datagen Source Connector](https://www.confluent.io/hub/confluentinc/kafka-connect-datagen) that uses a Kafka API Key to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/custom-datagen-source-connector
        source = confluentcloud.Connector("source",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "kafka.api.key": "***REDACTED***",
                "kafka.api.secret": "***REDACTED***",
            },
            config_nonsensitive={
                "confluent.connector.type": "CUSTOM",
                "connector.class": source_confluent_custom_connector_plugin["connectorClass"],
                "name": "DatagenConnectorExampleName",
                "kafka.auth.mode": "KAFKA_API_KEY",
                "kafka.topic": orders["topicName"],
                "output.data.format": "JSON",
                "quickstart": "ORDERS",
                "confluent.custom.plugin.id": source_confluent_custom_connector_plugin["id"],
                "min.interval": "1000",
                "max.interval": "2000",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[app_manager_kafka_cluster_admin]))
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Connector` resource:
        * s3-sink-connector
        * s3-sink-connector-assume-role
        * snowflake-sink-connector
        * managed-datagen-source-connector
        * elasticsearch-sink-connector
        * dynamo-db-sink-connector
        * mongo-db-source-connector
        * mongo-db-sink-connector
        * sql-server-cdc-debezium-source-connector
        * postgre-sql-cdc-debezium-source-connector
        * custom-datagen-source-connector
        * manage-offsets-github-source-connector
        * manage-offsets-mongo-db-source-connector
        * manage-offsets-mysql-sink-connector

        > **Note:** Certain connectors require additional ACL entries. See [Additional ACL entries](https://docs.confluent.io/cloud/current/connectors/service-account.html#additional-acl-entries) for more details.

        > **Note:** If there isn’t an example available for your target connector in the connectors folder, use the Confluent Cloud Console to begin the provisioning process. This can help you determine the required ACLs (example). You can also refer to the connector’s documentation page ([example](https://docs.confluent.io/cloud/current/connectors/cc-amazon-dynamo-db-sink.html#step-3-create-the-connector-configuration-file)) to copy its default configuration and learn more about all available settings. Afterward, we recommend selecting an example with the same connector type (sink or source) and modifying its ACL list and configuration to fit your specific requirements.

        ## Import

        You can import a connector by using Environment ID, Kafka cluster ID, and connector's name, in the format `<Environment ID>/<Kafka cluster ID>/<Connector name>`, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/connector:Connector my_connector "env-abc123/lkc-abc123/S3_SINKConnector_0"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_nonsensitive: Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_sensitive: Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Union['ConnectorEnvironmentArgs', 'ConnectorEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorOffsetArgs', 'ConnectorOffsetArgsDict']]]] offsets: Connector partitions with offsets
        :param pulumi.Input[_builtins.str] status: The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.
               
               For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).
               
               > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.
               
               > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example Managed [Datagen Source Connector](https://docs.confluent.io/cloud/current/connectors/cc-datagen-source.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/managed-datagen-source-connector
        source = confluentcloud.Connector("source",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={},
            config_nonsensitive={
                "connector.class": "DatagenSource",
                "name": "DatagenSourceConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "kafka.topic": orders["topicName"],
                "output.data.format": "JSON",
                "quickstart": "ORDERS",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_write_on_target_topic,
                    app_connector_create_on_data_preview_topics,
                    app_connector_write_on_data_preview_topics,
                ]))
        ```

        ### Example Managed [Amazon S3 Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-s3-sink.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/s3-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "aws.access.key.id": "***REDACTED***",
                "aws.secret.access.key": "***REDACTED***",
            },
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "S3_SINK",
                "name": "S3_SINKConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "s3.bucket.name": "<s3-bucket-name>",
                "output.data.format": "JSON",
                "time.interval": "DAILY",
                "flush.size": "1000",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Managed [Amazon S3 Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-s3-sink.html) that uses a service account to communicate with your Kafka cluster and IAM Roles for AWS authentication
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/s3-sink-connector-assume-role
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={},
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "S3_SINK",
                "name": "S3_SINKConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "s3.bucket.name": "<s3-bucket-name>",
                "output.data.format": "JSON",
                "time.interval": "DAILY",
                "flush.size": "1000",
                "tasks.max": "1",
                "authentication.method": "IAM Roles",
                "provider.integration.id": main["id"],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                    main,
                    s3_access_role,
                ]))
        ```

        ### Example Managed [Amazon DynamoDB Connector](https://docs.confluent.io/cloud/current/connectors/cc-amazon-dynamo-db-sink.html) that uses a service account to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/dynamo-db-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "aws.access.key.id": "***REDACTED***",
                "aws.secret.access.key": "***REDACTED***",
            },
            config_nonsensitive={
                "topics": orders["topicName"],
                "input.data.format": "JSON",
                "connector.class": "DynamoDbSink",
                "name": "DynamoDbSinkConnector_0",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "aws.dynamodb.pk.hash": "value.userid",
                "aws.dynamodb.pk.sort": "value.pageid",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Managed [MySQL Sink Connector](https://docs.confluent.io/cloud/current/connectors/cc-mysql-sink.html) that uses a service account to communicate with your Kafka cluster

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/manage-offsets-source-sink-connector
        sink = confluentcloud.Connector("sink",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "connection.password": "***REDACTED***",
            },
            config_nonsensitive={
                "connector.class": "MySqlSink",
                "name": "MySQLSinkConnector_0",
                "topics": orders["topicName"],
                "input.data.format": "AVRO",
                "kafka.auth.mode": "SERVICE_ACCOUNT",
                "kafka.service.account.id": app_connector["id"],
                "db.name": "test_database",
                "connection.user": "confluent_user",
                "connection.host": "dev-testing-temp.abcdefghijk.us-west-7.rds.amazonaws.com",
                "connection.port": "3306",
                "insert.mode": "INSERT",
                "auto.create": "true",
                "auto.evolve": "true",
                "tasks.max": "1",
            },
            offsets=[
                {
                    "partition": {
                        "kafka_partition": "0",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "100",
                    },
                },
                {
                    "partition": {
                        "kafka_partition": "1",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "200",
                    },
                },
                {
                    "partition": {
                        "kafka_partition": "2",
                        "kafka_topic": orders["topicName"],
                    },
                    "offset": {
                        "kafka_offset": "300",
                    },
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    app_connector_describe_on_cluster,
                    app_connector_read_on_target_topic,
                    app_connector_create_on_dlq_lcc_topics,
                    app_connector_write_on_dlq_lcc_topics,
                    app_connector_create_on_success_lcc_topics,
                    app_connector_write_on_success_lcc_topics,
                    app_connector_create_on_error_lcc_topics,
                    app_connector_write_on_error_lcc_topics,
                    app_connector_read_on_connect_lcc_group,
                ]))
        ```

        ### Example Custom [Datagen Source Connector](https://www.confluent.io/hub/confluentinc/kafka-connect-datagen) that uses a Kafka API Key to communicate with your Kafka cluster
        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/tree/master/examples/configurations/connectors/custom-datagen-source-connector
        source = confluentcloud.Connector("source",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": basic["id"],
            },
            config_sensitive={
                "kafka.api.key": "***REDACTED***",
                "kafka.api.secret": "***REDACTED***",
            },
            config_nonsensitive={
                "confluent.connector.type": "CUSTOM",
                "connector.class": source_confluent_custom_connector_plugin["connectorClass"],
                "name": "DatagenConnectorExampleName",
                "kafka.auth.mode": "KAFKA_API_KEY",
                "kafka.topic": orders["topicName"],
                "output.data.format": "JSON",
                "quickstart": "ORDERS",
                "confluent.custom.plugin.id": source_confluent_custom_connector_plugin["id"],
                "min.interval": "1000",
                "max.interval": "2000",
                "tasks.max": "1",
            },
            opts = pulumi.ResourceOptions(depends_on=[app_manager_kafka_cluster_admin]))
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Connector` resource:
        * s3-sink-connector
        * s3-sink-connector-assume-role
        * snowflake-sink-connector
        * managed-datagen-source-connector
        * elasticsearch-sink-connector
        * dynamo-db-sink-connector
        * mongo-db-source-connector
        * mongo-db-sink-connector
        * sql-server-cdc-debezium-source-connector
        * postgre-sql-cdc-debezium-source-connector
        * custom-datagen-source-connector
        * manage-offsets-github-source-connector
        * manage-offsets-mongo-db-source-connector
        * manage-offsets-mysql-sink-connector

        > **Note:** Certain connectors require additional ACL entries. See [Additional ACL entries](https://docs.confluent.io/cloud/current/connectors/service-account.html#additional-acl-entries) for more details.

        > **Note:** If there isn’t an example available for your target connector in the connectors folder, use the Confluent Cloud Console to begin the provisioning process. This can help you determine the required ACLs (example). You can also refer to the connector’s documentation page ([example](https://docs.confluent.io/cloud/current/connectors/cc-amazon-dynamo-db-sink.html#step-3-create-the-connector-configuration-file)) to copy its default configuration and learn more about all available settings. Afterward, we recommend selecting an example with the same connector type (sink or source) and modifying its ACL list and configuration to fit your specific requirements.

        ## Import

        You can import a connector by using Environment ID, Kafka cluster ID, and connector's name, in the format `<Environment ID>/<Kafka cluster ID>/<Connector name>`, for example:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/connector:Connector my_connector "env-abc123/lkc-abc123/S3_SINKConnector_0"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_nonsensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[Union['ConnectorEnvironmentArgs', 'ConnectorEnvironmentArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
                 offsets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorOffsetArgs', 'ConnectorOffsetArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            if config_nonsensitive is None and not opts.urn:
                raise TypeError("Missing required property 'config_nonsensitive'")
            __props__.__dict__["config_nonsensitive"] = config_nonsensitive
            __props__.__dict__["config_sensitive"] = None if config_sensitive is None else pulumi.Output.secret(config_sensitive)
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if kafka_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster'")
            __props__.__dict__["kafka_cluster"] = kafka_cluster
            __props__.__dict__["offsets"] = offsets
            __props__.__dict__["status"] = status
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["configSensitive"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connector, __self__).__init__(
            'confluentcloud:index/connector:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_nonsensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            config_sensitive: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            environment: Optional[pulumi.Input[Union['ConnectorEnvironmentArgs', 'ConnectorEnvironmentArgsDict']]] = None,
            kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
            offsets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorOffsetArgs', 'ConnectorOffsetArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_nonsensitive: Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_sensitive: Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        :param pulumi.Input[Union['ConnectorEnvironmentArgs', 'ConnectorEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorOffsetArgs', 'ConnectorOffsetArgsDict']]]] offsets: Connector partitions with offsets
        :param pulumi.Input[_builtins.str] status: The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.
               
               For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).
               
               > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.
               
               > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorState.__new__(_ConnectorState)

        __props__.__dict__["config_nonsensitive"] = config_nonsensitive
        __props__.__dict__["config_sensitive"] = config_sensitive
        __props__.__dict__["environment"] = environment
        __props__.__dict__["kafka_cluster"] = kafka_cluster
        __props__.__dict__["offsets"] = offsets
        __props__.__dict__["status"] = status
        return Connector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configNonsensitive")
    def config_nonsensitive(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Block for custom *nonsensitive* configuration properties that are *not* labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_nonsensitive")

    @_builtins.property
    @pulumi.getter(name="configSensitive")
    def config_sensitive(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Block for custom *sensitive* configuration properties that are labelled with "Type: password" under "Configuration Properties" section in [the docs](https://docs.confluent.io/cloud/current/connectors/index.html):
        """
        return pulumi.get(self, "config_sensitive")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ConnectorEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Output['outputs.ConnectorKafkaCluster']:
        return pulumi.get(self, "kafka_cluster")

    @_builtins.property
    @pulumi.getter
    def offsets(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorOffset']]]:
        """
        Connector partitions with offsets
        """
        return pulumi.get(self, "offsets")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the connector (one of `"NONE"`, `"PROVISIONING"`, `"RUNNING"`, `"DEGRADED"`, `"FAILED"`, `"PAUSED"`, `"DELETED"`). Pausing (`"RUNNING" > "PAUSED"`) and resuming (`"PAUSED" > "RUNNING"`) a connector is supported via an update operation.

        For more information on connector offset management, see [Manage Offsets for Fully-Managed Connectors in Confluent Cloud](https://docs.confluent.io/cloud/current/connectors/offsets.html).

        > **Note:** If there are no _sensitive_ configuration settings for your connector, set `config_sensitive = {}` explicitly.

        > **Note:** You may declare sensitive variables for secrets `config_sensitive` block and set them using environment variables (for example, `export TF_VAR_aws_access_key_id="foo"`).
        """
        return pulumi.get(self, "status")

