# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKafkaClustersResult',
    'AwaitableGetKafkaClustersResult',
    'get_kafka_clusters',
    'get_kafka_clusters_output',
]

@pulumi.output_type
class GetKafkaClustersResult:
    """
    A collection of values returned by getKafkaClusters.
    """
    def __init__(__self__, clusters=None, environment=None, id=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetKafkaClustersClusterResult']:
        """
        (Required List of Object) List of Kafka clusters. Each Kafka cluster object exports the following attributes:
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> 'outputs.GetKafkaClustersEnvironmentResult':
        """
        (Required Object) exports the following attributes:
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetKafkaClustersResult(GetKafkaClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaClustersResult(
            clusters=self.clusters,
            environment=self.environment,
            id=self.id)


def get_kafka_clusters(environment: Optional[Union['GetKafkaClustersEnvironmentArgs', 'GetKafkaClustersEnvironmentArgsDict']] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaClustersResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `get_kafka_clusters` describes a data source for Kafka Clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_kafka_clusters(environment={
        "id": "env-123abc",
    })
    ```


    :param Union['GetKafkaClustersEnvironmentArgs', 'GetKafkaClustersEnvironmentArgsDict'] environment: (Required Object) exports the following attributes:
    """
    __args__ = dict()
    __args__['environment'] = environment
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getKafkaClusters:getKafkaClusters', __args__, opts=opts, typ=GetKafkaClustersResult).value

    return AwaitableGetKafkaClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'))
def get_kafka_clusters_output(environment: Optional[pulumi.Input[Union['GetKafkaClustersEnvironmentArgs', 'GetKafkaClustersEnvironmentArgsDict']]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaClustersResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `get_kafka_clusters` describes a data source for Kafka Clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_kafka_clusters(environment={
        "id": "env-123abc",
    })
    ```


    :param Union['GetKafkaClustersEnvironmentArgs', 'GetKafkaClustersEnvironmentArgsDict'] environment: (Required Object) exports the following attributes:
    """
    __args__ = dict()
    __args__['environment'] = environment
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getKafkaClusters:getKafkaClusters', __args__, opts=opts, typ=GetKafkaClustersResult)
    return __ret__.apply(lambda __response__: GetKafkaClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id')))
