# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateLinkAttachmentResult',
    'AwaitableGetPrivateLinkAttachmentResult',
    'get_private_link_attachment',
    'get_private_link_attachment_output',
]

@pulumi.output_type
class GetPrivateLinkAttachmentResult:
    """
    A collection of values returned by getPrivateLinkAttachment.
    """
    def __init__(__self__, aws=None, azures=None, cloud=None, display_name=None, dns_domain=None, environment=None, gcps=None, id=None, region=None, resource_name=None):
        if aws and not isinstance(aws, list):
            raise TypeError("Expected argument 'aws' to be a list")
        pulumi.set(__self__, "aws", aws)
        if azures and not isinstance(azures, list):
            raise TypeError("Expected argument 'azures' to be a list")
        pulumi.set(__self__, "azures", azures)
        if cloud and not isinstance(cloud, str):
            raise TypeError("Expected argument 'cloud' to be a str")
        pulumi.set(__self__, "cloud", cloud)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns_domain and not isinstance(dns_domain, str):
            raise TypeError("Expected argument 'dns_domain' to be a str")
        pulumi.set(__self__, "dns_domain", dns_domain)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if gcps and not isinstance(gcps, list):
            raise TypeError("Expected argument 'gcps' to be a list")
        pulumi.set(__self__, "gcps", gcps)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Sequence['outputs.GetPrivateLinkAttachmentAwResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws")

    @_builtins.property
    @pulumi.getter
    def azures(self) -> Sequence['outputs.GetPrivateLinkAttachmentAzureResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "azures")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> _builtins.str:
        """
        (Optional String) The cloud service provider that hosts the resources to access with the Private Link Attachment.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (Optional String) The name of the Private Link Attachment.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> _builtins.str:
        """
        (Required String) The root DNS domain for the Private Link Attachment, for example, `pr123a.us-east-2.aws.confluent.cloud`.
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> 'outputs.GetPrivateLinkAttachmentEnvironmentResult':
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def gcps(self) -> Sequence['outputs.GetPrivateLinkAttachmentGcpResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "gcps")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        (Optional String) The cloud service provider region where the resources to be accessed using the Private Link Attachment are located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        (Required String) The Confluent Resource Name of the Private Link Attachment, for example `crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-75gxp2/private-link-attachment=platt-1q0ky0`.
        """
        return pulumi.get(self, "resource_name")


class AwaitableGetPrivateLinkAttachmentResult(GetPrivateLinkAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateLinkAttachmentResult(
            aws=self.aws,
            azures=self.azures,
            cloud=self.cloud,
            display_name=self.display_name,
            dns_domain=self.dns_domain,
            environment=self.environment,
            gcps=self.gcps,
            id=self.id,
            region=self.region,
            resource_name=self.resource_name)


def get_private_link_attachment(environment: Optional[Union['GetPrivateLinkAttachmentEnvironmentArgs', 'GetPrivateLinkAttachmentEnvironmentArgsDict']] = None,
                                id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateLinkAttachmentResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `PrivateLinkAttachment` describes a Private Link Attachment data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_private_link_attachment(id="platt-abcde",
        environment={
            "id": "env-1234",
        })
    pulumi.export("platt", main)
    ```

    ## Getting Started

    The following end-to-end examples might help to get started with `PrivateLinkAttachment` data source:
    * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
    * enterprise-privatelinkattachment-azure-kafka-acls: _Enterprise_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs


    :param _builtins.str id: The ID of the Private Link Attachment, for example, `platt-61ovvd`.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getPrivateLinkAttachment:getPrivateLinkAttachment', __args__, opts=opts, typ=GetPrivateLinkAttachmentResult).value

    return AwaitableGetPrivateLinkAttachmentResult(
        aws=pulumi.get(__ret__, 'aws'),
        azures=pulumi.get(__ret__, 'azures'),
        cloud=pulumi.get(__ret__, 'cloud'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns_domain=pulumi.get(__ret__, 'dns_domain'),
        environment=pulumi.get(__ret__, 'environment'),
        gcps=pulumi.get(__ret__, 'gcps'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        resource_name=pulumi.get(__ret__, 'resource_name'))
def get_private_link_attachment_output(environment: Optional[pulumi.Input[Union['GetPrivateLinkAttachmentEnvironmentArgs', 'GetPrivateLinkAttachmentEnvironmentArgsDict']]] = None,
                                       id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateLinkAttachmentResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `PrivateLinkAttachment` describes a Private Link Attachment data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_private_link_attachment(id="platt-abcde",
        environment={
            "id": "env-1234",
        })
    pulumi.export("platt", main)
    ```

    ## Getting Started

    The following end-to-end examples might help to get started with `PrivateLinkAttachment` data source:
    * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
    * enterprise-privatelinkattachment-azure-kafka-acls: _Enterprise_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs


    :param _builtins.str id: The ID of the Private Link Attachment, for example, `platt-61ovvd`.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getPrivateLinkAttachment:getPrivateLinkAttachment', __args__, opts=opts, typ=GetPrivateLinkAttachmentResult)
    return __ret__.apply(lambda __response__: GetPrivateLinkAttachmentResult(
        aws=pulumi.get(__response__, 'aws'),
        azures=pulumi.get(__response__, 'azures'),
        cloud=pulumi.get(__response__, 'cloud'),
        display_name=pulumi.get(__response__, 'display_name'),
        dns_domain=pulumi.get(__response__, 'dns_domain'),
        environment=pulumi.get(__response__, 'environment'),
        gcps=pulumi.get(__response__, 'gcps'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        resource_name=pulumi.get(__response__, 'resource_name')))
