# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProviderIntegrationSetupResult',
    'AwaitableGetProviderIntegrationSetupResult',
    'get_provider_integration_setup',
    'get_provider_integration_setup_output',
]

@pulumi.output_type
class GetProviderIntegrationSetupResult:
    """
    A collection of values returned by getProviderIntegrationSetup.
    """
    def __init__(__self__, cloud=None, display_name=None, environment=None, id=None, status=None, usages=None):
        if cloud and not isinstance(cloud, str):
            raise TypeError("Expected argument 'cloud' to be a str")
        pulumi.set(__self__, "cloud", cloud)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if usages and not isinstance(usages, list):
            raise TypeError("Expected argument 'usages' to be a list")
        pulumi.set(__self__, "usages", usages)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> _builtins.str:
        """
        (Computed String) The cloud service provider. Values are `AZURE` and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (Required String) The display name of the Provider Integration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> 'outputs.GetProviderIntegrationSetupEnvironmentResult':
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required String) The ID of the Environment that the Provider Integration belongs to, for example, `env-abc123`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        (Required String) The status of the Provider Integration. Values are `DRAFT` and `CREATED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def usages(self) -> Sequence[_builtins.str]:
        """
        (Required List of Strings) List of resource CRNs where this provider integration is being used.
        """
        return pulumi.get(self, "usages")


class AwaitableGetProviderIntegrationSetupResult(GetProviderIntegrationSetupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProviderIntegrationSetupResult(
            cloud=self.cloud,
            display_name=self.display_name,
            environment=self.environment,
            id=self.id,
            status=self.status,
            usages=self.usages)


def get_provider_integration_setup(display_name: Optional[_builtins.str] = None,
                                   environment: Optional[Union['GetProviderIntegrationSetupEnvironmentArgs', 'GetProviderIntegrationSetupEnvironmentArgsDict']] = None,
                                   id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProviderIntegrationSetupResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `ProviderIntegrationSetup` describes a Cloud Service Provider (CSP) integration that allows Confluent Cloud to access resources in your cloud provider account.

    ## Example Usage

    ### Azure Provider Integration

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    azure = confluentcloud.get_provider_integration_setup(id="cspi-abc123",
        environment={
            "id": "env-xyz456",
        })
    pulumi.export("azureIntegrationStatus", azure.status)
    ```

    ### GCP Provider Integration

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    gcp = confluentcloud.get_provider_integration_setup(display_name="my-gcp-integration",
        environment={
            "id": "env-xyz456",
        })
    pulumi.export("gcpIntegrationId", gcp.id)
    ```

    ### Using with Authorization Resource

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_provider_integration_setup(id="cspi-abc123",
        environment={
            "id": "env-xyz456",
        })
    # Use the integration with authorization data source
    main_get_provider_integration_authorization = confluentcloud.get_provider_integration_authorization(id=main.id,
        environment={
            "id": "env-xyz456",
        })
    ```

    ## Getting Started

    The following end-to-end examples might help to get started with `ProviderIntegrationSetup` data source:
    * provider-integration-azure: Complete Azure Provider Integration setup
    * provider-integration-gcp: Complete GCP Provider Integration setup


    :param _builtins.str display_name: The display name of the Provider Integration. Exactly one of `id` or `display_name` must be specified.
    :param Union['GetProviderIntegrationSetupEnvironmentArgs', 'GetProviderIntegrationSetupEnvironmentArgsDict'] environment: (Required Configuration Block) supports the following:
    :param _builtins.str id: The ID of the Provider Integration, for example, `cspi-4xg0q`. Exactly one of `id` or `display_name` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getProviderIntegrationSetup:getProviderIntegrationSetup', __args__, opts=opts, typ=GetProviderIntegrationSetupResult).value

    return AwaitableGetProviderIntegrationSetupResult(
        cloud=pulumi.get(__ret__, 'cloud'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'),
        usages=pulumi.get(__ret__, 'usages'))
def get_provider_integration_setup_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          environment: Optional[pulumi.Input[Union['GetProviderIntegrationSetupEnvironmentArgs', 'GetProviderIntegrationSetupEnvironmentArgsDict']]] = None,
                                          id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProviderIntegrationSetupResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `ProviderIntegrationSetup` describes a Cloud Service Provider (CSP) integration that allows Confluent Cloud to access resources in your cloud provider account.

    ## Example Usage

    ### Azure Provider Integration

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    azure = confluentcloud.get_provider_integration_setup(id="cspi-abc123",
        environment={
            "id": "env-xyz456",
        })
    pulumi.export("azureIntegrationStatus", azure.status)
    ```

    ### GCP Provider Integration

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    gcp = confluentcloud.get_provider_integration_setup(display_name="my-gcp-integration",
        environment={
            "id": "env-xyz456",
        })
    pulumi.export("gcpIntegrationId", gcp.id)
    ```

    ### Using with Authorization Resource

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_provider_integration_setup(id="cspi-abc123",
        environment={
            "id": "env-xyz456",
        })
    # Use the integration with authorization data source
    main_get_provider_integration_authorization = confluentcloud.get_provider_integration_authorization(id=main.id,
        environment={
            "id": "env-xyz456",
        })
    ```

    ## Getting Started

    The following end-to-end examples might help to get started with `ProviderIntegrationSetup` data source:
    * provider-integration-azure: Complete Azure Provider Integration setup
    * provider-integration-gcp: Complete GCP Provider Integration setup


    :param _builtins.str display_name: The display name of the Provider Integration. Exactly one of `id` or `display_name` must be specified.
    :param Union['GetProviderIntegrationSetupEnvironmentArgs', 'GetProviderIntegrationSetupEnvironmentArgsDict'] environment: (Required Configuration Block) supports the following:
    :param _builtins.str id: The ID of the Provider Integration, for example, `cspi-4xg0q`. Exactly one of `id` or `display_name` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getProviderIntegrationSetup:getProviderIntegrationSetup', __args__, opts=opts, typ=GetProviderIntegrationSetupResult)
    return __ret__.apply(lambda __response__: GetProviderIntegrationSetupResult(
        cloud=pulumi.get(__response__, 'cloud'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status'),
        usages=pulumi.get(__response__, 'usages')))
