# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaClusterArgs', 'KafkaCluster']

@pulumi.input_type
class KafkaClusterArgs:
    def __init__(__self__, *,
                 availability: pulumi.Input[_builtins.str],
                 cloud: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['KafkaClusterEnvironmentArgs'],
                 region: pulumi.Input[_builtins.str],
                 basic: Optional[pulumi.Input['KafkaClusterBasicArgs']] = None,
                 byok_key: Optional[pulumi.Input['KafkaClusterByokKeyArgs']] = None,
                 dedicated: Optional[pulumi.Input['KafkaClusterDedicatedArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprises: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]] = None,
                 freights: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]] = None,
                 network: Optional[pulumi.Input['KafkaClusterNetworkArgs']] = None,
                 standard: Optional[pulumi.Input['KafkaClusterStandardArgs']] = None):
        """
        The set of arguments for constructing a KafkaCluster resource.
        :param pulumi.Input[_builtins.str] availability: The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input['KafkaClusterEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[_builtins.str] region: The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        :param pulumi.Input['KafkaClusterBasicArgs'] basic: The configuration of the Basic Kafka cluster.
        :param pulumi.Input['KafkaClusterDedicatedArgs'] dedicated: (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]] enterprises: The configuration of the Enterprise Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]] freights: The configuration of the Freight Kafka cluster.
        :param pulumi.Input['KafkaClusterNetworkArgs'] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        :param pulumi.Input['KafkaClusterStandardArgs'] standard: The configuration of the Standard Kafka cluster.
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "region", region)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if byok_key is not None:
            pulumi.set(__self__, "byok_key", byok_key)
        if dedicated is not None:
            pulumi.set(__self__, "dedicated", dedicated)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enterprises is not None:
            pulumi.set(__self__, "enterprises", enterprises)
        if freights is not None:
            pulumi.set(__self__, "freights", freights)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if standard is not None:
            pulumi.set(__self__, "standard", standard)

    @_builtins.property
    @pulumi.getter
    def availability(self) -> pulumi.Input[_builtins.str]:
        """
        The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['KafkaClusterEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['KafkaClusterEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['KafkaClusterBasicArgs']]:
        """
        The configuration of the Basic Kafka cluster.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['KafkaClusterBasicArgs']]):
        pulumi.set(self, "basic", value)

    @_builtins.property
    @pulumi.getter(name="byokKey")
    def byok_key(self) -> Optional[pulumi.Input['KafkaClusterByokKeyArgs']]:
        return pulumi.get(self, "byok_key")

    @byok_key.setter
    def byok_key(self, value: Optional[pulumi.Input['KafkaClusterByokKeyArgs']]):
        pulumi.set(self, "byok_key", value)

    @_builtins.property
    @pulumi.getter
    def dedicated(self) -> Optional[pulumi.Input['KafkaClusterDedicatedArgs']]:
        """
        (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        """
        return pulumi.get(self, "dedicated")

    @dedicated.setter
    def dedicated(self, value: Optional[pulumi.Input['KafkaClusterDedicatedArgs']]):
        pulumi.set(self, "dedicated", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kafka cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enterprises(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]]:
        """
        The configuration of the Enterprise Kafka cluster.
        """
        return pulumi.get(self, "enterprises")

    @enterprises.setter
    def enterprises(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]]):
        pulumi.set(self, "enterprises", value)

    @_builtins.property
    @pulumi.getter
    def freights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]]:
        """
        The configuration of the Freight Kafka cluster.
        """
        return pulumi.get(self, "freights")

    @freights.setter
    def freights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]]):
        pulumi.set(self, "freights", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['KafkaClusterNetworkArgs']]:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['KafkaClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def standard(self) -> Optional[pulumi.Input['KafkaClusterStandardArgs']]:
        """
        The configuration of the Standard Kafka cluster.
        """
        return pulumi.get(self, "standard")

    @standard.setter
    def standard(self, value: Optional[pulumi.Input['KafkaClusterStandardArgs']]):
        pulumi.set(self, "standard", value)


@pulumi.input_type
class _KafkaClusterState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 availability: Optional[pulumi.Input[_builtins.str]] = None,
                 basic: Optional[pulumi.Input['KafkaClusterBasicArgs']] = None,
                 bootstrap_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 byok_key: Optional[pulumi.Input['KafkaClusterByokKeyArgs']] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated: Optional[pulumi.Input['KafkaClusterDedicatedArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEndpointArgs']]]] = None,
                 enterprises: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]] = None,
                 environment: Optional[pulumi.Input['KafkaClusterEnvironmentArgs']] = None,
                 freights: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['KafkaClusterNetworkArgs']] = None,
                 rbac_crn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 standard: Optional[pulumi.Input['KafkaClusterStandardArgs']] = None):
        """
        Input properties used for looking up and filtering KafkaCluster resources.
        :param pulumi.Input[_builtins.str] api_version: (Required String) An API Version of the schema version of the Kafka cluster, for example, `cmk/v2`.
        :param pulumi.Input[_builtins.str] availability: The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        :param pulumi.Input['KafkaClusterBasicArgs'] basic: The configuration of the Basic Kafka cluster.
        :param pulumi.Input[_builtins.str] bootstrap_endpoint: (Required String) The bootstrap endpoint used by Kafka clients to connect to the cluster (for example, `lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:9092`).
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input['KafkaClusterDedicatedArgs'] dedicated: (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterEndpointArgs']]] endpoints: (Optional List) The list of endpoints for connecting to the Kafka cluster. These endpoints provide different network access methods or regions for connecting to the cluster:
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]] enterprises: The configuration of the Enterprise Kafka cluster.
        :param pulumi.Input['KafkaClusterEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]] freights: The configuration of the Freight Kafka cluster.
        :param pulumi.Input[_builtins.str] kind: (Required String) A kind of the Kafka cluster, for example, `Cluster`.
        :param pulumi.Input['KafkaClusterNetworkArgs'] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        :param pulumi.Input[_builtins.str] rbac_crn: (Required String) The Confluent Resource Name of the Kafka cluster, for example, `crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-abc123/cloud-cluster=lkc-abc123`.
        :param pulumi.Input[_builtins.str] region: The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        :param pulumi.Input[_builtins.str] rest_endpoint: (Required String) The REST endpoint of the Kafka cluster (for example, `https://lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:443`).
        :param pulumi.Input['KafkaClusterStandardArgs'] standard: The configuration of the Standard Kafka cluster.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if bootstrap_endpoint is not None:
            pulumi.set(__self__, "bootstrap_endpoint", bootstrap_endpoint)
        if byok_key is not None:
            pulumi.set(__self__, "byok_key", byok_key)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if dedicated is not None:
            pulumi.set(__self__, "dedicated", dedicated)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enterprises is not None:
            pulumi.set(__self__, "enterprises", enterprises)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if freights is not None:
            pulumi.set(__self__, "freights", freights)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if rbac_crn is not None:
            pulumi.set(__self__, "rbac_crn", rbac_crn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if standard is not None:
            pulumi.set(__self__, "standard", standard)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) An API Version of the schema version of the Kafka cluster, for example, `cmk/v2`.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def availability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability", value)

    @_builtins.property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['KafkaClusterBasicArgs']]:
        """
        The configuration of the Basic Kafka cluster.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['KafkaClusterBasicArgs']]):
        pulumi.set(self, "basic", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapEndpoint")
    def bootstrap_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The bootstrap endpoint used by Kafka clients to connect to the cluster (for example, `lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:9092`).
        """
        return pulumi.get(self, "bootstrap_endpoint")

    @bootstrap_endpoint.setter
    def bootstrap_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bootstrap_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="byokKey")
    def byok_key(self) -> Optional[pulumi.Input['KafkaClusterByokKeyArgs']]:
        return pulumi.get(self, "byok_key")

    @byok_key.setter
    def byok_key(self, value: Optional[pulumi.Input['KafkaClusterByokKeyArgs']]):
        pulumi.set(self, "byok_key", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter
    def dedicated(self) -> Optional[pulumi.Input['KafkaClusterDedicatedArgs']]:
        """
        (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        """
        return pulumi.get(self, "dedicated")

    @dedicated.setter
    def dedicated(self, value: Optional[pulumi.Input['KafkaClusterDedicatedArgs']]):
        pulumi.set(self, "dedicated", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kafka cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEndpointArgs']]]]:
        """
        (Optional List) The list of endpoints for connecting to the Kafka cluster. These endpoints provide different network access methods or regions for connecting to the cluster:
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def enterprises(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]]:
        """
        The configuration of the Enterprise Kafka cluster.
        """
        return pulumi.get(self, "enterprises")

    @enterprises.setter
    def enterprises(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterEnterpriseArgs']]]]):
        pulumi.set(self, "enterprises", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['KafkaClusterEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['KafkaClusterEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def freights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]]:
        """
        The configuration of the Freight Kafka cluster.
        """
        return pulumi.get(self, "freights")

    @freights.setter
    def freights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaClusterFreightArgs']]]]):
        pulumi.set(self, "freights", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) A kind of the Kafka cluster, for example, `Cluster`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['KafkaClusterNetworkArgs']]:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['KafkaClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="rbacCrn")
    def rbac_crn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The Confluent Resource Name of the Kafka cluster, for example, `crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-abc123/cloud-cluster=lkc-abc123`.
        """
        return pulumi.get(self, "rbac_crn")

    @rbac_crn.setter
    def rbac_crn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rbac_crn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required String) The REST endpoint of the Kafka cluster (for example, `https://lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:443`).
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def standard(self) -> Optional[pulumi.Input['KafkaClusterStandardArgs']]:
        """
        The configuration of the Standard Kafka cluster.
        """
        return pulumi.get(self, "standard")

    @standard.setter
    def standard(self, value: Optional[pulumi.Input['KafkaClusterStandardArgs']]):
        pulumi.set(self, "standard", value)


@pulumi.type_token("confluentcloud:index/kafkaCluster:KafkaCluster")
class KafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability: Optional[pulumi.Input[_builtins.str]] = None,
                 basic: Optional[pulumi.Input[Union['KafkaClusterBasicArgs', 'KafkaClusterBasicArgsDict']]] = None,
                 byok_key: Optional[pulumi.Input[Union['KafkaClusterByokKeyArgs', 'KafkaClusterByokKeyArgsDict']]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated: Optional[pulumi.Input[Union['KafkaClusterDedicatedArgs', 'KafkaClusterDedicatedArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprises: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEnterpriseArgs', 'KafkaClusterEnterpriseArgsDict']]]]] = None,
                 environment: Optional[pulumi.Input[Union['KafkaClusterEnvironmentArgs', 'KafkaClusterEnvironmentArgsDict']]] = None,
                 freights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterFreightArgs', 'KafkaClusterFreightArgsDict']]]]] = None,
                 network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 standard: Optional[pulumi.Input[Union['KafkaClusterStandardArgs', 'KafkaClusterStandardArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example Kafka clusters on AWS

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AWS",
            region="us-east-2",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AWS",
            region="us-east-2",
            standard={},
            environment={
                "id": development.id,
            })
        enterprise = confluentcloud.KafkaCluster("enterprise",
            enterprises=[{}],
            display_name="enterprise_kafka_cluster",
            availability="HIGH",
            cloud="AWS",
            region="us-east-2",
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="AWS",
            region="us-east-2",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        freight = confluentcloud.KafkaCluster("freight",
            freights=[{}],
            display_name="freight_kafka_cluster",
            availability="HIGH",
            cloud="AWS",
            region="us-east-1",
            environment={
                "id": staging["id"],
            })
        ```

        ### Example Kafka clusters on Azure

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AZURE",
            region="centralus",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AZURE",
            region="centralus",
            standard={},
            environment={
                "id": development.id,
            })
        enterprise = confluentcloud.KafkaCluster("enterprise",
            enterprises=[{}],
            display_name="enterprise_kafka_cluster",
            availability="HIGH",
            cloud="AZURE",
            region="centralus",
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="AZURE",
            region="centralus",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        ```

        ### Example Kafka clusters on GCP

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="GCP",
            region="us-central1",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="GCP",
            region="us-central1",
            standard={},
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="GCP",
            region="us-central1",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `KafkaCluster` resource:
          * basic-kafka-acls: _Basic_ Kafka cluster with authorization using ACLs
          * basic-kafka-acls-with-alias: _Basic_ Kafka cluster with authorization using ACLs
          * standard-kafka-acls: _Standard_ Kafka cluster with authorization using ACLs
          * standard-kafka-rbac: _Standard_ Kafka cluster with authorization using RBAC
          * dedicated-public-kafka-acls: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using ACLs
          * dedicated-public-kafka-rbac: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using RBAC
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * enterprise-privatelinkattachment-azure-kafka-acls: _Enterprise_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * enterprise-pni-aws-kafka-rbac: _Enterprise_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC
          * freight-aws-kafka-rbac: _Freight_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC

        ## Import

        You can import a Kafka cluster by using Environment ID and Kafka cluster ID, in the format `<Environment ID>/<Kafka cluster ID>`, e.g.

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaCluster:KafkaCluster my_kafka env-abc123/lkc-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability: The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        :param pulumi.Input[Union['KafkaClusterBasicArgs', 'KafkaClusterBasicArgsDict']] basic: The configuration of the Basic Kafka cluster.
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Union['KafkaClusterDedicatedArgs', 'KafkaClusterDedicatedArgsDict']] dedicated: (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEnterpriseArgs', 'KafkaClusterEnterpriseArgsDict']]]] enterprises: The configuration of the Enterprise Kafka cluster.
        :param pulumi.Input[Union['KafkaClusterEnvironmentArgs', 'KafkaClusterEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterFreightArgs', 'KafkaClusterFreightArgsDict']]]] freights: The configuration of the Freight Kafka cluster.
        :param pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        :param pulumi.Input[_builtins.str] region: The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        :param pulumi.Input[Union['KafkaClusterStandardArgs', 'KafkaClusterStandardArgsDict']] standard: The configuration of the Standard Kafka cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example Kafka clusters on AWS

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AWS",
            region="us-east-2",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AWS",
            region="us-east-2",
            standard={},
            environment={
                "id": development.id,
            })
        enterprise = confluentcloud.KafkaCluster("enterprise",
            enterprises=[{}],
            display_name="enterprise_kafka_cluster",
            availability="HIGH",
            cloud="AWS",
            region="us-east-2",
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="AWS",
            region="us-east-2",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        freight = confluentcloud.KafkaCluster("freight",
            freights=[{}],
            display_name="freight_kafka_cluster",
            availability="HIGH",
            cloud="AWS",
            region="us-east-1",
            environment={
                "id": staging["id"],
            })
        ```

        ### Example Kafka clusters on Azure

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AZURE",
            region="centralus",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="AZURE",
            region="centralus",
            standard={},
            environment={
                "id": development.id,
            })
        enterprise = confluentcloud.KafkaCluster("enterprise",
            enterprises=[{}],
            display_name="enterprise_kafka_cluster",
            availability="HIGH",
            cloud="AZURE",
            region="centralus",
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="AZURE",
            region="centralus",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        ```

        ### Example Kafka clusters on GCP

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        basic = confluentcloud.KafkaCluster("basic",
            display_name="basic_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="GCP",
            region="us-central1",
            basic={},
            environment={
                "id": development.id,
            })
        standard = confluentcloud.KafkaCluster("standard",
            display_name="standard_kafka_cluster",
            availability="SINGLE_ZONE",
            cloud="GCP",
            region="us-central1",
            standard={},
            environment={
                "id": development.id,
            })
        dedicated = confluentcloud.KafkaCluster("dedicated",
            display_name="dedicated_kafka_cluster",
            availability="MULTI_ZONE",
            cloud="GCP",
            region="us-central1",
            dedicated={
                "cku": 2,
            },
            environment={
                "id": development.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `KafkaCluster` resource:
          * basic-kafka-acls: _Basic_ Kafka cluster with authorization using ACLs
          * basic-kafka-acls-with-alias: _Basic_ Kafka cluster with authorization using ACLs
          * standard-kafka-acls: _Standard_ Kafka cluster with authorization using ACLs
          * standard-kafka-rbac: _Standard_ Kafka cluster with authorization using RBAC
          * dedicated-public-kafka-acls: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using ACLs
          * dedicated-public-kafka-rbac: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using RBAC
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using RBAC
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * enterprise-privatelinkattachment-azure-kafka-acls: _Enterprise_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * enterprise-pni-aws-kafka-rbac: _Enterprise_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC
          * freight-aws-kafka-rbac: _Freight_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC

        ## Import

        You can import a Kafka cluster by using Environment ID and Kafka cluster ID, in the format `<Environment ID>/<Kafka cluster ID>`, e.g.

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaCluster:KafkaCluster my_kafka env-abc123/lkc-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param KafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability: Optional[pulumi.Input[_builtins.str]] = None,
                 basic: Optional[pulumi.Input[Union['KafkaClusterBasicArgs', 'KafkaClusterBasicArgsDict']]] = None,
                 byok_key: Optional[pulumi.Input[Union['KafkaClusterByokKeyArgs', 'KafkaClusterByokKeyArgsDict']]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated: Optional[pulumi.Input[Union['KafkaClusterDedicatedArgs', 'KafkaClusterDedicatedArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprises: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEnterpriseArgs', 'KafkaClusterEnterpriseArgsDict']]]]] = None,
                 environment: Optional[pulumi.Input[Union['KafkaClusterEnvironmentArgs', 'KafkaClusterEnvironmentArgsDict']]] = None,
                 freights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterFreightArgs', 'KafkaClusterFreightArgsDict']]]]] = None,
                 network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 standard: Optional[pulumi.Input[Union['KafkaClusterStandardArgs', 'KafkaClusterStandardArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaClusterArgs.__new__(KafkaClusterArgs)

            if availability is None and not opts.urn:
                raise TypeError("Missing required property 'availability'")
            __props__.__dict__["availability"] = availability
            __props__.__dict__["basic"] = basic
            __props__.__dict__["byok_key"] = byok_key
            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["dedicated"] = dedicated
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enterprises"] = enterprises
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["freights"] = freights
            __props__.__dict__["network"] = network
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["standard"] = standard
            __props__.__dict__["api_version"] = None
            __props__.__dict__["bootstrap_endpoint"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["rbac_crn"] = None
            __props__.__dict__["rest_endpoint"] = None
        super(KafkaCluster, __self__).__init__(
            'confluentcloud:index/kafkaCluster:KafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            availability: Optional[pulumi.Input[_builtins.str]] = None,
            basic: Optional[pulumi.Input[Union['KafkaClusterBasicArgs', 'KafkaClusterBasicArgsDict']]] = None,
            bootstrap_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            byok_key: Optional[pulumi.Input[Union['KafkaClusterByokKeyArgs', 'KafkaClusterByokKeyArgsDict']]] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated: Optional[pulumi.Input[Union['KafkaClusterDedicatedArgs', 'KafkaClusterDedicatedArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEndpointArgs', 'KafkaClusterEndpointArgsDict']]]]] = None,
            enterprises: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEnterpriseArgs', 'KafkaClusterEnterpriseArgsDict']]]]] = None,
            environment: Optional[pulumi.Input[Union['KafkaClusterEnvironmentArgs', 'KafkaClusterEnvironmentArgsDict']]] = None,
            freights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterFreightArgs', 'KafkaClusterFreightArgsDict']]]]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']]] = None,
            rbac_crn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            standard: Optional[pulumi.Input[Union['KafkaClusterStandardArgs', 'KafkaClusterStandardArgsDict']]] = None) -> 'KafkaCluster':
        """
        Get an existing KafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: (Required String) An API Version of the schema version of the Kafka cluster, for example, `cmk/v2`.
        :param pulumi.Input[_builtins.str] availability: The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        :param pulumi.Input[Union['KafkaClusterBasicArgs', 'KafkaClusterBasicArgsDict']] basic: The configuration of the Basic Kafka cluster.
        :param pulumi.Input[_builtins.str] bootstrap_endpoint: (Required String) The bootstrap endpoint used by Kafka clients to connect to the cluster (for example, `lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:9092`).
        :param pulumi.Input[_builtins.str] cloud: The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        :param pulumi.Input[Union['KafkaClusterDedicatedArgs', 'KafkaClusterDedicatedArgsDict']] dedicated: (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEndpointArgs', 'KafkaClusterEndpointArgsDict']]]] endpoints: (Optional List) The list of endpoints for connecting to the Kafka cluster. These endpoints provide different network access methods or regions for connecting to the cluster:
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterEnterpriseArgs', 'KafkaClusterEnterpriseArgsDict']]]] enterprises: The configuration of the Enterprise Kafka cluster.
        :param pulumi.Input[Union['KafkaClusterEnvironmentArgs', 'KafkaClusterEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaClusterFreightArgs', 'KafkaClusterFreightArgsDict']]]] freights: The configuration of the Freight Kafka cluster.
        :param pulumi.Input[_builtins.str] kind: (Required String) A kind of the Kafka cluster, for example, `Cluster`.
        :param pulumi.Input[Union['KafkaClusterNetworkArgs', 'KafkaClusterNetworkArgsDict']] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        :param pulumi.Input[_builtins.str] rbac_crn: (Required String) The Confluent Resource Name of the Kafka cluster, for example, `crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-abc123/cloud-cluster=lkc-abc123`.
        :param pulumi.Input[_builtins.str] region: The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        :param pulumi.Input[_builtins.str] rest_endpoint: (Required String) The REST endpoint of the Kafka cluster (for example, `https://lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:443`).
        :param pulumi.Input[Union['KafkaClusterStandardArgs', 'KafkaClusterStandardArgsDict']] standard: The configuration of the Standard Kafka cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaClusterState.__new__(_KafkaClusterState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["availability"] = availability
        __props__.__dict__["basic"] = basic
        __props__.__dict__["bootstrap_endpoint"] = bootstrap_endpoint
        __props__.__dict__["byok_key"] = byok_key
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["dedicated"] = dedicated
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enterprises"] = enterprises
        __props__.__dict__["environment"] = environment
        __props__.__dict__["freights"] = freights
        __props__.__dict__["kind"] = kind
        __props__.__dict__["network"] = network
        __props__.__dict__["rbac_crn"] = rbac_crn
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["standard"] = standard
        return KafkaCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) An API Version of the schema version of the Kafka cluster, for example, `cmk/v2`.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def availability(self) -> pulumi.Output[_builtins.str]:
        """
        The availability zone configuration of the Kafka cluster. Accepted values are: `SINGLE_ZONE`, `MULTI_ZONE`, `LOW`, and `HIGH`.
        """
        return pulumi.get(self, "availability")

    @_builtins.property
    @pulumi.getter
    def basic(self) -> pulumi.Output[Optional['outputs.KafkaClusterBasic']]:
        """
        The configuration of the Basic Kafka cluster.
        """
        return pulumi.get(self, "basic")

    @_builtins.property
    @pulumi.getter(name="bootstrapEndpoint")
    def bootstrap_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The bootstrap endpoint used by Kafka clients to connect to the cluster (for example, `lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:9092`).
        """
        return pulumi.get(self, "bootstrap_endpoint")

    @_builtins.property
    @pulumi.getter(name="byokKey")
    def byok_key(self) -> pulumi.Output['outputs.KafkaClusterByokKey']:
        return pulumi.get(self, "byok_key")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud service provider that runs the Kafka cluster. Accepted values are: `AWS`, `AZURE`, and `GCP`.
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter
    def dedicated(self) -> pulumi.Output[Optional['outputs.KafkaClusterDedicated']]:
        """
        (Optional Configuration Block) The configuration of the Dedicated Kafka cluster. It supports the following:
        """
        return pulumi.get(self, "dedicated")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kafka cluster.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.KafkaClusterEndpoint']]:
        """
        (Optional List) The list of endpoints for connecting to the Kafka cluster. These endpoints provide different network access methods or regions for connecting to the cluster:
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def enterprises(self) -> pulumi.Output[Optional[Sequence['outputs.KafkaClusterEnterprise']]]:
        """
        The configuration of the Enterprise Kafka cluster.
        """
        return pulumi.get(self, "enterprises")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.KafkaClusterEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def freights(self) -> pulumi.Output[Optional[Sequence['outputs.KafkaClusterFreight']]]:
        """
        The configuration of the Freight Kafka cluster.
        """
        return pulumi.get(self, "freights")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) A kind of the Kafka cluster, for example, `Cluster`.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.KafkaClusterNetwork']:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider accounts.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="rbacCrn")
    def rbac_crn(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The Confluent Resource Name of the Kafka cluster, for example, `crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-abc123/cloud-cluster=lkc-abc123`.
        """
        return pulumi.get(self, "rbac_crn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud service provider region where the Kafka cluster is running, for example, `us-west-2`. See [Cloud Providers and Regions](https://docs.confluent.io/cloud/current/clusters/regions.html#cloud-providers-and-regions) for a full list of options for AWS, Azure, and GCP.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Required String) The REST endpoint of the Kafka cluster (for example, `https://lkc-abc123-apfoo123.eu-west-3.aws.accesspoint.glb.confluent.cloud:443`).
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter
    def standard(self) -> pulumi.Output[Optional['outputs.KafkaClusterStandard']]:
        """
        The configuration of the Standard Kafka cluster.
        """
        return pulumi.get(self, "standard")

