# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[_builtins.str],
                 subject_name: pulumi.Input[_builtins.str],
                 credentials: Optional[pulumi.Input['SchemaCredentialsArgs']] = None,
                 hard_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input['SchemaMetadataArgs']] = None,
                 recreate_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset: Optional[pulumi.Input['SchemaRulesetArgs']] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_references: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]] = None,
                 schema_registry_cluster: Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']] = None,
                 skip_validation_during_plan: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[_builtins.str] format: The format of the Schema.
        :param pulumi.Input[_builtins.str] subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        :param pulumi.Input['SchemaCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.bool] hard_delete: Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        :param pulumi.Input[_builtins.bool] recreate_on_update: Controls whether a schema should be recreated on update.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
               - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] schema: The definition of the Schema.
        :param pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]] schema_references: The list of references to other Schemas.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "subject_name", subject_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if hard_delete is not None:
            pulumi.set(__self__, "hard_delete", hard_delete)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recreate_on_update is not None:
            pulumi.set(__self__, "recreate_on_update", recreate_on_update)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if ruleset is not None:
            pulumi.set(__self__, "ruleset", ruleset)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_references is not None:
            pulumi.set(__self__, "schema_references", schema_references)
        if schema_registry_cluster is not None:
            pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)
        if skip_validation_during_plan is not None:
            pulumi.set(__self__, "skip_validation_during_plan", skip_validation_during_plan)

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Input[_builtins.str]:
        """
        The format of the Schema.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        """
        return pulumi.get(self, "subject_name")

    @subject_name.setter
    def subject_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subject_name", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['SchemaCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['SchemaCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="hardDelete")
    def hard_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        """
        return pulumi.get(self, "hard_delete")

    @hard_delete.setter
    def hard_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hard_delete", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SchemaMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SchemaMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="recreateOnUpdate")
    def recreate_on_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether a schema should be recreated on update.
        """
        return pulumi.get(self, "recreate_on_update")

    @recreate_on_update.setter
    def recreate_on_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recreate_on_update", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
        - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def ruleset(self) -> Optional[pulumi.Input['SchemaRulesetArgs']]:
        return pulumi.get(self, "ruleset")

    @ruleset.setter
    def ruleset(self, value: Optional[pulumi.Input['SchemaRulesetArgs']]):
        pulumi.set(self, "ruleset", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The definition of the Schema.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]]:
        """
        The list of references to other Schemas.
        """
        return pulumi.get(self, "schema_references")

    @schema_references.setter
    def schema_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]]):
        pulumi.set(self, "schema_references", value)

    @_builtins.property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']]:
        return pulumi.get(self, "schema_registry_cluster")

    @schema_registry_cluster.setter
    def schema_registry_cluster(self, value: Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']]):
        pulumi.set(self, "schema_registry_cluster", value)

    @_builtins.property
    @pulumi.getter(name="skipValidationDuringPlan")
    def skip_validation_during_plan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_validation_during_plan")

    @skip_validation_during_plan.setter
    def skip_validation_during_plan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation_during_plan", value)


@pulumi.input_type
class _SchemaState:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input['SchemaCredentialsArgs']] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 hard_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input['SchemaMetadataArgs']] = None,
                 recreate_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset: Optional[pulumi.Input['SchemaRulesetArgs']] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_identifier: Optional[pulumi.Input[_builtins.int]] = None,
                 schema_references: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]] = None,
                 schema_registry_cluster: Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']] = None,
                 skip_validation_during_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Schema resources.
        :param pulumi.Input['SchemaCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] format: The format of the Schema.
        :param pulumi.Input[_builtins.bool] hard_delete: Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        :param pulumi.Input[_builtins.bool] recreate_on_update: Controls whether a schema should be recreated on update.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
               - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] schema: The definition of the Schema.
        :param pulumi.Input[_builtins.int] schema_identifier: (Required Integer) The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
        :param pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]] schema_references: The list of references to other Schemas.
        :param pulumi.Input[_builtins.str] subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        :param pulumi.Input[_builtins.int] version: (Required Integer) The version of the Schema, for example, `4`.
        """
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if hard_delete is not None:
            pulumi.set(__self__, "hard_delete", hard_delete)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recreate_on_update is not None:
            pulumi.set(__self__, "recreate_on_update", recreate_on_update)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if ruleset is not None:
            pulumi.set(__self__, "ruleset", ruleset)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_identifier is not None:
            pulumi.set(__self__, "schema_identifier", schema_identifier)
        if schema_references is not None:
            pulumi.set(__self__, "schema_references", schema_references)
        if schema_registry_cluster is not None:
            pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)
        if skip_validation_during_plan is not None:
            pulumi.set(__self__, "skip_validation_during_plan", skip_validation_during_plan)
        if subject_name is not None:
            pulumi.set(__self__, "subject_name", subject_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['SchemaCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['SchemaCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the Schema.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="hardDelete")
    def hard_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        """
        return pulumi.get(self, "hard_delete")

    @hard_delete.setter
    def hard_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hard_delete", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SchemaMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SchemaMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="recreateOnUpdate")
    def recreate_on_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether a schema should be recreated on update.
        """
        return pulumi.get(self, "recreate_on_update")

    @recreate_on_update.setter
    def recreate_on_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recreate_on_update", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
        - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def ruleset(self) -> Optional[pulumi.Input['SchemaRulesetArgs']]:
        return pulumi.get(self, "ruleset")

    @ruleset.setter
    def ruleset(self, value: Optional[pulumi.Input['SchemaRulesetArgs']]):
        pulumi.set(self, "ruleset", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The definition of the Schema.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaIdentifier")
    def schema_identifier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Required Integer) The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
        """
        return pulumi.get(self, "schema_identifier")

    @schema_identifier.setter
    def schema_identifier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "schema_identifier", value)

    @_builtins.property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]]:
        """
        The list of references to other Schemas.
        """
        return pulumi.get(self, "schema_references")

    @schema_references.setter
    def schema_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaSchemaReferenceArgs']]]]):
        pulumi.set(self, "schema_references", value)

    @_builtins.property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']]:
        return pulumi.get(self, "schema_registry_cluster")

    @schema_registry_cluster.setter
    def schema_registry_cluster(self, value: Optional[pulumi.Input['SchemaSchemaRegistryClusterArgs']]):
        pulumi.set(self, "schema_registry_cluster", value)

    @_builtins.property
    @pulumi.getter(name="skipValidationDuringPlan")
    def skip_validation_during_plan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_validation_during_plan")

    @skip_validation_during_plan.setter
    def skip_validation_during_plan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation_during_plan", value)

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        """
        return pulumi.get(self, "subject_name")

    @subject_name.setter
    def subject_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Required Integer) The version of the Schema, for example, `4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("confluentcloud:index/schema:Schema")
class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['SchemaCredentialsArgs', 'SchemaCredentialsArgsDict']]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 hard_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Union['SchemaMetadataArgs', 'SchemaMetadataArgsDict']]] = None,
                 recreate_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset: Optional[pulumi.Input[Union['SchemaRulesetArgs', 'SchemaRulesetArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchemaSchemaReferenceArgs', 'SchemaSchemaReferenceArgsDict']]]]] = None,
                 schema_registry_cluster: Optional[pulumi.Input[Union['SchemaSchemaRegistryClusterArgs', 'SchemaSchemaRegistryClusterArgsDict']]] = None,
                 skip_validation_during_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        avro_purchase = confluentcloud.Schema("avro-purchase",
            schema_registry_cluster={
                "id": essentials["id"],
            },
            rest_endpoint=essentials["restEndpoint"],
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"],
            credentials={
                "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
                "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
            })
        ```

        ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        avro_purchase = confluentcloud.Schema("avro-purchase",
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"])
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Schema` resource:
        * single-event-types-avro-schema
        * single-event-types-proto-schema
        * single-event-types-proto-schema-with-alias
        * multiple-event-types-avro-schema
        * multiple-event-types-proto-schema
        * field-level-encryption-schema

        ## Additional Examples

        ### Default Option A: Manage the latest schema version only. The resource instance always points to the latest schema version by supporting in-place updates

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        # confluent_schema.avro-purchase points to v1.
        avro_purchase = confluentcloud.Schema("avro-purchase",
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"],
            metadata={
                "properties": {
                    "owner": "Bob Jones",
                    "email": "bob@acme.com",
                },
                "sensitives": [
                    "s1",
                    "s2",
                ],
                "tags": [
                    {
                        "key": "tag1",
                        "values": ["PII"],
                    },
                    {
                        "key": "tag2",
                        "values": ["PIIIII"],
                    },
                ],
            },
            ruleset={
                "domain_rules": [
                    {
                        "name": "encryptPII",
                        "kind": "TRANSFORM",
                        "type": "ENCRYPT",
                        "mode": "WRITEREAD",
                        "tags": ["PII"],
                        "params": {
                            "encrypt.kek.name": "testkek2",
                        },
                    },
                    {
                        "name": "encrypt",
                        "kind": "TRANSFORM",
                        "type": "ENCRYPT",
                        "mode": "WRITEREAD",
                        "tags": ["PIIIII"],
                        "params": {
                            "encrypt.kek.name": "testkek2",
                        },
                    },
                ],
                "migration_rules": [{
                    "name": "encrypt",
                    "kind": "TRANSFORM",
                    "type": "ENCRYPT",
                    "mode": "WRITEREAD",
                    "tags": ["PIM"],
                    "params": {
                        "encrypt.kek.name": "testkekM",
                    },
                }],
            })
        ```

        ## Import

        You can import a Schema by using the Schema Registry cluster ID, Subject name, and unique identifier (or `latest` when `recreate_on_update = false`) of the Schema in the format `<Schema Registry cluster ID>/<Subject name>/<Schema identifier>`, for example:

        Option A: recreate_on_update = false (by default)

        $ export IMPORT_SCHEMA_REGISTRY_API_KEY="<schema_registry_api_key>"

        $ export IMPORT_SCHEMA_REGISTRY_API_SECRET="<schema_registry_api_secret>"

        $ export IMPORT_SCHEMA_REGISTRY_REST_ENDPOINT="<schema_registry_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/schema:Schema my_schema_1 lsrc-abc123/test-subject/latest
        ```

        Option B: recreate_on_update = true

        $ export IMPORT_SCHEMA_REGISTRY_API_KEY="<schema_registry_api_key>"

        $ export IMPORT_SCHEMA_REGISTRY_API_SECRET="<schema_registry_api_secret>"

        $ export IMPORT_SCHEMA_REGISTRY_REST_ENDPOINT="<schema_registry_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/schema:Schema my_schema_1 lsrc-abc123/test-subject/100003
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SchemaCredentialsArgs', 'SchemaCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] format: The format of the Schema.
        :param pulumi.Input[_builtins.bool] hard_delete: Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        :param pulumi.Input[_builtins.bool] recreate_on_update: Controls whether a schema should be recreated on update.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
               - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] schema: The definition of the Schema.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchemaSchemaReferenceArgs', 'SchemaSchemaReferenceArgsDict']]]] schema_references: The list of references to other Schemas.
        :param pulumi.Input[_builtins.str] subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        avro_purchase = confluentcloud.Schema("avro-purchase",
            schema_registry_cluster={
                "id": essentials["id"],
            },
            rest_endpoint=essentials["restEndpoint"],
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"],
            credentials={
                "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
                "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
            })
        ```

        ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        avro_purchase = confluentcloud.Schema("avro-purchase",
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"])
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Schema` resource:
        * single-event-types-avro-schema
        * single-event-types-proto-schema
        * single-event-types-proto-schema-with-alias
        * multiple-event-types-avro-schema
        * multiple-event-types-proto-schema
        * field-level-encryption-schema

        ## Additional Examples

        ### Default Option A: Manage the latest schema version only. The resource instance always points to the latest schema version by supporting in-place updates

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud
        import pulumi_std as std

        # confluent_schema.avro-purchase points to v1.
        avro_purchase = confluentcloud.Schema("avro-purchase",
            subject_name="avro-purchase-value",
            format="AVRO",
            schema=std.index.file(input="./schemas/avro/purchase.avsc")["result"],
            metadata={
                "properties": {
                    "owner": "Bob Jones",
                    "email": "bob@acme.com",
                },
                "sensitives": [
                    "s1",
                    "s2",
                ],
                "tags": [
                    {
                        "key": "tag1",
                        "values": ["PII"],
                    },
                    {
                        "key": "tag2",
                        "values": ["PIIIII"],
                    },
                ],
            },
            ruleset={
                "domain_rules": [
                    {
                        "name": "encryptPII",
                        "kind": "TRANSFORM",
                        "type": "ENCRYPT",
                        "mode": "WRITEREAD",
                        "tags": ["PII"],
                        "params": {
                            "encrypt.kek.name": "testkek2",
                        },
                    },
                    {
                        "name": "encrypt",
                        "kind": "TRANSFORM",
                        "type": "ENCRYPT",
                        "mode": "WRITEREAD",
                        "tags": ["PIIIII"],
                        "params": {
                            "encrypt.kek.name": "testkek2",
                        },
                    },
                ],
                "migration_rules": [{
                    "name": "encrypt",
                    "kind": "TRANSFORM",
                    "type": "ENCRYPT",
                    "mode": "WRITEREAD",
                    "tags": ["PIM"],
                    "params": {
                        "encrypt.kek.name": "testkekM",
                    },
                }],
            })
        ```

        ## Import

        You can import a Schema by using the Schema Registry cluster ID, Subject name, and unique identifier (or `latest` when `recreate_on_update = false`) of the Schema in the format `<Schema Registry cluster ID>/<Subject name>/<Schema identifier>`, for example:

        Option A: recreate_on_update = false (by default)

        $ export IMPORT_SCHEMA_REGISTRY_API_KEY="<schema_registry_api_key>"

        $ export IMPORT_SCHEMA_REGISTRY_API_SECRET="<schema_registry_api_secret>"

        $ export IMPORT_SCHEMA_REGISTRY_REST_ENDPOINT="<schema_registry_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/schema:Schema my_schema_1 lsrc-abc123/test-subject/latest
        ```

        Option B: recreate_on_update = true

        $ export IMPORT_SCHEMA_REGISTRY_API_KEY="<schema_registry_api_key>"

        $ export IMPORT_SCHEMA_REGISTRY_API_SECRET="<schema_registry_api_secret>"

        $ export IMPORT_SCHEMA_REGISTRY_REST_ENDPOINT="<schema_registry_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/schema:Schema my_schema_1 lsrc-abc123/test-subject/100003
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['SchemaCredentialsArgs', 'SchemaCredentialsArgsDict']]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 hard_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Union['SchemaMetadataArgs', 'SchemaMetadataArgsDict']]] = None,
                 recreate_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset: Optional[pulumi.Input[Union['SchemaRulesetArgs', 'SchemaRulesetArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchemaSchemaReferenceArgs', 'SchemaSchemaReferenceArgsDict']]]]] = None,
                 schema_registry_cluster: Optional[pulumi.Input[Union['SchemaSchemaRegistryClusterArgs', 'SchemaSchemaRegistryClusterArgsDict']]] = None,
                 skip_validation_during_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            __props__.__dict__["hard_delete"] = hard_delete
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["recreate_on_update"] = recreate_on_update
            __props__.__dict__["rest_endpoint"] = rest_endpoint
            __props__.__dict__["ruleset"] = ruleset
            __props__.__dict__["schema"] = schema
            __props__.__dict__["schema_references"] = schema_references
            __props__.__dict__["schema_registry_cluster"] = schema_registry_cluster
            __props__.__dict__["skip_validation_during_plan"] = skip_validation_during_plan
            if subject_name is None and not opts.urn:
                raise TypeError("Missing required property 'subject_name'")
            __props__.__dict__["subject_name"] = subject_name
            __props__.__dict__["schema_identifier"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Schema, __self__).__init__(
            'confluentcloud:index/schema:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials: Optional[pulumi.Input[Union['SchemaCredentialsArgs', 'SchemaCredentialsArgsDict']]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            hard_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Union['SchemaMetadataArgs', 'SchemaMetadataArgsDict']]] = None,
            recreate_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            ruleset: Optional[pulumi.Input[Union['SchemaRulesetArgs', 'SchemaRulesetArgsDict']]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            schema_identifier: Optional[pulumi.Input[_builtins.int]] = None,
            schema_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchemaSchemaReferenceArgs', 'SchemaSchemaReferenceArgsDict']]]]] = None,
            schema_registry_cluster: Optional[pulumi.Input[Union['SchemaSchemaRegistryClusterArgs', 'SchemaSchemaRegistryClusterArgsDict']]] = None,
            skip_validation_during_plan: Optional[pulumi.Input[_builtins.bool]] = None,
            subject_name: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SchemaCredentialsArgs', 'SchemaCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] format: The format of the Schema.
        :param pulumi.Input[_builtins.bool] hard_delete: Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        :param pulumi.Input[_builtins.bool] recreate_on_update: Controls whether a schema should be recreated on update.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
               - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
               - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        :param pulumi.Input[_builtins.str] schema: The definition of the Schema.
        :param pulumi.Input[_builtins.int] schema_identifier: (Required Integer) The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchemaSchemaReferenceArgs', 'SchemaSchemaReferenceArgsDict']]]] schema_references: The list of references to other Schemas.
        :param pulumi.Input[_builtins.str] subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        :param pulumi.Input[_builtins.int] version: (Required Integer) The version of the Schema, for example, `4`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaState.__new__(_SchemaState)

        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["format"] = format
        __props__.__dict__["hard_delete"] = hard_delete
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["recreate_on_update"] = recreate_on_update
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["ruleset"] = ruleset
        __props__.__dict__["schema"] = schema
        __props__.__dict__["schema_identifier"] = schema_identifier
        __props__.__dict__["schema_references"] = schema_references
        __props__.__dict__["schema_registry_cluster"] = schema_registry_cluster
        __props__.__dict__["skip_validation_during_plan"] = skip_validation_during_plan
        __props__.__dict__["subject_name"] = subject_name
        __props__.__dict__["version"] = version
        return Schema(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.SchemaCredentials']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[_builtins.str]:
        """
        The format of the Schema.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="hardDelete")
    def hard_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls whether a schema should be soft or hard deleted. Set it to `true` if you want to hard delete a schema on destroy. Defaults to `false` (soft delete).
        """
        return pulumi.get(self, "hard_delete")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.SchemaMetadata']:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="recreateOnUpdate")
    def recreate_on_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls whether a schema should be recreated on update.
        """
        return pulumi.get(self, "recreate_on_update")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The REST endpoint of the Schema Registry cluster. For example, for public networking: `https://psrc-00000.us-central1.gcp.confluent.cloud`. In the case of private networking, the endpoint might look like `https://lsrc-abc123.pr1jy6.us-east-2.aws.confluent.cloud`. You can construct it using either:
        - `data.confluent_schema_registry_cluster.essentials.private_regional_rest_endpoints["us-east-2"]`, or
        - `https://${data.confluent_schema_registry_cluster.essentials.id}${data.confluent_network.main.endpoint_suffix}`
        """
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter
    def ruleset(self) -> pulumi.Output[Optional['outputs.SchemaRuleset']]:
        return pulumi.get(self, "ruleset")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The definition of the Schema.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaIdentifier")
    def schema_identifier(self) -> pulumi.Output[_builtins.int]:
        """
        (Required Integer) The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
        """
        return pulumi.get(self, "schema_identifier")

    @_builtins.property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> pulumi.Output[Optional[Sequence['outputs.SchemaSchemaReference']]]:
        """
        The list of references to other Schemas.
        """
        return pulumi.get(self, "schema_references")

    @_builtins.property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> pulumi.Output[Optional['outputs.SchemaSchemaRegistryCluster']]:
        return pulumi.get(self, "schema_registry_cluster")

    @_builtins.property
    @pulumi.getter(name="skipValidationDuringPlan")
    def skip_validation_during_plan(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "skip_validation_during_plan")

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
        """
        return pulumi.get(self, "subject_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        (Required Integer) The version of the Schema, for example, `4`.
        """
        return pulumi.get(self, "version")

