# Generating a New Alembic Revision

If you are using a MongoDB backend (the default), Alembic cannot use it directly.
Instead, a temporary SQLite "shadow" database is used to autogenerate migration scripts.

## Steps

1. Start from the `CveXplore` subdirectory under the repository root.
2. If `shadow.db` exists and its state is unknown, remove it.
3. Let Alembic create the database schema from the latest revision.

   ```bash
   cd "$(git rev-parse --show-toplevel)/CveXplore"
   rm "../shadow.db"
   ALEMBIC_SQLITE_SHADOW=1 alembic upgrade head
   ```

4. Use Alembic to autogenerate a new revision suggestion from the changes in the model.

   ```bash
   ALEMBIC_SQLITE_SHADOW=1 alembic revision --autogenerate -m "description"
   ```

The shadow DB is **only for generating migration paths**, not for normal app usage.
The `ALEMBIC_SQLITE_SHADOW` environment variable is used in `env.py`.

If you are using an SQL backend (PostgreSQL, MySQL, SQLite, etc.), Alembic should be
able to use your actual database directly, provided it is at the revision state before
you modified the database model. Using the shadow database guarantees the correct
starting state.

```bash
alembic revision --autogenerate -m "description"
```

**Important:** Before committing a new revision, verify that it correctly represents
your intended model changes. Adjust the autogenerated script manually if any
discrepancies are found.
