__version__ = '0.8.9'

# Importing supported filesystems explicitly so that they will get registered as an fsspec filesystem
import v3iofs  # noqa: F401

from .aggregations import (  # noqa: F401
    AggregateByKey, QueryByKey
)
from .dataframe import (  # noqa: F401
    ToDataFrame, ReduceToDataFrame
)
from .drivers import (  # noqa: F401
    Driver, NoopDriver, V3ioDriver
)
from .dtypes import (  # noqa: F401
    Event, FieldAggregator, SlidingWindows, FixedWindows, EmissionType, EmitPolicy, EmitAfterPeriod, EmitAfterWindow, EmitAfterMaxEvent,
    EmitAfterDelay, EmitEveryEvent, LateDataHandling, FixedWindowType
)
from .flow import (  # noqa: F401
    Filter, FlatMap, Flow, FlowError, JoinWithV3IOTable, SendToHttp, JoinWithTable, Map, Extend, Reduce, Batch,
    MapWithState, MapClass, Complete, Choice, Recover, HttpRequest, HttpResponse, build_flow, Context
)
from .sources import (  # noqa: F401
    SyncEmitSource, AsyncEmitSource, DataframeSource, CSVSource, ParquetSource
)
from .table import (  # noqa: F401
    Table
)
from .targets import (  # noqa: F401
    StreamTarget, CSVTarget, ParquetTarget, TSDBTarget, NoSqlTarget
)

# clear module namespace
del v3iofs
