# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.53.0-v202509190852-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class AgentsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def archive_agent(self, **kwargs):
        """
        Archive an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_agent(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_agent_with_http_info(**kwargs)
        else:
            (data) = self.archive_agent_with_http_info(**kwargs)
            return data

    def archive_agent_with_http_info(self, **kwargs):
        """
        Archive an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_agent_with_http_info(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `archive_agent`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_connection(self, **kwargs):
        """
        Archive a connection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_connection(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: The name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :param str connection_name: The name of the connection. The connection name can be obtained from the 'Connections' array in the response of 'GET /agents/{agentName}/connectors/{connectorName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_connection_with_http_info(**kwargs)
        else:
            (data) = self.archive_connection_with_http_info(**kwargs)
            return data

    def archive_connection_with_http_info(self, **kwargs):
        """
        Archive a connection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_connection_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: The name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :param str connection_name: The name of the connection. The connection name can be obtained from the 'Connections' array in the response of 'GET /agents/{agentName}/connectors/{connectorName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name', 'connector_name', 'connection_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `archive_connection`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `archive_connection`")
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `archive_connection`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']
        if 'connection_name' in params:
            path_params['connectionName'] = params['connection_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections/{connectionName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_connector(self, **kwargs):
        """
        Archive a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_connector(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: The name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_connector_with_http_info(**kwargs)
        else:
            (data) = self.archive_connector_with_http_info(**kwargs)
            return data

    def archive_connector_with_http_info(self, **kwargs):
        """
        Archive a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_connector_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: The name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: The name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name', 'connector_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `archive_connector`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `archive_connector`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def configured_directives(self, **kwargs):
        """
        Get the Run and Staged Versions for this instance and a sorted list of available installers
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configured_directives(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ConfiguredDirectivesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConfiguredDirectivesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.configured_directives_with_http_info(**kwargs)
        else:
            (data) = self.configured_directives_with_http_info(**kwargs)
            return data

    def configured_directives_with_http_info(self, **kwargs):
        """
        Get the Run and Staged Versions for this instance and a sorted list of available installers
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configured_directives_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ConfiguredDirectivesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConfiguredDirectivesOutputV1
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method configured_directives" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/remote-updates/configuredDirectives', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConfiguredDirectivesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_or_update_agent(self, **kwargs):
        """
        Create or update an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_agent(body=body_value, agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AgentInputV1 body: Agent information (required)
        :param str agent_name: Name of the agent to create or update. For update, the name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: AgentOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_or_update_agent_with_http_info(**kwargs)
        else:
            (data) = self.create_or_update_agent_with_http_info(**kwargs)
            return data

    def create_or_update_agent_with_http_info(self, **kwargs):
        """
        Create or update an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_agent_with_http_info(body=body_value, agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AgentInputV1 body: Agent information (required)
        :param str agent_name: Name of the agent to create or update. For update, the name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: AgentOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentOutputV1
        """

        all_params = ['body', 'agent_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_agent`")
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `create_or_update_agent`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AgentOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_or_update_connection(self, **kwargs):
        """
        Create or update a connection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_connection(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConnectionInputV1 body: Connection information (required)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection to create or update. For update, the connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :return: ConnectionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_or_update_connection_with_http_info(**kwargs)
        else:
            (data) = self.create_or_update_connection_with_http_info(**kwargs)
            return data

    def create_or_update_connection_with_http_info(self, **kwargs):
        """
        Create or update a connection
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_connection_with_http_info(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConnectionInputV1 body: Connection information (required)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection to create or update. For update, the connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :return: ConnectionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionOutputV1
        """

        all_params = ['body', 'agent_name', 'connector_name', 'connection_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_connection`")
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `create_or_update_connection`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `create_or_update_connection`")
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `create_or_update_connection`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']
        if 'connection_name' in params:
            path_params['connectionName'] = params['connection_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections/{connectionName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_or_update_connector(self, **kwargs):
        """
        Create or update a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_connector(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConnectorInputV1 body: Connector information (required)
        :param str agent_name: Name of the agent where connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to create or update. For update, the connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: ConnectorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_or_update_connector_with_http_info(**kwargs)
        else:
            (data) = self.create_or_update_connector_with_http_info(**kwargs)
            return data

    def create_or_update_connector_with_http_info(self, **kwargs):
        """
        Create or update a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_or_update_connector_with_http_info(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConnectorInputV1 body: Connector information (required)
        :param str agent_name: Name of the agent where connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to create or update. For update, the connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: ConnectorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorOutputV1
        """

        all_params = ['body', 'agent_name', 'connector_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_connector`")
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `create_or_update_connector`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `create_or_update_connector`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_secret_for_connection(self, **kwargs):
        """
        Delete a stored secret for a connection. Note that this does not restart the connection, which may be necessary for it to detect the secret change.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_secret_for_connection(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, secret=secret_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection from which to delete secret. The connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :param str secret: Name of the secret to delete (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_secret_for_connection_with_http_info(**kwargs)
        else:
            (data) = self.delete_secret_for_connection_with_http_info(**kwargs)
            return data

    def delete_secret_for_connection_with_http_info(self, **kwargs):
        """
        Delete a stored secret for a connection. Note that this does not restart the connection, which may be necessary for it to detect the secret change.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_secret_for_connection_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, secret=secret_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection from which to delete secret. The connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :param str secret: Name of the secret to delete (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name', 'connector_name', 'connection_name', 'secret']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_secret_for_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `delete_secret_for_connection`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `delete_secret_for_connection`")
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `delete_secret_for_connection`")
        # verify the required parameter 'secret' is set
        if ('secret' not in params) or (params['secret'] is None):
            raise ValueError("Missing the required parameter `secret` when calling `delete_secret_for_connection`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']
        if 'connection_name' in params:
            path_params['connectionName'] = params['connection_name']
        if 'secret' in params:
            path_params['secret'] = params['secret']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections/{connectionName}/secrets/{secret}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agent(self, **kwargs):
        """
        Get an agent and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agent(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent to get. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: AgentOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agent_with_http_info(**kwargs)
        else:
            (data) = self.get_agent_with_http_info(**kwargs)
            return data

    def get_agent_with_http_info(self, **kwargs):
        """
        Get an agent and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agent_with_http_info(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent to get. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: AgentOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgentOutputV1
        """

        all_params = ['agent_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `get_agent`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AgentOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agent_status(self, **kwargs):
        """
        Get the status of every connection in every agent that the user has access to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agent_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[AgentStatusV1]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AgentStatusV1]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agent_status_with_http_info(**kwargs)
        else:
            (data) = self.get_agent_status_with_http_info(**kwargs)
            return data

    def get_agent_status_with_http_info(self, **kwargs):
        """
        Get the status of every connection in every agent that the user has access to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agent_status_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[AgentStatusV1]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AgentStatusV1]
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/status', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'list[AgentStatusV1]'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_connection(self, **kwargs):
        """
        Get a connection and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connection(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to get. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :param str connection_name: Name of the connection to get. The connection name can be obtained from the 'Connections' array in the response of 'GET /agents/{agentName}/connectors/{connectorName}' (required)
        :return: ConnectionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_connection_with_http_info(**kwargs)
        else:
            (data) = self.get_connection_with_http_info(**kwargs)
            return data

    def get_connection_with_http_info(self, **kwargs):
        """
        Get a connection and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connection_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to get. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :param str connection_name: Name of the connection to get. The connection name can be obtained from the 'Connections' array in the response of 'GET /agents/{agentName}/connectors/{connectorName}' (required)
        :return: ConnectionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionOutputV1
        """

        all_params = ['agent_name', 'connector_name', 'connection_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `get_connection`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `get_connection`")
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `get_connection`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']
        if 'connection_name' in params:
            path_params['connectionName'] = params['connection_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections/{connectionName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_connections(self, **kwargs):
        """
        Gets the configuration of all connections of a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connections(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status/{detailsLevel} (required)
        :param str connector_name: Name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET /agents/{agentName}' (required)
        :return: ConnectionsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_connections_with_http_info(**kwargs)
        else:
            (data) = self.get_connections_with_http_info(**kwargs)
            return data

    def get_connections_with_http_info(self, **kwargs):
        """
        Gets the configuration of all connections of a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connections_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status/{detailsLevel} (required)
        :param str connector_name: Name of the connector. The connector name can be obtained from the 'Connector' array in the response of 'GET /agents/{agentName}' (required)
        :return: ConnectionsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionsOutputV1
        """

        all_params = ['agent_name', 'connector_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `get_connections`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `get_connections`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectionsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_connector(self, **kwargs):
        """
        Get a connector and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connector(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to get. The connector name can be obtained from the 'Connectors' array in the response of 'GET / agents / {agentName}' (required)
        :return: ConnectorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_connector_with_http_info(**kwargs)
        else:
            (data) = self.get_connector_with_http_info(**kwargs)
            return data

    def get_connector_with_http_info(self, **kwargs):
        """
        Get a connector and its configuration
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connector_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to get. The connector name can be obtained from the 'Connectors' array in the response of 'GET / agents / {agentName}' (required)
        :return: ConnectorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorOutputV1
        """

        all_params = ['agent_name', 'connector_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `get_connector`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `get_connector`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_connectors(self, **kwargs):
        """
        Gets the configuration of all connectors hosted by an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connectors(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: ConnectorsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_connectors_with_http_info(**kwargs)
        else:
            (data) = self.get_connectors_with_http_info(**kwargs)
            return data

    def get_connectors_with_http_info(self, **kwargs):
        """
        Gets the configuration of all connectors hosted by an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_connectors_with_http_info(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: ConnectorsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorsOutputV1
        """

        all_params = ['agent_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connectors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `get_connectors`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConnectorsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_datasources_status(self, **kwargs):
        """
        Get the status of every connection for every datasource that the user has access to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_datasources_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DatasourcesStatusOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DatasourcesStatusOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_datasources_status_with_http_info(**kwargs)
        else:
            (data) = self.get_datasources_status_with_http_info(**kwargs)
            return data

    def get_datasources_status_with_http_info(self, **kwargs):
        """
        Get the status of every connection for every datasource that the user has access to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_datasources_status_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DatasourcesStatusOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DatasourcesStatusOutputV1
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datasources_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/datasources-status', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'DatasourcesStatusOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_remote_update_directives(self, **kwargs):
        """
        Get update directives for the remote agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_remote_update_directives(machine_name=machine_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str machine_name: Name of the remote agent machine to get update directives (required)
        :return: RemoteAgentDirectivesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RemoteAgentDirectivesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_remote_update_directives_with_http_info(**kwargs)
        else:
            (data) = self.get_remote_update_directives_with_http_info(**kwargs)
            return data

    def get_remote_update_directives_with_http_info(self, **kwargs):
        """
        Get update directives for the remote agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_remote_update_directives_with_http_info(machine_name=machine_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str machine_name: Name of the remote agent machine to get update directives (required)
        :return: RemoteAgentDirectivesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RemoteAgentDirectivesOutputV1
        """

        all_params = ['machine_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_update_directives" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'machine_name' is set
        if ('machine_name' not in params) or (params['machine_name'] is None):
            raise ValueError("Missing the required parameter `machine_name` when calling `get_remote_update_directives`")


        collection_formats = {}

        path_params = {}
        if 'machine_name' in params:
            path_params['machineName'] = params['machine_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/remote-updates/{machineName}/directives', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'RemoteAgentDirectivesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def index(self, **kwargs):
        """
        Request indexing of the given datasource.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.index(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IndexingParametersInputV1 body: IndexingParameters (required)
        :param str datasource_class: Datasource class of the connection (required)
        :param str datasource_id: Datasource ID of the connection (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.index_with_http_info(**kwargs)
        else:
            (data) = self.index_with_http_info(**kwargs)
            return data

    def index_with_http_info(self, **kwargs):
        """
        Request indexing of the given datasource.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.index_with_http_info(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IndexingParametersInputV1 body: IndexingParameters (required)
        :param str datasource_class: Datasource class of the connection (required)
        :param str datasource_id: Datasource ID of the connection (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body', 'datasource_class', 'datasource_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `index`")
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `index`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `index`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{datasourceClass}/{datasourceId}/index', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_agent_status(self, **kwargs):
        """
        Post the status of every connection in an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_agent_status(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AgentStatusV1 body: Connection status from a single agent (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_agent_status_with_http_info(**kwargs)
        else:
            (data) = self.post_agent_status_with_http_info(**kwargs)
            return data

    def post_agent_status_with_http_info(self, **kwargs):
        """
        Post the status of every connection in an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_agent_status_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AgentStatusV1 body: Connection status from a single agent (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_agent_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_agent_status`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/status', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def pre_provision(self, **kwargs):
        """
        Pre-provision the user for an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pre_provision(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PreProvisionInputV1 body: Agent pre-provisioning information (required)
        :return: PreProvisionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PreProvisionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.pre_provision_with_http_info(**kwargs)
        else:
            (data) = self.pre_provision_with_http_info(**kwargs)
            return data

    def pre_provision_with_http_info(self, **kwargs):
        """
        Pre-provision the user for an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pre_provision_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PreProvisionInputV1 body: Agent pre-provisioning information (required)
        :return: PreProvisionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PreProvisionOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pre_provision" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `pre_provision`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/pre-provision', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'PreProvisionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def provision(self, **kwargs):
        """
        Finish the user provisioning for an agent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.provision(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProvisionInputV1 body: Provision input (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.provision_with_http_info(**kwargs)
        else:
            (data) = self.provision_with_http_info(**kwargs)
            return data

    def provision_with_http_info(self, **kwargs):
        """
        Finish the user provisioning for an agent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.provision_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProvisionInputV1 body: Provision input (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method provision" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `provision`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/provision', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def restart_agent(self, **kwargs):
        """
        Restart an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_agent(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent to restart. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.restart_agent_with_http_info(**kwargs)
        else:
            (data) = self.restart_agent_with_http_info(**kwargs)
            return data

    def restart_agent_with_http_info(self, **kwargs):
        """
        Restart an agent
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_agent_with_http_info(agent_name=agent_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent to restart. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `restart_agent`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/restart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def restart_connector(self, **kwargs):
        """
        Restart a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_connector(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to restart. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.restart_connector_with_http_info(**kwargs)
        else:
            (data) = self.restart_connector_with_http_info(**kwargs)
            return data

    def restart_connector_with_http_info(self, **kwargs):
        """
        Restart a connector
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_connector_with_http_info(agent_name=agent_name_value, connector_name=connector_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str agent_name: Name of the agent. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector to restart. The connector name can be obtained from the 'Connector' array in the response of 'GET / agents / {agentName}' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['agent_name', 'connector_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `restart_connector`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `restart_connector`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/restart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def store_secret_for_connection(self, **kwargs):
        """
        Store a secret for a connection. Note that this does not restart the connection, which may be necessary for it to detect the secret change.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.store_secret_for_connection(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param StoreSecretInputV1 body: Secret to store. Key and value must not be blank and must be 256 characters or fewer (required)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection to which to store secret. The connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.store_secret_for_connection_with_http_info(**kwargs)
        else:
            (data) = self.store_secret_for_connection_with_http_info(**kwargs)
            return data

    def store_secret_for_connection_with_http_info(self, **kwargs):
        """
        Store a secret for a connection. Note that this does not restart the connection, which may be necessary for it to detect the secret change.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.store_secret_for_connection_with_http_info(body=body_value, agent_name=agent_name_value, connector_name=connector_name_value, connection_name=connection_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param StoreSecretInputV1 body: Secret to store. Key and value must not be blank and must be 256 characters or fewer (required)
        :param str agent_name: Name of the agent where the connector resides. The name of the agent can be obtained from the result of GET /agents/status or from the result of GET /agents/datasources-status (required)
        :param str connector_name: Name of the connector where the connection resides. The connector name can be obtained from the result of 'GET /agents/{agentName}/connectors' (required)
        :param str connection_name: Name of the connection to which to store secret. The connection name can be obtained from the result of 'GET /agents/{agentName}/connectors/{connectorName}/connections' (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body', 'agent_name', 'connector_name', 'connection_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method store_secret_for_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `store_secret_for_connection`")
        # verify the required parameter 'agent_name' is set
        if ('agent_name' not in params) or (params['agent_name'] is None):
            raise ValueError("Missing the required parameter `agent_name` when calling `store_secret_for_connection`")
        # verify the required parameter 'connector_name' is set
        if ('connector_name' not in params) or (params['connector_name'] is None):
            raise ValueError("Missing the required parameter `connector_name` when calling `store_secret_for_connection`")
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `store_secret_for_connection`")


        collection_formats = {}

        path_params = {}
        if 'agent_name' in params:
            path_params['agentName'] = params['agent_name']
        if 'connector_name' in params:
            path_params['connectorName'] = params['connector_name']
        if 'connection_name' in params:
            path_params['connectionName'] = params['connection_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/{agentName}/connectors/{connectorName}/connections/{connectionName}/secrets', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_directive(self, **kwargs):
        """
        Writes remote update directive config option and sets last updated timestamp
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_directive(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DirectiveInputV1 body: Directive info to update (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_directive_with_http_info(**kwargs)
        else:
            (data) = self.update_directive_with_http_info(**kwargs)
            return data

    def update_directive_with_http_info(self, **kwargs):
        """
        Writes remote update directive config option and sets last updated timestamp
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_directive_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DirectiveInputV1 body: Directive info to update (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_directive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_directive`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/remote-updates/updateDirective', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_remote_agent_status(self, **kwargs):
        """
        Create or update status of an agent-machine for remote-updates
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_remote_agent_status(body=body_value, machine_name=machine_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RemoteAgentStatusInputV1 body: Remote agent status (required)
        :param str machine_name: Name of the remote agent machine to create or update with new status (required)
        :return: RemoteAgentStatusOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RemoteAgentStatusOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_remote_agent_status_with_http_info(**kwargs)
        else:
            (data) = self.update_remote_agent_status_with_http_info(**kwargs)
            return data

    def update_remote_agent_status_with_http_info(self, **kwargs):
        """
        Create or update status of an agent-machine for remote-updates
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_remote_agent_status_with_http_info(body=body_value, machine_name=machine_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RemoteAgentStatusInputV1 body: Remote agent status (required)
        :param str machine_name: Name of the remote agent machine to create or update with new status (required)
        :return: RemoteAgentStatusOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RemoteAgentStatusOutputV1
        """

        all_params = ['body', 'machine_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_remote_agent_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_remote_agent_status`")
        # verify the required parameter 'machine_name' is set
        if ('machine_name' not in params) or (params['machine_name'] is None):
            raise ValueError("Missing the required parameter `machine_name` when calling `update_remote_agent_status`")


        collection_formats = {}

        path_params = {}
        if 'machine_name' in params:
            path_params['machineName'] = params['machine_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/agents/remote-updates/{machineName}/status', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'RemoteAgentStatusOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
