# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.53.0-v202509190852-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class UnstableApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def experimental(self, **kwargs):
        """
        Run an experimental Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.experimental(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: The formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.experimental_with_http_info(**kwargs)
        else:
            (data) = self.experimental_with_http_info(**kwargs)
            return data

    def experimental_with_http_info(self, **kwargs):
        """
        Run an experimental Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.experimental_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: The formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """

        all_params = ['formula', 'parameters', 'fragments']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method experimental" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'formula' in params:
            query_params.append(('formula', params['formula']))
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))
            collection_formats['parameters'] = 'multi'
        if 'fragments' in params:
            query_params.append(('fragments', params['fragments']))
            collection_formats['fragments'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/experimental', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaGenericOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def formula_explainer(self, **kwargs):
        """
        Compile a Seeq Formula and show details about the execution plan.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.formula_explainer(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.formula_explainer_with_http_info(**kwargs)
        else:
            (data) = self.formula_explainer_with_http_info(**kwargs)
            return data

    def formula_explainer_with_http_info(self, **kwargs):
        """
        Compile a Seeq Formula and show details about the execution plan.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.formula_explainer_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method formula_explainer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `formula_explainer`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/explainer', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaGenericOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_cache(self, **kwargs):
        """
        Get raw cache data associated with the supplied cacheId.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_cache(cache_id=cache_id_value, start=start_value, exclusive_end=exclusive_end_value, metadata_only=metadata_only_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cache_id: (required)
        :param str start: An 8601 timestamp corresponding to the key at the beginning of the query interval. (required)
        :param str exclusive_end: An 8601 timestamp corresponding to the key at the end of the query interval. (required)
        :param str max_datums: The maximum number of datums to retrieve from the persistent cache. If a request exceeds this value, the result will be truncated. Cannot be larger than: 1048576 unless `metadataOnly` is true.
        :param bool metadata_only: If set to true, the endpoint will only return cache record metadata (no decompression). (required)
        :param str override_timeout: A duration, in minutes, that should be used as a timeout for the GRPC connection. Default: 2 minutes.
        :return: DebugCacheBlockOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DebugCacheBlockOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_cache_with_http_info(**kwargs)
        else:
            (data) = self.get_cache_with_http_info(**kwargs)
            return data

    def get_cache_with_http_info(self, **kwargs):
        """
        Get raw cache data associated with the supplied cacheId.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_cache_with_http_info(cache_id=cache_id_value, start=start_value, exclusive_end=exclusive_end_value, metadata_only=metadata_only_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cache_id: (required)
        :param str start: An 8601 timestamp corresponding to the key at the beginning of the query interval. (required)
        :param str exclusive_end: An 8601 timestamp corresponding to the key at the end of the query interval. (required)
        :param str max_datums: The maximum number of datums to retrieve from the persistent cache. If a request exceeds this value, the result will be truncated. Cannot be larger than: 1048576 unless `metadataOnly` is true.
        :param bool metadata_only: If set to true, the endpoint will only return cache record metadata (no decompression). (required)
        :param str override_timeout: A duration, in minutes, that should be used as a timeout for the GRPC connection. Default: 2 minutes.
        :return: DebugCacheBlockOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DebugCacheBlockOutputV1
        """

        all_params = ['cache_id', 'start', 'exclusive_end', 'max_datums', 'metadata_only', 'override_timeout']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cache" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cache_id' is set
        if ('cache_id' not in params) or (params['cache_id'] is None):
            raise ValueError("Missing the required parameter `cache_id` when calling `get_cache`")
        # verify the required parameter 'start' is set
        if ('start' not in params) or (params['start'] is None):
            raise ValueError("Missing the required parameter `start` when calling `get_cache`")
        # verify the required parameter 'exclusive_end' is set
        if ('exclusive_end' not in params) or (params['exclusive_end'] is None):
            raise ValueError("Missing the required parameter `exclusive_end` when calling `get_cache`")
        # verify the required parameter 'metadata_only' is set
        if ('metadata_only' not in params) or (params['metadata_only'] is None):
            raise ValueError("Missing the required parameter `metadata_only` when calling `get_cache`")


        collection_formats = {}

        path_params = {}
        if 'cache_id' in params:
            path_params['cacheId'] = params['cache_id']

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'exclusive_end' in params:
            query_params.append(('exclusiveEnd', params['exclusive_end']))
        if 'max_datums' in params:
            query_params.append(('maxDatums', params['max_datums']))
        if 'metadata_only' in params:
            query_params.append(('metadataOnly', params['metadata_only']))
        if 'override_timeout' in params:
            query_params.append(('overrideTimeout', params['override_timeout']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/cache/{cacheId}/blocks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'DebugCacheBlockOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
