![](https://github.com/mariuzka/pop2net/actions/workflows/tox.yml/badge.svg)
![Python 3.11+](https://img.shields.io/badge/python->=3.11-blue.svg)

# Pop2net

Pop2net is a Python package that combines many steps related to network generation and management for agent-based modeling using a bipartite approach: 
In Pop2net, relations are represented as a graph of *actors* and *locations*. 
While actors are the active entities within an agent-based model, locations act as a contact layer, representing specific contexts through which actors connect. 
This makes it easy to generate and manage custom network structures in an agent-based model.

Pop2net can be used within custom modeling frameworks and also integrates seamlessly with the agent-based modeling frameworks [AgentPy](https://github.com/jofmi/agentpy) and [Mesa](https://github.com/projectmesa/mesa).


## Installation

You can install Pop2net using pip:

```
pip install pop2net
```


## Documentation

Detailed documentation of all features and a collection of example analyses can be found [here](https://mariuzka.github.io/pop2net/).
