"""Constants originally taken from SOEP survey wave (2018)."""

HH_TYPE = {
    "seniors": 0.239658,
    "no_children": 0.367392,
    "children": 0.390351,
}

AGE_DIST = {
    "child": {"loc": 9.554, "scale": 5.114},
    "adult": {"loc": 42.614, "scale": 14.417},
    "senior": {"loc": 64.221, "scale": 18.647},
}

# small amout of prob left for invalid -1 answer (0.1%)
GENDER_DIST = {
    "female": 0.495,
    "male": 0.495,
    "other": 0.01,
}

HH_SIZE = {
    "lam": 2.673,
}

HH_N_CHILDREN = {
    0: 0.303687,
    1: 0.233106,
    2: 0.34687,
    3: 0.075049,
    4: 0.028807,
    5: 0.008203,
    6: 0.002599,
    7: 0.001002,
    8: 0.000433,
    9: 0.000135,
    10: 8.1e-05,
    11: 2.7e-05,
}

WORKING_HOURS = {
    # of adults
    "at_all": 0.48,
    "8_hours": 0.2,
    "other": {"loc": 6.429, "scale": 2.92},
}


# only for persons that actually work
NACE2_DIVISIONS = {
    -2: 0,
    -1: 0.00409,
    1: 0.00752,
    2: 0.00098,
    5: 0.0006,
    6: 0.00027,
    8: 0.00038,
    10: 0.01591,
    11: 0.00087,
    12: 5e-05,
    13: 0.00185,
    14: 0.00093,
    15: 0.00038,
    16: 0.00294,
    17: 0.00213,
    18: 0.00343,
    19: 0.00022,
    20: 0.01046,
    21: 0.00403,
    22: 0.00627,
    23: 0.00229,
    24: 0.00322,
    25: 0.02284,
    26: 0.00583,
    27: 0.0176,
    28: 0.01973,
    29: 0.02938,
    30: 0.00283,
    31: 0.00202,
    32: 0.00621,
    33: 0.00147,
    35: 0.00741,
    36: 0.00114,
    37: 0.00087,
    38: 0.003,
    41: 0.01172,
    42: 0.00392,
    43: 0.02376,
    45: 0.0079,
    46: 0.01177,
    47: 0.07145,
    49: 0.01651,
    50: 0.00033,
    51: 0.0012,
    52: 0.01237,
    53: 0.00992,
    55: 0.00523,
    56: 0.02671,
    58: 0.00229,
    59: 0.00093,
    60: 0.00338,
    61: 0.00425,
    62: 0.01673,
    63: 0.0006,
    64: 0.01733,
    65: 0.00572,
    66: 0.00153,
    68: 0.00643,
    69: 0.01221,
    70: 0.00213,
    71: 0.01014,
    72: 0.0054,
    73: 0.00409,
    74: 0.00343,
    75: 0.00098,
    77: 0.00038,
    78: 0.00169,
    79: 0.00213,
    80: 0.00349,
    81: 0.02398,
    82: 0.00452,
    84: 0.0563,
    85: 0.06845,
    86: 0.07619,
    87: 0.0133,
    88: 0.03532,
    90: 0.00709,
    91: 0.00114,
    92: 0.00076,
    93: 0.00322,
    94: 0.0091,
    95: 0.00109,
    96: 0.0079,
    97: 0.00398,
    99: 0.00033,
}
