from enum import Enum


# https://docs.peppol.eu/poacc/billing/3.0/codelist/UNCL4461/
class PaymentMeansCode(Enum):
    INSTRUMENT_NOT_DEFINED = 1
    AUTOMATED_CLEARING_HOUSE_CREDIT = 2
    AUTOMATED_CLEARING_HOUSE_DEBIT = 3
    ACH_DEMAND_DEBIT_REVERSAL = 4
    ACH_DEMAND_CREDIT_REVERSAL = 5
    ACH_DEMAND_CREDIT = 6
    ACH_DEMAND_DEBIT = 7
    HOLD = 8
    NATIONAL_OR_REGIONAL_CLEARING = 9
    CASH = 10
    ACH_SAVINGS_CREDIT_REVERSAL = 11
    ACH_SAVINGS_DEBIT_REVERSAL = 12
    ACH_SAVINGS_CREDIT = 13
    ACH_SAVINGS_DEBIT = 14
    BOOKENTRY_CREDIT = 15
    BOOKENTRY_DEBIT = 16
    ACH_DEMAND_CCD_CREDIT = 17
    ACH_DEMAND_CCD_DEBIT = 18
    ACH_DEMAND_CTP_CREDIT = 19
    CHEQUE = 20
    BANKERS_DRAFT = 21
    CERTIFIED_BANKERS_DRAFT = 22
    BANK_CHEQUE = 23
    BILL_OF_EXCHANGE_AWAITING_ACCEPTANCE = 24
    CERTIFIED_CHEQUE = 25
    LOCAL_CHEQUE = 26
    ACH_DEMAND_CTP_DEBIT = 27
    ACH_DEMAND_CTX_CREDIT = 28
    ACH_DEMAND_CTX_DEBIT = 29
    CREDIT_TRANSFER = 30
    DEBIT_TRANSFER = 31
    ACH_DEMAND_CCD_PLUS_CREDIT = 32
    ACH_DEMAND_CCD_PLUS_DEBIT = 33
    ACH_PPD = 34
    ACH_SAVINGS_CCD_CREDIT = 35
    ACH_SAVINGS_CCD_DEBIT = 36
    ACH_SAVINGS_CTP_CREDIT = 37
    ACH_SAVINGS_CTP_DEBIT = 38
    ACH_SAVINGS_CTX_CREDIT = 39
    ACH_SAVINGS_CTX_DEBIT = 40
    ACH_SAVINGS_CCD_PLUS_CREDIT = 41
    PAYMENT_TO_BANK_ACCOUNT = 42
    ACH_SAVINGS_CCD_PLUS_DEBIT = 43
    ACCEPTED_BILL_OF_EXCHANGE = 44
    REFERENCED_HOME_BANKING_CREDIT_TRANSFER = 45
    INTERBANK_DEBIT_TRANSFER = 46
    HOME_BANKING_DEBIT_TRANSFER = 47
    BANK_CARD = 48
    DIRECT_DEBIT = 49
    PAYMENT_BY_POSTGIRO = 50
    FR_NORME_6_97_TELEREGLEMENT_CFONB = 51
    URGENT_COMMERCIAL_PAYMENT = 52
    URGENT_TREASURY_PAYMENT = 53
    CREDIT_CARD = 54
    DEBIT_CARD = 55
    BANKGIRO = 56
    STANDING_AGREEMENT = 57
    SEPA_CREDIT_TRANSFER = 58
    SEPA_DIRECT_DEBIT = 59
    PROMISSORY_NOTE = 60
    PROMISSORY_NOTE_SIGNED_BY_DEBTOR = 61
    PROMISSORY_NOTE_SIGNED_BY_DEBTOR_ENDORSED_BY_BANK = 62
    PROMISSORY_NOTE_SIGNED_BY_DEBTOR_ENDORSED_BY_THIRD_PARTY = 63
    PROMISSORY_NOTE_SIGNED_BY_BANK = 64
    PROMISSORY_NOTE_SIGNED_BY_BANK_ENDORSED_BY_ANOTHER_BANK = 65
    PROMISSORY_NOTE_SIGNED_BY_THIRD_PARTY = 66
    PROMISSORY_NOTE_SIGNED_BY_THIRD_PARTY_ENDORSED_BY_BANK = 67
    ONLINE_PAYMENT_SERVICE = 68
    BILL_DRAWN_BY_CREDITOR_ON_DEBTOR = 70
    BILL_DRAWN_BY_CREDITOR_ON_BANK = 74
    BILL_DRAWN_BY_CREDITOR_ENDORSED_BY_ANOTHER_BANK = 75
    BILL_DRAWN_BY_CREDITOR_ON_BANK_ENDORSED_BY_THIRD_PARTY = 76
    BILL_DRAWN_BY_CREDITOR_ON_THIRD_PARTY = 77
    BILL_DRAWN_BY_CREDITOR_ON_THIRD_PARTY_ENDORSED_BY_BANK = 78
    NOT_TRANSFERABLE_BANKERS_DRAFT = 91
    NOT_TRANSFERABLE_LOCAL_CHEQUE = 92
    REFERENCE_GIRO = 93
    URGENT_GIRO = 94
    FREE_FORMAT_GIRO = 95
    REQUESTED_METHOD_FOR_PAYMENT_WAS_NOT_USED = 96
    CLEARING_BETWEEN_PARTNERS = 97
    JP_ELECTRONICALLY_RECORDED_MONETARY_CLAIMS = 98
