"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = LambdaEventSourceMappingDestination;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const nag_rules_1 = require("../../nag-rules");
/**
 * Lambda Event Source Mappings must have a destination configured for failed invocations.
 *
 * @param node - The CfnResource to check
 */
function LambdaEventSourceMappingDestination(node) {
    if (node instanceof aws_lambda_1.CfnEventSourceMapping) {
        const destinationConfig = aws_cdk_lib_1.Stack.of(node).resolve(node.destinationConfig);
        if (destinationConfig?.onFailure &&
            destinationConfig?.onFailure?.destination) {
            return nag_rules_1.NagRuleCompliance.COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
    }
    return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTGFtYmRhRXZlbnRTb3VyY2VNYXBwaW5nRGVzdGluYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcnVsZXMvbGFtYmRhL0xhbWJkYUV2ZW50U291cmNlTWFwcGluZ0Rlc3RpbmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBYUEsc0RBY0M7QUEzQkQ7OztFQUdFO0FBQ0YsNkNBQWlEO0FBQ2pELHVEQUErRDtBQUMvRCwrQ0FBb0Q7QUFFcEQ7Ozs7R0FJRztBQUNILFNBQXdCLG1DQUFtQyxDQUN6RCxJQUFpQjtJQUVqQixJQUFJLElBQUksWUFBWSxrQ0FBcUIsRUFBRSxDQUFDO1FBQzFDLE1BQU0saUJBQWlCLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3pFLElBQ0UsaUJBQWlCLEVBQUUsU0FBUztZQUM1QixpQkFBaUIsRUFBRSxTQUFTLEVBQUUsV0FBVyxFQUN6QyxDQUFDO1lBQ0QsT0FBTyw2QkFBaUIsQ0FBQyxTQUFTLENBQUM7UUFDckMsQ0FBQztRQUNELE9BQU8sNkJBQWlCLENBQUMsYUFBYSxDQUFDO0lBQ3pDLENBQUM7SUFDRCxPQUFPLDZCQUFpQixDQUFDLGNBQWMsQ0FBQztBQUMxQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDZm5FdmVudFNvdXJjZU1hcHBpbmcgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IE5hZ1J1bGVDb21wbGlhbmNlIH0gZnJvbSAnLi4vLi4vbmFnLXJ1bGVzJztcblxuLyoqXG4gKiBMYW1iZGEgRXZlbnQgU291cmNlIE1hcHBpbmdzIG11c3QgaGF2ZSBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyZWQgZm9yIGZhaWxlZCBpbnZvY2F0aW9ucy5cbiAqXG4gKiBAcGFyYW0gbm9kZSAtIFRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBMYW1iZGFFdmVudFNvdXJjZU1hcHBpbmdEZXN0aW5hdGlvbihcbiAgbm9kZTogQ2ZuUmVzb3VyY2Vcbik6IE5hZ1J1bGVDb21wbGlhbmNlIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5FdmVudFNvdXJjZU1hcHBpbmcpIHtcbiAgICBjb25zdCBkZXN0aW5hdGlvbkNvbmZpZyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5kZXN0aW5hdGlvbkNvbmZpZyk7XG4gICAgaWYgKFxuICAgICAgZGVzdGluYXRpb25Db25maWc/Lm9uRmFpbHVyZSAmJlxuICAgICAgZGVzdGluYXRpb25Db25maWc/Lm9uRmFpbHVyZT8uZGVzdGluYXRpb25cbiAgICApIHtcbiAgICAgIHJldHVybiBOYWdSdWxlQ29tcGxpYW5jZS5DT01QTElBTlQ7XG4gICAgfVxuICAgIHJldHVybiBOYWdSdWxlQ29tcGxpYW5jZS5OT05fQ09NUExJQU5UO1xuICB9XG4gIHJldHVybiBOYWdSdWxlQ29tcGxpYW5jZS5OT1RfQVBQTElDQUJMRTtcbn1cbiJdfQ==