"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*!
Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2025)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import streamlit.proto.ArrowData_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class MixedData(google.protobuf.message.Message):
    """Mixed data structure that allows JSON with embedded Arrow references"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ArrowBlobsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> streamlit.proto.ArrowData_pb2.ArrowData: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: streamlit.proto.ArrowData_pb2.ArrowData | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    JSON_FIELD_NUMBER: builtins.int
    ARROW_BLOBS_FIELD_NUMBER: builtins.int
    json: builtins.str
    """The main JSON structure with arrow references replaced by placeholders"""
    @property
    def arrow_blobs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, streamlit.proto.ArrowData_pb2.ArrowData]:
        """Map of arrow data blobs keyed by reference ID"""

    def __init__(
        self,
        *,
        json: builtins.str = ...,
        arrow_blobs: collections.abc.Mapping[builtins.str, streamlit.proto.ArrowData_pb2.ArrowData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["arrow_blobs", b"arrow_blobs", "json", b"json"]) -> None: ...

global___MixedData = MixedData

@typing.final
class BidiComponent(google.protobuf.message.Message):
    """Represents an instance of a bidirectional component."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    JS_CONTENT_FIELD_NUMBER: builtins.int
    JS_SOURCE_PATH_FIELD_NUMBER: builtins.int
    FORM_ID_FIELD_NUMBER: builtins.int
    HTML_CONTENT_FIELD_NUMBER: builtins.int
    CSS_CONTENT_FIELD_NUMBER: builtins.int
    CSS_SOURCE_PATH_FIELD_NUMBER: builtins.int
    ISOLATE_STYLES_FIELD_NUMBER: builtins.int
    JSON_FIELD_NUMBER: builtins.int
    ARROW_DATA_FIELD_NUMBER: builtins.int
    BYTES_FIELD_NUMBER: builtins.int
    MIXED_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the widget instance."""
    component_name: builtins.str
    """The registered name of the component."""
    js_content: builtins.str
    """The JavaScript content provided by the developer."""
    js_source_path: builtins.str
    """The source path for the JavaScript content."""
    form_id: builtins.str
    """The ID of the form this component belongs to, if any."""
    html_content: builtins.str
    """The HTML content provided by the developer."""
    css_content: builtins.str
    """The CSS content provided by the developer."""
    css_source_path: builtins.str
    """The source path for the CSS content."""
    isolate_styles: builtins.bool
    """Whether to isolate styles from the parent."""
    json: builtins.str
    """JSON-serialized value for generic data payloads."""
    bytes: builtins.bytes
    """Arbitrary bytes payload."""
    @property
    def arrow_data(self) -> streamlit.proto.ArrowData_pb2.ArrowData:
        """Data-only Apache Arrow buffer for dataframe-like payloads."""

    @property
    def mixed(self) -> global___MixedData:
        """Mixed data with JSON structure + embedded Arrow references"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        component_name: builtins.str = ...,
        js_content: builtins.str | None = ...,
        js_source_path: builtins.str | None = ...,
        form_id: builtins.str = ...,
        html_content: builtins.str | None = ...,
        css_content: builtins.str | None = ...,
        css_source_path: builtins.str | None = ...,
        isolate_styles: builtins.bool = ...,
        json: builtins.str = ...,
        arrow_data: streamlit.proto.ArrowData_pb2.ArrowData | None = ...,
        bytes: builtins.bytes = ...,
        mixed: global___MixedData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_css_content", b"_css_content", "_css_source_path", b"_css_source_path", "_html_content", b"_html_content", "_js_content", b"_js_content", "_js_source_path", b"_js_source_path", "arrow_data", b"arrow_data", "bytes", b"bytes", "css_content", b"css_content", "css_source_path", b"css_source_path", "data", b"data", "html_content", b"html_content", "js_content", b"js_content", "js_source_path", b"js_source_path", "json", b"json", "mixed", b"mixed"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_css_content", b"_css_content", "_css_source_path", b"_css_source_path", "_html_content", b"_html_content", "_js_content", b"_js_content", "_js_source_path", b"_js_source_path", "arrow_data", b"arrow_data", "bytes", b"bytes", "component_name", b"component_name", "css_content", b"css_content", "css_source_path", b"css_source_path", "data", b"data", "form_id", b"form_id", "html_content", b"html_content", "id", b"id", "isolate_styles", b"isolate_styles", "js_content", b"js_content", "js_source_path", b"js_source_path", "json", b"json", "mixed", b"mixed"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_css_content", b"_css_content"]) -> typing.Literal["css_content"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_css_source_path", b"_css_source_path"]) -> typing.Literal["css_source_path"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_html_content", b"_html_content"]) -> typing.Literal["html_content"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_js_content", b"_js_content"]) -> typing.Literal["js_content"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_js_source_path", b"_js_source_path"]) -> typing.Literal["js_source_path"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["data", b"data"]) -> typing.Literal["json", "arrow_data", "bytes", "mixed"] | None: ...

global___BidiComponent = BidiComponent
