# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'Oauth',
]

@pulumi.output_type
class Oauth(dict):
    def __init__(__self__, *,
                 oauth_identity_pool_id: builtins.str,
                 oauth_external_access_token: Optional[builtins.str] = None,
                 oauth_external_client_id: Optional[builtins.str] = None,
                 oauth_external_client_secret: Optional[builtins.str] = None,
                 oauth_external_token_scope: Optional[builtins.str] = None,
                 oauth_external_token_url: Optional[builtins.str] = None,
                 oauth_sts_token_expired_in_seconds: Optional[builtins.str] = None):
        """
        :param builtins.str oauth_identity_pool_id: OAuth identity pool id used for processing external token and exchange STS token
        :param builtins.str oauth_external_access_token: OAuth existing access token already fetched from external IDP
        :param builtins.str oauth_external_client_id: OAuth client id from external token source
        :param builtins.str oauth_external_client_secret: OAuth client secret from external token source
        :param builtins.str oauth_external_token_scope: OAuth access token scope
        :param builtins.str oauth_external_token_url: OAuth token URL to fetch access token from external IDP
        :param builtins.str oauth_sts_token_expired_in_seconds: OAuth STS access token expired in second from Confluent Cloud
        """
        pulumi.set(__self__, "oauth_identity_pool_id", oauth_identity_pool_id)
        if oauth_external_access_token is not None:
            pulumi.set(__self__, "oauth_external_access_token", oauth_external_access_token)
        if oauth_external_client_id is not None:
            pulumi.set(__self__, "oauth_external_client_id", oauth_external_client_id)
        if oauth_external_client_secret is not None:
            pulumi.set(__self__, "oauth_external_client_secret", oauth_external_client_secret)
        if oauth_external_token_scope is not None:
            pulumi.set(__self__, "oauth_external_token_scope", oauth_external_token_scope)
        if oauth_external_token_url is not None:
            pulumi.set(__self__, "oauth_external_token_url", oauth_external_token_url)
        if oauth_sts_token_expired_in_seconds is not None:
            pulumi.set(__self__, "oauth_sts_token_expired_in_seconds", oauth_sts_token_expired_in_seconds)

    @property
    @pulumi.getter(name="oauthIdentityPoolId")
    def oauth_identity_pool_id(self) -> builtins.str:
        """
        OAuth identity pool id used for processing external token and exchange STS token
        """
        return pulumi.get(self, "oauth_identity_pool_id")

    @property
    @pulumi.getter(name="oauthExternalAccessToken")
    def oauth_external_access_token(self) -> Optional[builtins.str]:
        """
        OAuth existing access token already fetched from external IDP
        """
        return pulumi.get(self, "oauth_external_access_token")

    @property
    @pulumi.getter(name="oauthExternalClientId")
    def oauth_external_client_id(self) -> Optional[builtins.str]:
        """
        OAuth client id from external token source
        """
        return pulumi.get(self, "oauth_external_client_id")

    @property
    @pulumi.getter(name="oauthExternalClientSecret")
    def oauth_external_client_secret(self) -> Optional[builtins.str]:
        """
        OAuth client secret from external token source
        """
        return pulumi.get(self, "oauth_external_client_secret")

    @property
    @pulumi.getter(name="oauthExternalTokenScope")
    def oauth_external_token_scope(self) -> Optional[builtins.str]:
        """
        OAuth access token scope
        """
        return pulumi.get(self, "oauth_external_token_scope")

    @property
    @pulumi.getter(name="oauthExternalTokenUrl")
    def oauth_external_token_url(self) -> Optional[builtins.str]:
        """
        OAuth token URL to fetch access token from external IDP
        """
        return pulumi.get(self, "oauth_external_token_url")

    @property
    @pulumi.getter(name="oauthStsTokenExpiredInSeconds")
    def oauth_sts_token_expired_in_seconds(self) -> Optional[builtins.str]:
        """
        OAuth STS access token expired in second from Confluent Cloud
        """
        return pulumi.get(self, "oauth_sts_token_expired_in_seconds")


