# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogIntegrationResult',
    'AwaitableGetCatalogIntegrationResult',
    'get_catalog_integration',
    'get_catalog_integration_output',
]

@pulumi.output_type
class GetCatalogIntegrationResult:
    """
    A collection of values returned by getCatalogIntegration.
    """
    def __init__(__self__, aws_glues=None, credentials=None, display_name=None, environment=None, id=None, kafka_cluster=None, snowflakes=None, suspended=None):
        if aws_glues and not isinstance(aws_glues, list):
            raise TypeError("Expected argument 'aws_glues' to be a list")
        pulumi.set(__self__, "aws_glues", aws_glues)
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_cluster and not isinstance(kafka_cluster, dict):
            raise TypeError("Expected argument 'kafka_cluster' to be a dict")
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if snowflakes and not isinstance(snowflakes, list):
            raise TypeError("Expected argument 'snowflakes' to be a list")
        pulumi.set(__self__, "snowflakes", snowflakes)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)

    @property
    @pulumi.getter(name="awsGlues")
    def aws_glues(self) -> Sequence['outputs.GetCatalogIntegrationAwsGlueResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_glues")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetCatalogIntegrationCredentialsResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        (Required String) The name of the catalog integration.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GetCatalogIntegrationEnvironmentResult':
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> 'outputs.GetCatalogIntegrationKafkaClusterResult':
        return pulumi.get(self, "kafka_cluster")

    @property
    @pulumi.getter
    def snowflakes(self) -> Sequence['outputs.GetCatalogIntegrationSnowflakeResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "snowflakes")

    @property
    @pulumi.getter
    def suspended(self) -> builtins.bool:
        """
        (Optional Boolean) Indicates whether the Catalog Integration should be suspended.
        """
        return pulumi.get(self, "suspended")


class AwaitableGetCatalogIntegrationResult(GetCatalogIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogIntegrationResult(
            aws_glues=self.aws_glues,
            credentials=self.credentials,
            display_name=self.display_name,
            environment=self.environment,
            id=self.id,
            kafka_cluster=self.kafka_cluster,
            snowflakes=self.snowflakes,
            suspended=self.suspended)


def get_catalog_integration(credentials: Optional[Union['GetCatalogIntegrationCredentialsArgs', 'GetCatalogIntegrationCredentialsArgsDict']] = None,
                            environment: Optional[Union['GetCatalogIntegrationEnvironmentArgs', 'GetCatalogIntegrationEnvironmentArgsDict']] = None,
                            id: Optional[builtins.str] = None,
                            kafka_cluster: Optional[Union['GetCatalogIntegrationKafkaClusterArgs', 'GetCatalogIntegrationKafkaClusterArgsDict']] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogIntegrationResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `CatalogIntegration` describes a Catalog Integration data source.

    ## Example Usage


    :param builtins.str id: The ID of the Catalog Integration, for example, `tci-abc123`.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['environment'] = environment
    __args__['id'] = id
    __args__['kafkaCluster'] = kafka_cluster
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getCatalogIntegration:getCatalogIntegration', __args__, opts=opts, typ=GetCatalogIntegrationResult).value

    return AwaitableGetCatalogIntegrationResult(
        aws_glues=pulumi.get(__ret__, 'aws_glues'),
        credentials=pulumi.get(__ret__, 'credentials'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        kafka_cluster=pulumi.get(__ret__, 'kafka_cluster'),
        snowflakes=pulumi.get(__ret__, 'snowflakes'),
        suspended=pulumi.get(__ret__, 'suspended'))
def get_catalog_integration_output(credentials: Optional[pulumi.Input[Optional[Union['GetCatalogIntegrationCredentialsArgs', 'GetCatalogIntegrationCredentialsArgsDict']]]] = None,
                                   environment: Optional[pulumi.Input[Union['GetCatalogIntegrationEnvironmentArgs', 'GetCatalogIntegrationEnvironmentArgsDict']]] = None,
                                   id: Optional[pulumi.Input[builtins.str]] = None,
                                   kafka_cluster: Optional[pulumi.Input[Union['GetCatalogIntegrationKafkaClusterArgs', 'GetCatalogIntegrationKafkaClusterArgsDict']]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogIntegrationResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `CatalogIntegration` describes a Catalog Integration data source.

    ## Example Usage


    :param builtins.str id: The ID of the Catalog Integration, for example, `tci-abc123`.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['environment'] = environment
    __args__['id'] = id
    __args__['kafkaCluster'] = kafka_cluster
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getCatalogIntegration:getCatalogIntegration', __args__, opts=opts, typ=GetCatalogIntegrationResult)
    return __ret__.apply(lambda __response__: GetCatalogIntegrationResult(
        aws_glues=pulumi.get(__response__, 'aws_glues'),
        credentials=pulumi.get(__response__, 'credentials'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        kafka_cluster=pulumi.get(__response__, 'kafka_cluster'),
        snowflakes=pulumi.get(__response__, 'snowflakes'),
        suspended=pulumi.get(__response__, 'suspended')))
