# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectArtifactResult',
    'AwaitableGetConnectArtifactResult',
    'get_connect_artifact',
    'get_connect_artifact_output',
]

@pulumi.output_type
class GetConnectArtifactResult:
    """
    A collection of values returned by getConnectArtifact.
    """
    def __init__(__self__, cloud=None, content_format=None, description=None, display_name=None, environment=None, id=None):
        if cloud and not isinstance(cloud, str):
            raise TypeError("Expected argument 'cloud' to be a str")
        pulumi.set(__self__, "cloud", cloud)
        if content_format and not isinstance(content_format, str):
            raise TypeError("Expected argument 'content_format' to be a str")
        pulumi.set(__self__, "content_format", content_format)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def cloud(self) -> builtins.str:
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> builtins.str:
        """
        (String) Archive format of the Connect Artifact. Supported formats are `JAR` and `ZIP`.
        """
        return pulumi.get(self, "content_format")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        (String) Description of the Connect Artifact.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        (String) The unique name of the Connect Artifact per cloud, environment scope.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GetConnectArtifactEnvironmentResult':
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")


class AwaitableGetConnectArtifactResult(GetConnectArtifactResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectArtifactResult(
            cloud=self.cloud,
            content_format=self.content_format,
            description=self.description,
            display_name=self.display_name,
            environment=self.environment,
            id=self.id)


def get_connect_artifact(cloud: Optional[builtins.str] = None,
                         environment: Optional[Union['GetConnectArtifactEnvironmentArgs', 'GetConnectArtifactEnvironmentArgsDict']] = None,
                         id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectArtifactResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `ConnectArtifact` data source represents a Connect Artifact in Confluent Cloud. Connect Artifacts are used to store and manage custom connector plugins in Confluent Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_connect_artifact(id="ca-123456",
        environment={
            "id": "env-123456",
        },
        cloud="AWS")
    pulumi.export("artifactName", example.display_name)
    pulumi.export("artifactCloud", example.cloud)
    pulumi.export("artifactContentFormat", example.content_format)
    pulumi.export("artifactDescription", example.description)
    ```


    :param builtins.str cloud: Cloud provider where the Connect Artifact archive is uploaded.
    :param builtins.str id: The ID of the Connect Artifact.
    """
    __args__ = dict()
    __args__['cloud'] = cloud
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getConnectArtifact:getConnectArtifact', __args__, opts=opts, typ=GetConnectArtifactResult).value

    return AwaitableGetConnectArtifactResult(
        cloud=pulumi.get(__ret__, 'cloud'),
        content_format=pulumi.get(__ret__, 'content_format'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'))
def get_connect_artifact_output(cloud: Optional[pulumi.Input[builtins.str]] = None,
                                environment: Optional[pulumi.Input[Union['GetConnectArtifactEnvironmentArgs', 'GetConnectArtifactEnvironmentArgsDict']]] = None,
                                id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectArtifactResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `ConnectArtifact` data source represents a Connect Artifact in Confluent Cloud. Connect Artifacts are used to store and manage custom connector plugins in Confluent Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_connect_artifact(id="ca-123456",
        environment={
            "id": "env-123456",
        },
        cloud="AWS")
    pulumi.export("artifactName", example.display_name)
    pulumi.export("artifactCloud", example.cloud)
    pulumi.export("artifactContentFormat", example.content_format)
    pulumi.export("artifactDescription", example.description)
    ```


    :param builtins.str cloud: Cloud provider where the Connect Artifact archive is uploaded.
    :param builtins.str id: The ID of the Connect Artifact.
    """
    __args__ = dict()
    __args__['cloud'] = cloud
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getConnectArtifact:getConnectArtifact', __args__, opts=opts, typ=GetConnectArtifactResult)
    return __ret__.apply(lambda __response__: GetConnectArtifactResult(
        cloud=pulumi.get(__response__, 'cloud'),
        content_format=pulumi.get(__response__, 'content_format'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id')))
